/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.serverproxy;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.shared.message.EOFileMetaInformation;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategory;
import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.EORoleAndStakeholder;
import com.arcway.cockpit.frame.shared.message.EOSection;
import com.arcway.cockpit.frame.shared.message.EOStakeholder;
import com.arcway.cockpit.frame.shared.message.EOStakeholderRole;
import com.arcway.cockpit.frame.shared.message.EOUniqueElement;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import com.arcway.repository.cockpitadapter.EOWorkspaceInformation;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ServerDataContainer {
    private final EOList<EOList<? extends EncodableObjectBase>> mainData;
    private final IFrameProjectAgent projectAgent;
    private final EOList<EOCommitCountAndCommitInformation> commitInformations;
    private final Collection<EOWorkspaceInformation> workspaceInformations;
    private final Map<String, Collection<EOPlatformLock>> workspaceUID_locks;
    private final Collection<EOPlatformLock> lockLog;

    public ServerDataContainer(IFrameProjectAgent projectAgent, EOList<EOCommitCountAndCommitInformation> commitInformations, Collection<EOWorkspaceInformation> workspaceInformationsOnServer, Map<String, Collection<EOPlatformLock>> workspaceUID_locks, Collection<EOPlatformLock> lockLog, EOList<EOList<? extends EncodableObjectBase>> importData) {
        this.mainData = importData;
        this.projectAgent = projectAgent;
        this.commitInformations = commitInformations;
        this.workspaceInformations = workspaceInformationsOnServer;
        this.workspaceUID_locks = workspaceUID_locks;
        this.lockLog = lockLog;
    }

    public EOProject getMetaData() {
        EOList list = this.getList("metadata");
        if (list != null && !list.isEmpty()) {
            EOProject pr = (EOProject)list.get(0);
            if (pr != null) {
                pr.setProjectUID(this.projectAgent.getUID());
                pr.setUID(this.projectAgent.getUID());
            }
            return pr;
        }
        return null;
    }

    public EOUniqueElement[] getUniqueElements() {
        EOList ues = this.getList("unique elements");
        if (ues != null) {
            EOUniqueElement[] ueArray = new EOUniqueElement[ues.size()];
            int nr = 0;
            for (EOUniqueElement ue : ues) {
                ue.setProjectUID(this.projectAgent.getUID());
                ueArray[nr++] = ue;
            }
            return ueArray;
        }
        return new EOUniqueElement[0];
    }

    public Collection<EOUniqueElementOccurrence> getUniqueElementOccurrences() {
        EOList occurrences = this.getList("unique element occurences");
        if (occurrences != null) {
            for (EOUniqueElementOccurrence occurrence : occurrences) {
                occurrence.setProjectUID(this.projectAgent.getUID());
            }
        }
        return occurrences;
    }

    public Collection<EOUniqueElementRelationship> getUniqueElementRelationships() {
        EOList relationships = this.getList("uniqueElementContainment");
        if (relationships != null) {
            for (EOUniqueElementRelationship rel : relationships) {
                rel.setProjectUID(this.projectAgent.getUID());
            }
        }
        return relationships;
    }

    public EOPlan[] getPlans() {
        EOList plans = this.getList("plans");
        if (plans != null) {
            EOPlan[] eos = new EOPlan[plans.size()];
            int nr = 0;
            for (EOPlan plan : plans) {
                plan.setProjectUID(this.projectAgent.getUID());
                eos[nr++] = plan;
            }
            return eos;
        }
        return null;
    }

    public EOStakeholder[] getStakeholders() {
        EOList stakeholders = this.getList("stakeholders");
        if (stakeholders != null) {
            EOStakeholder[] result = new EOStakeholder[stakeholders.size()];
            int nr = 0;
            for (EOStakeholder stakeholder : stakeholders) {
                stakeholder.setProjectUID(this.projectAgent.getUID());
                result[nr++] = stakeholder;
            }
            return result;
        }
        return new EOStakeholder[0];
    }

    public EOStakeholderRole[] getStakeholderRoles() {
        EOList roles = this.getList("stakeholder roles");
        if (roles != null) {
            EOStakeholderRole[] array = new EOStakeholderRole[roles.size()];
            int nr = 0;
            for (EOStakeholderRole role : roles) {
                role.setProjectUID(this.projectAgent.getUID());
                array[nr++] = role;
            }
            return array;
        }
        return new EOStakeholderRole[0];
    }

    public Collection<EORoleAndStakeholder> getStakeholderRoleConnections() {
        EOList connections = this.getList("stakeholder role connections");
        if (connections != null) {
            for (EORoleAndStakeholder ras : connections) {
                ras.setProjectUID(this.projectAgent.getUID());
            }
        }
        return connections;
    }

    public EOSection[] getSections() {
        EOList sections = this.getList("sections");
        if (sections != null) {
            EOSection[] sectionArray = new EOSection[sections.size()];
            int nr = 0;
            for (EOSection section : sections) {
                section.setProjectUID(this.projectAgent.getUID());
                sectionArray[nr++] = section;
            }
            return sectionArray;
        }
        return null;
    }

    public Collection getFrameData(String dataTypeID) {
        EOList allFrameData = this.getList("frame_data");
        if (allFrameData != null) {
            for (EOList data : allFrameData) {
                if (!data.getRole().equals(dataTypeID)) continue;
                return data;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getUserDefinedAttributeTypes() {
        return this.getList("userDefinedAttributeTypes");
    }

    public Collection<EOLink> getLinks() {
        Object links = this.getList("links");
        if (links == null) {
            links = new ArrayList(0);
        }
        return links;
    }

    public EOList[] getModuleData() {
        EOList allModuleLists = this.getList("module data");
        if (allModuleLists != null) {
            EOList[] moduleData = new EOList[allModuleLists.size()];
            int i = 0;
            while (i < allModuleLists.size()) {
                moduleData[i] = (EOList)allModuleLists.get(i);
                ++i;
            }
            return moduleData;
        }
        return new EOList[0];
    }

    public Collection<EOFileMetaInformation> getFileMetaInformation() {
        EOList fileMetaInformation = this.getList("fileMetaInformation");
        return fileMetaInformation != null ? fileMetaInformation : Collections.emptySet();
    }

    public EOList<EOObjectTypeCategory> getObjectTypeCategories() {
        EOList objectTypeCategories = this.getList("object-type-category");
        return objectTypeCategories;
    }

    public EOList<EOList<? extends EncodableObjectBase>> getMainData() {
        return this.mainData;
    }

    public EOList<EOCommitCountAndCommitInformation> getCommitInformations() {
        return this.commitInformations;
    }

    public Collection<EOWorkspaceInformation> getWorkspaceInformations() {
        return this.workspaceInformations;
    }

    public Collection<EOPlatformLock> getLockLog() {
        return this.lockLog;
    }

    public Map<String, Collection<EOPlatformLock>> getWorkspaceUID_locks() {
        return this.workspaceUID_locks;
    }

    private EOList getList(String role) {
        if (this.mainData != null) {
            for (EOList list : this.mainData) {
                if (!list.getRole().equals(role)) continue;
                return list;
            }
        }
        return null;
    }
}

