/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.locking;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.locking.ForeignLockChecker;
import com.arcway.cockpit.frame.client.project.core.locking.IForeignLockChecker;
import com.arcway.cockpit.frame.client.project.core.locking.ILockOperationProvider;
import com.arcway.cockpit.frame.client.project.core.locking.ILockRequestSupressor;
import com.arcway.cockpit.frame.client.project.core.locking.IProjectLockFetcher;
import com.arcway.cockpit.frame.client.project.core.locking.LockRequestSupressor;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.locking.lockhasher.LockHasherByUID;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ProjectLockFetcher
implements IProjectLockFetcher {
    private final IForeignLockChecker foreignLockChecker;
    private final ILockRequestSupressor lockRequestSupressor;
    private final ILockOperationProvider lockOperationProvider;
    private final IFrameProjectAgent projectAgent;
    private static final ILogger logger = Logger.getLogger(ProjectLockFetcher.class);

    public ProjectLockFetcher(IFrameProjectAgent projectAgent, ILockOperationProvider lockOperationProvider) {
        LockRequestSupressor lockRequestSupressorImplementation = new LockRequestSupressor(projectAgent, projectAgent.getFrameServerProxy(), this);
        ForeignLockChecker foreignLockCheckerImplementation = new ForeignLockChecker(projectAgent, lockRequestSupressorImplementation);
        lockOperationProvider.setupInternal(foreignLockCheckerImplementation);
        this.lockRequestSupressor = lockRequestSupressorImplementation;
        this.foreignLockChecker = foreignLockCheckerImplementation;
        this.lockOperationProvider = lockOperationProvider;
        this.projectAgent = projectAgent;
    }

    @Override
    public LockResult setExclusiveProjectLock() {
        ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
        ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
        EOLock projectLockShared = this.generateProjectLock("project_lock_shared");
        EOLock projectLockExclusive = this.generateProjectLock("project_lock_exclusive");
        locksToBeChecked.add(projectLockShared);
        locksToBeChecked.add(projectLockExclusive);
        locksToBeSet.add(projectLockExclusive);
        return this.lockOperationProvider.atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
    }

    @Override
    public LockResult setBlockingProjectLock(Collection<EOLock> projectLocksClientAlreadyOwns) {
        Throwable exception = null;
        LockResult lockResult = this.lockRequestSupressor.setBlockingProjectLock(projectLocksClientAlreadyOwns);
        if (lockResult.wasSuccessful()) {
            try {
                this.foreignLockChecker.populateForeignLocks(this.getLocksCurrentlyAllocatedOnServer());
            }
            catch (ServerNotAvailableException e) {
                exception = e;
                logger.error("Error while populating foreign locks.", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                exception = e;
                logger.error("Error while populating foreign locks.", (Throwable)e);
            }
            catch (EXServerException e) {
                exception = e;
                logger.error("Error while populating foreign locks.", (Throwable)e);
            }
            catch (UnknownServerException e) {
                exception = e;
                logger.error("Error while populating foreign locks.", (Throwable)e);
            }
        }
        if (exception != null) {
            try {
                this.lockRequestSupressor.releaseBlockingProjectLock();
            }
            catch (ServerNotAvailableException e) {
                logger.error("Error while releasing blocking project [rollback of lock].", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                logger.error("Error while releasing blocking project [rollback of lock].", (Throwable)e);
            }
            catch (EXServerException e) {
                logger.error("Error while releasing blocking project [rollback of lock].", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.error("Error while releasing blocking project [rollback of lock].", (Throwable)e);
            }
            lockResult = new LockResult(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Exception)exception);
        }
        return lockResult;
    }

    @Override
    public void releaseBlockingProjectLock() throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        this.foreignLockChecker.cleanUp();
        this.lockRequestSupressor.releaseBlockingProjectLock();
    }

    @Override
    public boolean doWithBlockOfflineModeProjectLock(Runnable todo) {
        ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
        ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
        EOLock projectLockShared = this.generateProjectLock("project_lock_shared");
        EOLock projectLockExclusive = this.generateProjectLock("project_lock_exclusive");
        EOLock projectLockBlockOfflineMode = this.generateProjectLock("project_lock_block_offline");
        locksToBeChecked.add(projectLockExclusive);
        locksToBeSet.add(projectLockShared);
        locksToBeSet.add(projectLockBlockOfflineMode);
        LockResult lockResult = this.lockOperationProvider.atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
        boolean success = lockResult.wasSuccessful();
        if (success) {
            try {
                todo.run();
            }
            finally {
                this.lockOperationProvider.releaseLocks(lockResult.getAllRequestedLocks());
            }
        }
        return success;
    }

    @Override
    public EOLock generateProjectLock(String projectLockType) {
        EOLock projectLock;
        String projectUID = this.projectAgent.getProjectUID();
        if (projectLockType.equals("project_lock_shared")) {
            projectLock = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "project_lock_shared", projectUID, "frame.project", "", "", new Timestamp(System.currentTimeMillis()));
        } else if (projectLockType.equals("project_lock_exclusive")) {
            projectLock = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "project_lock_exclusive", projectUID, "frame.project", "", "", new Timestamp(System.currentTimeMillis()));
        } else if (projectLockType.equals("project_lock_block_offline")) {
            projectLock = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "project_lock_block_offline", projectUID, "frame.project", "", "", new Timestamp(System.currentTimeMillis()));
        } else {
            throw new RuntimeException("Unknown project lock type requested. [LockMgr]");
        }
        return projectLock;
    }

    @Override
    public Collection<EOLock> getLocksCurrentlyAllocatedOnServer() {
        HashSet_ locksCurrentlyAllocated = new HashSet_(LockHasherByUID.INSTANCE);
        locksCurrentlyAllocated.addAll(this.lockOperationProvider.getLocksCurrentlyAllocatedByLockAllocator());
        EOLock blockingProjectLock = this.lockRequestSupressor.getBlockingProjectLock();
        if (blockingProjectLock != null) {
            locksCurrentlyAllocated.add((Object)blockingProjectLock);
        }
        locksCurrentlyAllocated.removeAll(this.lockRequestSupressor.getSupressedLocks());
        return locksCurrentlyAllocated.asJavaCollection();
    }
}

