/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links.linktypes;

import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public class LinkTypeLinkAccessFacade
implements ILinkTypeLinkAccessFacade {
    private final ILinkType type;
    private final LinkManager manager;
    private final String projectUID;
    private final String moduleID;

    public LinkTypeLinkAccessFacade(String projectUID, String moduleID, ILinkType type, LinkManager manager) {
        assert (type != null) : "type must not be null";
        assert (manager != null) : "manager must not be null";
        assert (projectUID != null) : "projectUID must not be null";
        assert (moduleID != null) : "moduleID must not be null";
        this.type = type;
        this.manager = manager;
        this.projectUID = projectUID;
        this.moduleID = moduleID;
    }

    @Override
    public Set<EOLink> getLinksForModuleDataItem(String moduleDataItemUID) {
        assert (moduleDataItemUID != null) : "moduleDataItemUID must not be null";
        return this.manager.getLinksOfLinkTypeForModuleDataItem(this.type, moduleDataItemUID);
    }

    @Override
    public boolean linkExists(EOLink link) {
        assert (link != null) : "link must not be null";
        return this.manager.linkExists(link);
    }

    @Override
    public IStatus addLink(EOLink link) {
        assert (link != null) : "link must not be null";
        return this.manager.addLink(link);
    }

    @Override
    public IStatus deleteLink(EOLink link) {
        assert (link != null) : "link must not be null";
        IStatus status = this.manager.deleteLink(link);
        return status;
    }

    @Override
    public IStatus checkLinkAddition(EOLink link) {
        assert (link != null) : "link must not be null";
        return this.manager.checkLinkAddition(link);
    }

    @Override
    public IStatus checkLinkDeletion(EOLink link) {
        assert (link != null) : "link must not be null";
        return this.manager.checkLinkDeletion(link);
    }

    @Override
    public IStatus createLink(String moduleDataItemUID, String linkableObjectUID) {
        assert (moduleDataItemUID != null) : "moduleDataItemUID must not be null";
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        EOLink link = new EOLink(this.projectUID, linkableObjectUID, moduleDataItemUID, this.moduleID, this.type.getUID());
        IStatus status = this.addLink(link);
        return status;
    }

    @Override
    public IStatus deleteLink(String moduleDataUID, String linkableObjectUID) {
        EOLink link = new EOLink(this.projectUID, linkableObjectUID, moduleDataUID, this.moduleID, this.type.getUID());
        IStatus status = this.deleteLink(link);
        return status;
    }

    @Override
    public Set<EOLink> getLinksForLinkableObject(String linkableObjectUID) {
        return this.manager.getLinksOfLinkTypeForLinkableObject(this.type, linkableObjectUID);
    }

    @Override
    public Collection<EOLink> createLinks(String moduleDataUID, Collection<String> linkableObjectUIDs) {
        return this.manager.createLinks(this.type, moduleDataUID, linkableObjectUIDs);
    }

    @Override
    public Collection<String> getLinkableObjectUIDs(String moduleDataItemUID) {
        Set<EOLink> links = this.manager.getLinksOfLinkTypeForModuleDataItem(this.type, moduleDataItemUID);
        ArrayList<String> loUIDs = new ArrayList<String>(links.size());
        for (EOLink link : links) {
            loUIDs.add(link.getLinkableObjectUID());
        }
        return loUIDs;
    }

    @Override
    public Collection<EOLink> createLinks(Collection<String> moduleDataUIDs, String linkableObjectUID) {
        return this.manager.createLinks(this.type, moduleDataUIDs, linkableObjectUID);
    }

    @Override
    public Collection<ICockpitProjectData> getLinkableObjects(String moduleDataUID) {
        Set<EOLink> links = this.getLinksForModuleDataItem(moduleDataUID);
        ArrayList<ICockpitProjectData> linkableObjects = new ArrayList<ICockpitProjectData>(links.size());
        for (EOLink link : links) {
            linkableObjects.add(this.manager.getLinkableObject(link));
        }
        return linkableObjects;
    }

    @Override
    public ICockpitProjectData getLinkableObject(EOLink link) {
        return this.manager.getLinkableObject(link);
    }

    @Override
    public Collection<ICockpitProjectData> getVersionedLinkableObjects(String moduleDataItemUID, int modCount) {
        Set<EOLinkLog> versionedLinksForModuleDataItem = this.getVersionedLinksForModuleDataItem(moduleDataItemUID, modCount);
        ArrayList<ICockpitProjectData> items = new ArrayList<ICockpitProjectData>(versionedLinksForModuleDataItem.size());
        for (EOLinkLog link : versionedLinksForModuleDataItem) {
            items.add(this.manager.getVersionedLinkableObject(link));
        }
        return items;
    }

    @Override
    public IStatus addVersionedLink(EOLinkLog link) {
        return this.manager.addLinkVersion(link);
    }

    @Override
    public void removeVersionedLink(EOLinkLog link) {
        this.manager.deleteLinkVersion(link);
    }

    @Override
    public Set<EOLinkLog> getVersionedLinksForModuleDataItem(String moduleDataItemUID, int modCount) {
        return this.manager.getVersionedLinksOfLinkTypeForModuleDataItem(this.type.getUID(), moduleDataItemUID, modCount);
    }

    @Override
    public Set<EOLinkLog> getVersionedLinksForLinkableObject(String linkableObjectUID, int modCount) {
        return this.manager.getVersionedLinksOfLinkTypeForLinkableObject(this.type.getUID(), linkableObjectUID, modCount);
    }

    @Override
    public Collection<ICockpitProjectData> getVersionedModuleData(String linkableObjectID, int modCount) {
        Set<EOLinkLog> versionedLinksForLinkableObject = this.getVersionedLinksForLinkableObject(linkableObjectID, modCount);
        ArrayList<ICockpitProjectData> moduleData = new ArrayList<ICockpitProjectData>(versionedLinksForLinkableObject.size());
        for (EOLinkLog link : versionedLinksForLinkableObject) {
            ICockpitProjectData item = this.manager.getVersionedModuleData(link);
            if (item == null) continue;
            moduleData.add(item);
        }
        return moduleData;
    }

    @Override
    public Collection<ICockpitProjectData> getModuleData(String linkableObjectUID) {
        Set<EOLink> linksForLinkableObject = this.getLinksForLinkableObject(linkableObjectUID);
        ArrayList<ICockpitProjectData> moduleData = new ArrayList<ICockpitProjectData>(linksForLinkableObject.size());
        for (EOLink link : linksForLinkableObject) {
            ICockpitProjectData item = this.manager.getModuleDataItem(link);
            moduleData.add(item);
        }
        return moduleData;
    }

    @Override
    public ICockpitProjectData getModuleDataItem(EOLink link) {
        return this.manager.getModuleDataItem(link);
    }

    @Override
    public Set<EOLink> getAllLinks() {
        return this.manager.getLinks(this.type);
    }

    @Override
    public ISetMapWithFixReturnSetsRO<String, EOLink> getAllLinksMappedByLinkableObjectID() {
        return this.manager.getLinksMappedByLinkableObjectUID(this.type.getUID());
    }

    @Override
    public Collection<EOLink> addLinks(Collection<EOLink> links) {
        return this.manager.addLinks(links);
    }

    @Override
    public Collection<EOLink> deleteLinks(Collection<String> linkableObjectUIDs, String moduleDataUID) {
        return this.manager.deleteLinks(linkableObjectUIDs, moduleDataUID, this.type);
    }

    @Override
    public Collection<EOLink> deleteLinks(String linkableObjectUID, Collection<String> moduleDataUIDs) {
        return this.manager.deleteLinks(linkableObjectUID, moduleDataUIDs, this.type);
    }

    @Override
    public LockResult acquireLocksForLinkData(String linkableObjectUID, String moduleDataUID) {
        return this.manager.acquireLocksForLinkData(linkableObjectUID, moduleDataUID, this.type);
    }
}

