/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.lib.java.collectionmaps.SetMapWithFixReturnSets;
import java.util.HashSet;
import java.util.Set;

public class VersionedLinkStore {
    private final Set<EOLinkLog> allLinks;
    private final SetMapWithFixReturnSets<VersionedItemKey, EOLinkLog> moduleDataMap;
    private final SetMapWithFixReturnSets<VersionedItemKey, EOLinkLog> linkableObjectMap;

    public VersionedLinkStore(ILinkType type) {
        assert (type != null) : "type must not be null";
        this.allLinks = new HashSet<EOLinkLog>();
        this.moduleDataMap = new SetMapWithFixReturnSets();
        this.linkableObjectMap = new SetMapWithFixReturnSets();
    }

    public Set<EOLinkLog> getLinksForLinkableObject(String linkableObjectUID, int modCount) {
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        return this.linkableObjectMap.get((Object)this.getKey(linkableObjectUID, modCount));
    }

    public Set<EOLinkLog> getLinksForModuleDataItem(String moduleDataItemUID, int modCount) {
        assert (moduleDataItemUID != null) : "moduleDataItemUID must not be null";
        return this.moduleDataMap.get((Object)this.getKey(moduleDataItemUID, modCount));
    }

    public boolean linkExists(EOLinkLog link) {
        assert (link != null) : "link must not be null";
        return this.allLinks.contains(link);
    }

    public boolean addLink(EOLinkLog link) {
        assert (link != null) : "link must not be null";
        boolean linkAdded = this.allLinks.add(link);
        if (linkAdded) {
            boolean linkAdded2 = this.moduleDataMap.add((Object)this.getModuleDataKey(link), (Object)link);
            assert (linkAdded2);
            linkAdded2 = this.linkableObjectMap.add((Object)this.getLOKey(link), (Object)link);
            assert (linkAdded2);
        }
        return linkAdded;
    }

    public boolean removeLink(EOLinkLog link) {
        assert (link != null) : "link must not be null";
        boolean linkExisted = this.allLinks.remove(link);
        if (linkExisted) {
            boolean linkExisted2 = this.moduleDataMap.remove((Object)this.getModuleDataKey(link), (Object)link);
            assert (linkExisted2);
            linkExisted2 = this.linkableObjectMap.remove((Object)this.getLOKey(link), (Object)link);
            assert (linkExisted2);
        }
        return linkExisted;
    }

    public Set<EOLinkLog> removeLinksForModuleDataItem(String mdUID, int modCount) {
        Set<EOLinkLog> links = this.getLinksForModuleDataItem(mdUID, modCount);
        for (EOLinkLog link : links) {
            boolean linkExisted = this.removeLink(link);
            assert (linkExisted);
        }
        return links;
    }

    public Set<EOLinkLog> removeLinksForLinkableObject(String loUID, int modCount) {
        Set<EOLinkLog> links = this.getLinksForLinkableObject(loUID, modCount);
        for (EOLinkLog link : links) {
            boolean linkExisted = this.removeLink(link);
            assert (linkExisted);
        }
        return links;
    }

    private VersionedItemKey getModuleDataKey(EOLinkLog link) {
        return this.getKey(link.getModuleDataUID(), link.getModuleDataVersion());
    }

    private VersionedItemKey getLOKey(EOLinkLog link) {
        return this.getKey(link.getLinkableObjectUID(), link.getLinkableObjectVersion());
    }

    private VersionedItemKey getKey(String UID, int modCount) {
        return new VersionedItemKey(UID, modCount);
    }

    private static class VersionedItemKey {
        static final int prime = 31;
        private final String uid;
        private final int modCount;
        private final int cachedHashcode;

        public VersionedItemKey(String uid, int modCount) {
            this.uid = uid;
            this.modCount = modCount;
            this.cachedHashcode = 31 * modCount + uid.hashCode();
        }

        public int hashCode() {
            return this.cachedHashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof VersionedItemKey) {
                VersionedItemKey key2 = (VersionedItemKey)obj;
                if (this.cachedHashcode == key2.cachedHashcode && this.modCount == key2.modCount && this.uid.equals(key2.uid)) {
                    return true;
                }
            }
            return false;
        }
    }
}

