/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import com.arcway.cockpit.client.base.datamanager.AtomicModificationDataAccessor;
import com.arcway.cockpit.frame.client.project.core.links.LinkAccessAgent;
import com.arcway.cockpit.frame.client.project.core.links.LinkTypeRegistry;
import com.arcway.cockpit.frame.client.project.core.links.ModificationLog;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkModificationContainer;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.util.Collection;

public class ModificationLogMgr {
    private final ModificationLog modificationLog;
    private boolean isDirty;

    public ModificationLogMgr(LinkAccessAgent linkAccessAgent, LinkTypeRegistry registry) {
        this.modificationLog = new ModificationLog(linkAccessAgent.getProjectUID(), registry, linkAccessAgent.getAtomicModificationDataAccessor());
        this.isDirty = false;
    }

    public void addLink(EOLink l) {
        this.modificationLog.addLink(l);
        this.isDirty = true;
    }

    public void deleteLink(EOLink l) {
        this.modificationLog.deleteLink(l);
        this.isDirty = true;
    }

    public EOLinkModificationContainer getCommitChanges() {
        return this.modificationLog.getModificationContainer();
    }

    public EOLinkModificationContainer cleanupCommitModifications() {
        EOLinkModificationContainer saved = this.getCommitChanges();
        this.modificationLog.clear();
        return saved;
    }

    public boolean hasCommitChanges() {
        return !this.modificationLog.isEmpty();
    }

    public boolean hasCommitChangesForProject(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        return !this.modificationLog.isEmpty(linkTypeID);
    }

    public EOLinkModificationContainer getCommitChangesForProject(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        return this.modificationLog.getLinkModificationContainerForLinkType(linkTypeID);
    }

    public void setSavedModifications(EOLinkModificationContainer container) {
        assert (container != null) : "container must not be null";
        this.modificationLog.setModificationsFromContainer(container);
        if (!container.isEmpty()) {
            this.isDirty = true;
        }
    }

    public void removeAdditionLog(EOLink link) {
        assert (link != null) : "container must not be null";
        this.modificationLog.removeAddition(link);
    }

    public void removeDeletion(EOLink link) {
        assert (link != null) : "link must not be null";
        this.modificationLog.removeDeletion(link);
    }

    public void linkedItemDeleted(String linkedItemUID, String linkedItemTypeID, Collection<String> LOLinkTypeIDs, Collection<String> MDLinkTypeIDs) {
        assert (linkedItemUID != null) : "linkableObjectUID must not be null";
        assert (LOLinkTypeIDs != null) : "linkTypeIDs must not be null";
        assert (MDLinkTypeIDs != null) : "linkTypeIDs must not be null";
        this.modificationLog.linkedItemDeleted(linkedItemUID, linkedItemTypeID, LOLinkTypeIDs, MDLinkTypeIDs);
        this.isDirty = true;
    }

    public boolean isLinkedItemDeleted(String linkableObjectUID) {
        return this.modificationLog.isLinkedItemDeleted(linkableObjectUID);
    }

    public boolean hasModifiedLink(String dataUID) {
        return this.modificationLog.hasModifiedLink(dataUID);
    }

    public boolean hasModifiedLinks(String linkTypeID) {
        return this.modificationLog.hasModifiedLinks(linkTypeID);
    }

    public boolean isDirty() {
        return this.isDirty || !this.modificationLog.isEmpty();
    }

    public void resetDirtyFlag() {
        this.isDirty = false;
    }

    public EOLinkModificationContainer readSavedModifications(IEncodableObjectFactory messageDataFactory) throws AtomicModificationDataAccessor.ModificationBootstrapFailure {
        return this.modificationLog.readSavedModifications(messageDataFactory);
    }

    public void deleteSavedModifications() {
        this.modificationLog.deleteSavedModifications();
    }
}

