/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import com.arcway.lib.java.collectionmaps.SetMapWithFixReturnSets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LinkStore {
    private final Set<EOLink> allLinks;
    private final Set<EOLink> allLinks_unmodifiable;
    private final SetMapWithFixReturnSets<String, EOLink> moduleDataMap;
    private final SetMapWithFixReturnSets<String, EOLink> linkableObjectMap;

    public LinkStore(ILinkType type) {
        assert (type != null) : "type must not be null";
        this.allLinks = new HashSet<EOLink>(50, 0.5f);
        this.allLinks_unmodifiable = Collections.unmodifiableSet(this.allLinks);
        this.moduleDataMap = new SetMapWithFixReturnSets();
        this.linkableObjectMap = new SetMapWithFixReturnSets();
    }

    public Set<EOLink> getLinksForLinkableObject(String linkableObjectUID) {
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        return this.linkableObjectMap.get((Object)linkableObjectUID);
    }

    public Set<EOLink> getLinksForModuleDataItem(String moduleDataItemUID) {
        assert (moduleDataItemUID != null) : "moduleDataItemUID must not be null";
        return this.moduleDataMap.get((Object)moduleDataItemUID);
    }

    public boolean linkExists(EOLink link) {
        assert (link != null) : "link must not be null";
        return this.allLinks.contains(link);
    }

    public boolean addLink(EOLink link) {
        assert (link != null) : "link must not be null";
        boolean linkAdded = this.allLinks.add(link);
        if (linkAdded) {
            boolean linkAdded2 = this.moduleDataMap.add((Object)link.getModuleDataUID(), (Object)link);
            assert (linkAdded2);
            linkAdded2 = this.linkableObjectMap.add((Object)link.getLinkableObjectUID(), (Object)link);
            assert (linkAdded2);
        }
        return linkAdded;
    }

    public boolean removeLink(EOLink link) {
        assert (link != null) : "link must not be null";
        boolean linkExisted = this.allLinks.remove(link);
        if (linkExisted) {
            boolean linkExisted2 = this.moduleDataMap.remove((Object)link.getModuleDataUID(), (Object)link);
            assert (linkExisted2);
            linkExisted2 = this.linkableObjectMap.remove((Object)link.getLinkableObjectUID(), (Object)link);
            assert (linkExisted2);
        }
        return linkExisted;
    }

    public Set<EOLink> removeLinksForModuleDataItem(String mdUID) {
        Set<EOLink> links = this.getLinksForModuleDataItem(mdUID);
        for (EOLink link : links) {
            boolean linkExisted = this.removeLink(link);
            assert (linkExisted);
        }
        return links;
    }

    public Set<EOLink> removeLinksForLinkableObject(String loUID) {
        Set<EOLink> links = this.getLinksForLinkableObject(loUID);
        for (EOLink link : links) {
            boolean linkExisted = this.removeLink(link);
            assert (linkExisted);
        }
        return links;
    }

    public Set<EOLink> getAllStoredLinks() {
        return this.allLinks_unmodifiable;
    }

    public ISetMapWithFixReturnSetsRO<String, EOLink> getLinkableObjectMapping() {
        return this.linkableObjectMap;
    }
}

