/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.frame.shared.message.EOContainer;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class EnumerationAttributeFilter
implements IAttributeFilter {
    private static EnumerationAttributeFilter instance;

    private EnumerationAttributeFilter() {
    }

    public static EnumerationAttributeFilter getDefault() {
        if (instance == null) {
            instance = new EnumerationAttributeFilter();
        }
        return instance;
    }

    public boolean select(EOEncodableObject filterValue, IAttribute attribute) {
        if (filterValue == null) {
            return true;
        }
        List filterValueAsList = (List)filterValue;
        HashSet<EnumerationEntry> allowedValues = new HashSet<EnumerationEntry>(filterValueAsList.size());
        boolean emptyValueIsAllowed = false;
        for (EOContainer container : filterValueAsList) {
            if (container.getRole().equals("ID_For_ValueNotSet")) {
                emptyValueIsAllowed = true;
                continue;
            }
            allowedValues.add(new EnumerationEntry(container.getRole(), (Object)container.getContent()));
        }
        Collection values = (Collection)attribute.getAttributeValue();
        if (values == null || values.isEmpty()) {
            return emptyValueIsAllowed;
        }
        for (EnumerationEntry entry : values) {
            if (!allowedValues.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public EOEncodableObject getStandardFilterValue() {
        return new EOList();
    }
}

