/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.shared.message.EOContainer;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AttributeEnumerationFilterItem
extends AbstractFilterItem {
    private static final ILogger logger = Logger.getLogger(AttributeEnumerationFilterItem.class);
    public static final String ID_VALUENOTSET = "ID_For_ValueNotSet";
    private static final EnumerationEntry ENUMERATIONENTRY_VALUENOTSET = new EnumerationEntry("ID_For_ValueNotSet", null);
    private final AbstractFilter filter;
    private Map<String, EnumerationEntry> values;
    private final IAttributeTypeDataType dataType;
    private final IAttributeTypeDataType baseType;
    private final IValueRange valueRange;
    private static final XMLDecoder decoder = new XMLDecoder();
    private final List<Button> buttons = new ArrayList<Button>();

    public AttributeEnumerationFilterItem(String name, AbstractFilter filter, IAttributeTypeDataType dataType, IAttributeTypeDataType baseType, IValueRange valueRange) {
        super(name, filter);
        this.filter = filter;
        this.dataType = dataType;
        this.baseType = baseType;
        this.filterHasChanged();
        this.valueRange = valueRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, EnumerationEntry> convertFromXMLString(String xmlString) {
        Class<AttributeEnumerationFilterItem> clazz = AttributeEnumerationFilterItem.class;
        synchronized (AttributeEnumerationFilterItem.class) {
            try {
                EOList valueList = (EOList)decoder.decodeXML(xmlString, (IEncodableObjectFactory)MessageDataFactory.getInstance(), true);
                HashMap<String, EnumerationEntry> convertedItems = new HashMap<String, EnumerationEntry>(valueList.size());
                for (EOContainer container : valueList) {
                    Object content = container.getContent() != null ? this.baseType.getEOAsValue(container.getContent()) : null;
                    String id = container.getRole();
                    convertedItems.put(id, new EnumerationEntry(id, content));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return convertedItems;
            }
            catch (EXDecoderException e) {
                logger.error((Throwable)e);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
    }

    private String convertToXMLString(Map<String, EnumerationEntry> items) throws EXEncoderException {
        try {
            EOList itemsAsEOs = new EOList(items.size());
            for (Map.Entry<String, EnumerationEntry> entry : items.entrySet()) {
                EOEncodableObject contentAsEO = entry.getValue().getValue() != null ? this.baseType.getValueAsEO(entry.getValue().getValue(), this.valueRange) : null;
                String id = entry.getKey();
                EOContainer container = new EOContainer(id, contentAsEO);
                itemsAsEOs.add((EncodableObjectBase)container);
            }
            return itemsAsEOs.toXMLString(false);
        }
        catch (EXEncoderException e) {
            assert (false);
            logger.error("Error encoding filter settings for enumeration custom property filter", (Throwable)e);
            throw e;
        }
    }

    public void doConfirmSelection() {
        try {
            this.filter.setFilterValue(this.convertToXMLString(this.values));
        }
        catch (ExInvalidDataType e) {
            logger.error((Throwable)e);
        }
        catch (EXEncoderException e) {
            logger.error("Could not set filter Value", (Throwable)e);
        }
    }

    public void refresh() {
        for (Button button : this.buttons) {
            this.updateValueCheckState(button);
        }
    }

    private void updateValueCheckState(Button button) {
        String id = ((EnumerationEntry)button.getData()).getID();
        button.setSelection(this.values.containsKey(id));
    }

    public void filterHasChanged() {
        this.values = this.filter != null ? this.convertFromXMLString(this.filter.getFilterValue()) : new HashMap<String, EnumerationEntry>();
    }

    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        String filterInfo = "";
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            if (filterInfo.length() > 0) {
                filterInfo = String.valueOf(filterInfo) + ", ";
            }
            filterInfo = String.valueOf(filterInfo) + button.getText();
        }
        return filterInfo;
    }

    public Control createContent(Composite parent) {
        Group composite = new Group(parent, 512);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.verticalSpacing = 2;
        compositeLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeGD = new GridData(1808);
        composite.setLayoutData((Object)compositeGD);
        composite.setText(this.getName());
        this.addCheckButton((Composite)composite, Messages.getString("EnumerationFilter.NoValue.Label"), ENUMERATIONENTRY_VALUENOTSET);
        Collection possibleValues = (Collection)this.valueRange.getValueRange();
        for (EnumerationEntry possValue : possibleValues) {
            Object content = possValue.getValue();
            this.addCheckButton((Composite)composite, this.baseType.getValueAsSingleLineString(content, null, "", Locale.getDefault()), possValue);
        }
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AttributeEnumerationFilterItem.this.buttons.clear();
            }
        });
        return composite;
    }

    private void addCheckButton(Composite composite, String label, Object data) {
        Button button = new Button(composite, 32);
        button.setText(label);
        button.setData(data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AttributeEnumerationFilterItem.this.updateFilter();
                AttributeEnumerationFilterItem.this.fireValueChanged();
            }
        });
        this.updateValueCheckState(button);
        this.buttons.add(button);
    }

    public boolean isNoFilterValuesSet() {
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllFilterValuesSet() {
        for (Button button : this.buttons) {
            if (button.getSelection()) continue;
            return false;
        }
        return true;
    }

    private void updateFilter() {
        this.values.clear();
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            EnumerationEntry entry = (EnumerationEntry)button.getData();
            this.values.put(entry.getID(), entry);
        }
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    public void resetFilterValueToFilterState() {
        if (this.filter != null) {
            this.values = this.convertFromXMLString(this.filter.getFilterValue());
        }
    }
}

