/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementImage;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ImageElementParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueImage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.AbstractDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.ImageSWTControlFactory;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.eclipse.gui.ImageInCanvasPainter;
import com.arcway.lib.eclipse.gui.dialogs.ImageDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class DataTypeImage
extends AbstractDataTypeWithFile {
    private static final ILogger logger = Logger.getLogger(DataTypeImage.class);
    private final Map<FileID, ImageDescriptor> imageFileID_imageDescriptor = new HashMap<FileID, ImageDescriptor>();
    private final Map<FileID, Image> imageFileID_image = new HashMap<FileID, Image>();
    public static final String DATA_TYPE_ID = "image";

    public Image getImage(FileID imageFileID) {
        ImageDescriptor imageDescriptor;
        Image image = this.imageFileID_image.get(imageFileID);
        if (image == null && (imageDescriptor = this.getImageDescriptor(imageFileID)) != null) {
            image = imageDescriptor.createImage();
            this.imageFileID_image.put(imageFileID, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(FileID imageFileID) {
        ImageDescriptor imageDescriptor = this.imageFileID_imageDescriptor.get(imageFileID);
        if (imageDescriptor == null) {
            Throwable e;
            block10: {
                e = null;
                try {
                    File file = this.getFileCopy(imageFileID);
                    if (file == null) break block10;
                    try {
                        imageDescriptor = ImageDescriptor.createFromURL((URL)file.toURL());
                        this.imageFileID_imageDescriptor.put(imageFileID, imageDescriptor);
                    }
                    catch (MalformedURLException mURLE) {
                        logger.error("Could not retrieve image file URL.", (Throwable)mURLE);
                        return null;
                    }
                }
                catch (ServerNotAvailableException e1) {
                    e = e1;
                }
                catch (EXServerException e1) {
                    e = e1;
                }
                catch (LoginCanceledException e1) {
                    e = e1;
                }
                catch (UnknownServerException e1) {
                    e = e1;
                }
                catch (ExPrematureEndOfTransfer e1) {
                    e = e1;
                }
            }
            if (e != null) {
                logger.error("Could not retrieve image file from archive.", e);
                return null;
            }
        }
        return imageDescriptor;
    }

    public DataTypeImage(IFrameProjectAgent projectAgent) {
        super(projectAgent);
    }

    public String getID() {
        return DATA_TYPE_ID;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeImage.image", locale);
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(final Composite parent, Object initialValue, IValueRange valueRange) {
        final AbstractDataType.SWTControlForModification[] wrapper = new AbstractDataType.SWTControlForModification[1];
        final ImageSWTControlFactory controlFactory = new ImageSWTControlFactory(parent, 0, this, this.getProjectAgent(), new ImageSWTControlFactory.IModificationListenerNotifier(){

            @Override
            public void informModificationListeners(Object newValue, Object additionalInformation) {
                DataTypeImage.this.informSWTModifyListeners(wrapper[0], newValue, additionalInformation);
            }
        });
        Control control = controlFactory.getControl();
        controlFactory.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Image image = controlFactory.getImage();
                if (image != null && !image.isDisposed()) {
                    DataTypeImage.this.openImage(image, parent.getShell());
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        FileID imageID = (FileID)initialValue;
        controlFactory.setInitialValue(imageID);
        wrapper[0] = new AbstractDataType.SWTControlForModification(this, control, new Runnable(){

            @Override
            public void run() {
                controlFactory.disposeResources();
            }
        });
        return wrapper[0];
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Control createSWTControlForViewing(final Composite parent, Object value, IValueRange valueRange) throws ExInvalidDataType {
        Canvas controlToReturn;
        Composite parentForWidgets;
        boolean showFileName = false;
        if (showFileName) {
            parentForWidgets = new Composite(parent, 0);
            parentForWidgets.setLayout((Layout)new GridLayout());
            parentForWidgets.setBackground(parent.getBackground());
        } else {
            parentForWidgets = parent;
        }
        Canvas canvas = new Canvas(parentForWidgets, 0);
        canvas.setBackground(parent.getBackground());
        ImageInCanvasPainter paintListener = new ImageInCanvasPainter(canvas, false, false);
        canvas.addPaintListener((PaintListener)paintListener);
        final Image image = this.getImage((FileID)value);
        if (image != null) {
            paintListener.setImage(image);
        }
        canvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (image != null && !image.isDisposed()) {
                    DataTypeImage.this.openImage(image, parent.getShell());
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        if (showFileName) {
            Text text = new Text(parentForWidgets, 0);
            FileMetaInformationItem metaInformation = this.getProjectAgent().getFilesManager().getFileMetaInformation((FileID)value);
            text.setText(metaInformation.getOriginalFileName());
            controlToReturn = parentForWidgets;
        } else {
            controlToReturn = canvas;
        }
        return controlToReturn;
    }

    @Override
    public DetailsElement getDetailsElement(IAttributeType attributeType, Object attributeValue, Locale locale, Shell shell, IWorkbenchPage workbenchPage) {
        if (!(attributeValue instanceof FileID)) {
            throw new ExInvalidDataType(attributeValue.getClass().toString(), FileID.class.toString());
        }
        DetailsValueImage detailsValue = null;
        ImageDescriptor imageDescriptor = this.getImageDescriptor((FileID)attributeValue);
        detailsValue = imageDescriptor != null ? new DetailsValueImage(new ImageElementParameter(imageDescriptor)) : new DetailsValueImage(null);
        return new DetailsElementImage(String.valueOf(attributeType.getCockpitDataTypeID()) + "-" + attributeType.getHumanReadableID(), attributeType.getDisplayName(), detailsValue);
    }

    @Override
    public int getSWTVerticalFillHint() {
        return 4;
    }

    private void openImage(Image image, Shell parentShell) {
        ImageDialog dialog = new ImageDialog(image, parentShell);
        dialog.open();
    }
}

