/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.AttributeDoubleFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.DoubleAttributeFilter;
import de.plans.lib.util.DoubleVerifyListener;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EODouble;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DataTypeDouble
extends AbstractDataType {
    private static final DataTypeDouble instance = new DataTypeDouble();
    private static final Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double d1 = (Double)o1;
            Double d2 = (Double)o2;
            return d1.compareTo(d2);
        }
    };
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance();

    static {
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        numberFormat.setMaximumIntegerDigits(Integer.MAX_VALUE);
    }

    public static DataTypeDouble getSingleInstance() {
        return instance;
    }

    private DataTypeDouble() {
    }

    public String getID() {
        return "double";
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        return value instanceof Double;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeDouble.double", locale);
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        Double doubleValue = (Double)value;
        return numberFormat.format(doubleValue);
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) {
        return new EODouble((Double)value);
    }

    public Object getEOAsValue(EOEncodableObject eo) {
        EODouble eoDouble = (EODouble)eo;
        return eoDouble.getValue();
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        final Text text = new Text(parent, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        text.setLayoutData((Object)gridData);
        text.addVerifyListener((VerifyListener)new DoubleVerifyListener(text));
        text.setText(this.getDefaultValue().toString());
        Double doubleValue = (Double)initialValue;
        text.setText(String.valueOf(doubleValue));
        final AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification((Control)text, null);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataTypeDouble.this.informSWTModifyListeners(wrapper, DataTypeDouble.this.getAttributeValueFromSWTControl(text), null);
            }
        });
        return wrapper;
    }

    private Object getAttributeValueFromSWTControl(Text text) {
        String content = text.getText();
        String minus = new String(new char[]{'-'});
        String strDoubleMinus = String.valueOf(minus) + minus;
        int index = content.indexOf(strDoubleMinus);
        while (index > -1) {
            content = String.valueOf(content.substring(0, index)) + content.substring(index + 1);
            index = content.indexOf(strDoubleMinus);
        }
        try {
            return new Double(content);
        }
        catch (NumberFormatException e) {
            return this.getDefaultValue();
        }
    }

    public Object getDefaultValue() {
        return new Double(0.0);
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        return originalValue;
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) {
        StyledText text = new StyledText(parent, 0);
        text.setText(this.getValueAsSingleLineString(value, valueRange, "", Locale.getDefault()));
        text.setEditable(false);
        return text;
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    public Comparator getComparator(IValueRange valueRange) {
        return comparator;
    }

    @Override
    public IFilterItem createFilterItem(String filterName, AbstractFilter filter, IValueRange vaueRange) {
        return new AttributeDoubleFilterItem(filterName, filter, this);
    }

    @Override
    public IAttributeFilter getFilter() {
        return DoubleAttributeFilter.getDefault();
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        try {
            return new Double(Double.parseDouble(valueAsString));
        }
        catch (NumberFormatException pE) {
            return null;
        }
    }
}

