/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.general.ICategoryOwner;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeOwner;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategoryID;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.eclipse.gui.viewers.ICachedItem;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import java.util.Collection;

public abstract class AbstractFrameData
extends AbstractAttributeOwner
implements IFrameDataRW,
ICategoryOwner,
ICachedItem {
    private static final ILogger logger = Logger.getLogger(AbstractFrameData.class);
    private ObjectTypeCategoryID categoryID;

    public AbstractFrameData(String uID, String projectUID, String cockpitDataType, Collection<IAttribute> attributes, IAttributeModificationManager modificationManager, IFrameProjectAgent projectAgent) {
        this(uID, projectUID, cockpitDataType, null, attributes, modificationManager, projectAgent);
    }

    public AbstractFrameData(String uID, String projectUID, String cockpitDataType, ObjectTypeCategoryID categoryID, Collection<IAttribute> attributes, IAttributeModificationManager modificationManager, IFrameProjectAgent projectAgent) {
        super(uID, projectUID, cockpitDataType, attributes, projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(cockpitDataType), modificationManager);
        this.categoryID = categoryID;
        this.handleMetaAttributes();
    }

    public AbstractFrameData(EOFrameData eo, String cockpitDataTypeID, IAttributeModificationManager attributeModificationManager, IFrameProjectAgent projectAgent) {
        super(eo.getUID(), eo.getProjectUID(), eo.getModCount(), eo.getCommitCount(), cockpitDataTypeID, eo.getAttributes(), attributeModificationManager, projectAgent);
        this.categoryID = ObjectTypeCategoryID.getObjectTypeCategoryID((EOObjectTypeCategoryID)eo.getCategoryID());
        this.handleMetaAttributes();
    }

    @Override
    public void setAttribute(IAttribute attribute) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        super.setAttribute(attribute);
        this.refreshMetaAttributes();
    }

    protected void setAttributeWithoutMetaAttributeRefresh(IAttribute attribute) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        super.setAttribute(attribute);
    }

    @Override
    public void refreshMetaAttributes() throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.getProjectUID());
        super.setAttribute(new Attribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR, DataTypeString.getInstanceString().getAttributeValueFromString(projectAgent.getFrameServerProxy().getCurrentUser().getDisplayName(), null, null)));
        super.setAttribute(new Attribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE, new Long(System.currentTimeMillis()).toString()));
    }

    private void handleMetaAttributes() {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.getProjectUID());
        if (!this.getAttributes().containsKey(AbstractAttributeTypesProvider.ATTRID_CREATOR)) {
            this.simplySetAttribute(new Attribute(AbstractAttributeTypesProvider.ATTRID_CREATOR, DataTypeString.getInstanceString().getAttributeValueFromString(projectAgent.getFrameServerProxy().getCurrentUser().getDisplayName(), null, null)));
        }
        if (!this.getAttributes().containsKey(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE)) {
            this.simplySetAttribute(new Attribute(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE, new Long(System.currentTimeMillis()).toString()));
        }
        if (!this.getAttributes().containsKey(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR)) {
            this.simplySetAttribute(new Attribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR, DataTypeString.getInstanceString().getAttributeValueFromString(projectAgent.getFrameServerProxy().getCurrentUser().getDisplayName(), null, null)));
        }
        if (!this.getAttributes().containsKey(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE)) {
            this.simplySetAttribute(new Attribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE, new Long(System.currentTimeMillis()).toString()));
        }
    }

    @Override
    public EOFrameData createEncodableObject() {
        EOFrameData eo = new EOFrameData();
        eo.setUID(this.getUID());
        eo.setProjectUID(this.getProjectUID());
        eo.setTypeID(this.getTypeID());
        eo.setModCount(this.getModificationCount());
        eo.setCommitCount(this.getCommitCount());
        eo.setCategoryID(this.getCategoryID() != null ? this.getCategoryID().createEncodableObject() : null);
        for (IAttribute attribute : this.getAttributes().values()) {
            IAttributeType type = this.getAttributeTypeProvider().getAttributeType(attribute.getAttributeTypeID());
            if (type == null) continue;
            IAttributeTypeDataType dataType = type.getDataType();
            try {
                IValueRange valueRange = type.getValueRange();
                EOEncodableObject eoValue = dataType.getValueAsEO(attribute.getAttributeValue(), valueRange);
                EOAttribute eoAttribute = new EOAttribute();
                eoAttribute.setAttributeTypeID(new EOAttributeTypeID(type.getAttributeTypeID().getUID(), type.getHumanReadableID()));
                eoAttribute.setValueAsEO(eoValue);
                eo.addAttribute(eoAttribute);
            }
            catch (ExInvalidDataType e) {
                logger.error("could not convert attribute to eoattribute", (Throwable)e);
            }
        }
        return eo;
    }

    public ObjectTypeCategoryID getCategoryID() {
        return this.categoryID;
    }

    public String getIconID() {
        return this.categoryID == null ? null : this.categoryID.getUID();
    }

    protected void simplySetCategoryID(ObjectTypeCategoryID newCategoryID) {
        this.categoryID = newCategoryID;
    }

    @Override
    public void setCategoryID(ObjectTypeCategoryID categoryID) {
        ObjectTypeCategoryID oldCategoryID = this.categoryID;
        this.categoryID = categoryID;
        try {
            this.getAttributeModificationManager().modifyCategoryID();
        }
        catch (EXNoPermission e) {
            this.categoryID = oldCategoryID;
            logger.error("Could not set Object Type Catgory ID", (Throwable)e);
        }
        catch (EXNoLock e) {
            this.categoryID = oldCategoryID;
            logger.error("Could not set Object Type Catgory ID", (Throwable)e);
        }
    }
}

