/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTitle;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.FrameDetailsProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProjectDetailsProvider2
extends FrameDetailsProvider {
    @Override
    public String getID() {
        return "com.arcway.cockpit.detailsprovider.project";
    }

    @Override
    protected IAttributeOwner getAttributeOwner(ICockpitProjectData itemToShow) {
        if (itemToShow instanceof IProjectAgent) {
            if (((ProjectAgent)itemToShow).isOpened()) {
                return ((ProjectAgent)itemToShow).getProjectMetaDataManager().getProject();
            }
            return null;
        }
        return ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID()).getProject();
    }

    @Override
    public boolean canBeDisplayed(ICockpitProjectData item) {
        return item instanceof ProjectAgent || item instanceof Project;
    }

    @Override
    protected List<DetailsElement> getTitleDetailsElements(ICockpitProjectData itemToShow) {
        ICockpitProjectData effectiveItem = this.getEffectiveItem(itemToShow);
        return Collections.singletonList(this.isOpen(effectiveItem) ? this.getDetailsElementTitleForAttribute(effectiveItem, ProjectAttributeTypeProvider.ATTRID_NAME, this.getTitleImage(effectiveItem)) : new DetailsElementTitle("general.project.closed.title", new DetailsValueTitle(((ProjectAgent)effectiveItem).getProjectName(), this.getTitleImage(effectiveItem))));
    }

    @Override
    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        ICockpitProjectData effectiveItem = this.getEffectiveItem(itemToShow);
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>(6);
        if (this.isOpen(effectiveItem)) {
            detailsElements.add(this.getDetailsElementMultiWithoutLabelForAttribute(effectiveItem, ProjectAttributeTypeProvider.ATTRID_DESCRIPTION));
            detailsElements.add(new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
            detailsElements.add(this.getDetailsElementForAttribute(effectiveItem, ProjectAttributeTypeProvider.ATTRID_LOGO));
            detailsElements.add(new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
            detailsElements.add(this.getDetailsElementForAttribute(effectiveItem, ProjectAttributeTypeProvider.ATTRID_COPYRIGHT));
            detailsElements.add(this.getDetailsElementForAttribute(effectiveItem, ProjectAttributeTypeProvider.ATTRID_LANGUAGE));
        } else {
            detailsElements.add(new DetailsElementMulti("general.project.closed.message", null, new DetailsValueMulti(Messages.getString("DetailsProviderProject.IsClosedMessage")), false));
        }
        return detailsElements;
    }

    @Override
    protected List<DetailsElement> getFooterDetailsElements(ICockpitProjectData itemToShow) {
        return Collections.emptyList();
    }

    @Override
    protected boolean showCustomProperties(ICockpitProjectData itemToShow) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID());
        return projectAgent.isOpened();
    }

    private ICockpitProjectData getEffectiveItem(ICockpitProjectData itemToShow) {
        ILockable effectiveItem = itemToShow instanceof IProjectAgent ? ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID()) : ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID()).getProject();
        return effectiveItem;
    }

    private boolean isOpen(ICockpitProjectData effectiveItem) {
        return effectiveItem instanceof Project || effectiveItem instanceof IProjectAgent && ((IProjectAgent)effectiveItem).isOpened();
    }
}

