/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.links.IFrameLinkManager;
import com.arcway.cockpit.frame.client.project.core.links.ILinkedItemDeletionListener;
import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;

public class FrameLinkManager
implements IFrameLinkManager {
    private final IFrameProjectAgent projectAgent;
    private final LinkManager linkManager;

    public FrameLinkManager(LinkManager linkManager, IFrameProjectAgent projectAgent) {
        assert (linkManager != null) : "linkManager must not be null";
        this.linkManager = linkManager;
        this.projectAgent = projectAgent;
    }

    @Override
    public void objectDeleted(ICockpitProjectData deletedElement) {
        ILOLinkAccessFacade lf = this.getLOLinkAccessFacade(deletedElement.getTypeID());
        if (lf != null) {
            lf.linkableObjectDeleted(deletedElement);
        }
    }

    public void construct() {
        for (ICockpitDataType dataType : FrameDataTypes.getFrameDataTypes()) {
            ILinkedDataAccessFacade facade = this.createLinkedDataAccessFacade(dataType);
            this.linkManager.registerLinkedDataAccessFacade(facade);
        }
    }

    public void destruct() {
    }

    private ILinkedDataAccessFacade createLinkedDataAccessFacade(ICockpitDataType dataType) {
        String tID;
        final String dataTypeID = tID = dataType.getCockpitDataTypeID();
        final IFrameDataManager dataManager = this.projectAgent.getDataManager(dataTypeID);
        return new ILinkedDataAccessFacade(){

            @Override
            public boolean isLinkedItemExistent(String uID, boolean checkOnServerState) {
                if (checkOnServerState) {
                    return dataManager.itemExistsOnServer(uID);
                }
                return dataManager.getCockpitProjectData(uID) != null;
            }

            @Override
            public boolean isCreationOfNewItemsPossible() {
                return false;
            }

            @Override
            public ICockpitProjectData getLinkedItem(String uID) {
                return dataManager.getCockpitProjectData(uID);
            }

            @Override
            public ICockpitProjectData getLinkedItemVersion(String UID, int version) {
                return this.getLinkedItem(UID);
            }

            @Override
            public ICockpitProjectData createNewItem() {
                return null;
            }

            @Override
            public ILabelProvider getLabelProvider() {
                return dataManager.getDataLabelProvider();
            }

            @Override
            public String getDataTypeID() {
                return dataTypeID;
            }
        };
    }

    @Override
    public IStatus addLink(EOLink link) {
        return this.linkManager.addLink(link);
    }

    @Override
    public Collection<EOLink> getAllLinks() {
        return this.linkManager.getAllLinks();
    }

    @Override
    public ICockpitProjectData getLinkableObject(EOLink link) {
        return this.linkManager.getLinkableObject(link);
    }

    @Override
    public ICockpitProjectData getModuleDataItem(EOLink link) {
        return this.linkManager.getModuleDataItem(link);
    }

    @Override
    public ILinkType getLinkType(EOLink link) {
        return this.linkManager.getLinkType(link);
    }

    @Override
    public ILinkType getLinkType(String linkTypeID) {
        return this.linkManager.getLinkType(linkTypeID);
    }

    @Override
    public Collection<EOLink> getUniqueElementLinks(ICockpitProjectData moduleDataItem) {
        return this.linkManager.getLinks(moduleDataItem, "com.arcway.cockpit.uniqueelement");
    }

    @Override
    public Collection<EOLink> addLinks(Collection<EOLink> links) {
        return this.linkManager.addLinks(links);
    }

    @Override
    public IStatus addLinkVersion(EOLinkLog link) {
        return this.linkManager.addLinkVersion(link);
    }

    @Override
    public ILinkTypeLinkAccessFacade registerLinkType(ILinkType linkType) {
        return this.linkManager.registerLinkType(linkType);
    }

    @Override
    public ILOLinkAccessFacade getLOLinkAccessFacade(String cockpitDataTypeID) {
        return this.linkManager.getLinkableObjectLinkAccessFacade(cockpitDataTypeID);
    }

    @Override
    public boolean hasModifiedLink(String dataUID) {
        return this.linkManager.hasModifiedLink(dataUID);
    }

    @Override
    public boolean hasModifiedLinks(String linkTypeID) {
        return this.linkManager.hasModifiedLinks(linkTypeID);
    }

    @Override
    public void addDeletionListener(ILinkedItemDeletionListener listener) {
        this.linkManager.addLinkedItemDeletionListener(listener);
    }

    @Override
    public Set<EOLink> getLinksOfLinkTypeForLinkableObject(ILinkType linkType, String linkableObjectUID) {
        return this.linkManager.getLinksOfLinkTypeForLinkableObject(linkType, linkableObjectUID);
    }

    @Override
    public Set<EOLink> getLinksOfLinkTypeForModuleDataItem(ILinkType linkType, String moduleDataUID) {
        return this.linkManager.getLinksOfLinkTypeForModuleDataItem(linkType, moduleDataUID);
    }
}

