/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.datamanager.AbstractDataManager_StringIDs;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.DataLabelProviderAdapter;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import de.plans.lib.xml.encoding.EOList;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractFrameDataManager<T extends ICockpitProjectData, T_EO extends EOGenericCockpitDatabaseData>
extends AbstractDataManager_StringIDs<T, T_EO>
implements IFrameDataManager {
    private IDataLabelProvider dataLabelProvider;

    protected abstract Image getImage();

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        for (String dataTypeID : this.getDataTypes()) {
            if (!dataTypeID.equals(cockpitDataTypeID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.initServerState(this.getRelevantServerDataLists(serverDataContainer));
        this.initLocalModifications();
    }

    protected abstract EOList<? extends T_EO>[] getRelevantServerDataLists(ServerDataContainer var1);

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public boolean hasLocalModifications() {
        return this.hasUncommitedChanges();
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        if (displayableOnly) {
            return new ILocalModificationContainer[]{this.getLocalModificationsForDisplayInGUI()};
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void discardLocalModifications() {
        this.clearLocalModifications();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        for (String dataTypeID : this.getDataTypes()) {
            ICockpitProjectData item = (ICockpitProjectData)this.getItem(dataTypeID, cockpitDataUID);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        if (this.dataLabelProvider == null) {
            this.dataLabelProvider = new DataLabelProviderAdapter(this.getDataLabelProvider2());
        }
        return this.dataLabelProvider;
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> modificationContainer) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> modificationContainer) {
    }
}

