/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.patched;

import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Edge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Node;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.NodeList;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.RevertableChange;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Subgraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.VirtualNode;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.derived.RelationViewGraphEdge;
import org.eclipse.draw2d.geometry.Insets;

class RelationViewVirtualNodeCreation
extends RevertableChange {
    private final Edge edge;
    private final DirectedGraph graph;
    private final Node[] nodes;
    private final Edge[] edges;
    private static final int INNER_EDGE_X = 2;
    private static final int LONG_EDGE_X = 8;

    public RelationViewVirtualNodeCreation(Edge edge, DirectedGraph graph) {
        RelationViewGraphEdge currentEdge;
        this.edge = edge;
        this.graph = graph;
        int size = edge.target.rank - edge.source.rank - 1;
        int offset = edge.source.rank + 1;
        Node prevNode = edge.source;
        this.nodes = new Node[size];
        this.edges = new Edge[size + 1];
        Insets padding = new Insets(0, edge.padding, 0, edge.padding);
        Subgraph s = null;
        Node left = edge.source;
        Node right = edge.target;
        Subgraph parent = right instanceof Subgraph ? (Subgraph)right : right.getParent();
        while (parent != null) {
            if (parent.isNested(left)) {
                s = parent;
                break;
            }
            parent = parent.getParent();
        }
        int i = 0;
        while (i < size) {
            VirtualNode currentNode = new VirtualNode("Virtual" + i + ':' + edge, s);
            this.nodes[i] = currentNode;
            currentNode.width = edge.width;
            if (s != null) {
                currentNode.nestingIndex = s.nestingIndex;
            }
            currentNode.height = 0;
            currentNode.setPadding(padding);
            currentNode.rank = offset + i;
            graph.ranks.getRank(offset + i).add(currentNode);
            currentEdge = new RelationViewGraphEdge(prevNode, currentNode, 1, edge.weight * 8);
            currentEdge.setEdgeType(((RelationViewGraphEdge)edge).getEdgeType());
            if (i == 0) {
                currentEdge.weight = edge.weight * 2;
                currentEdge.offsetSource = edge.offsetSource;
            }
            this.edges[i] = currentEdge;
            graph.edges.add(this.edges[i]);
            graph.nodes.add(currentNode);
            prevNode = currentNode;
            ++i;
        }
        currentEdge = new RelationViewGraphEdge(prevNode, edge.target, 1, edge.weight * 2);
        currentEdge.setEdgeType(((RelationViewGraphEdge)edge).getEdgeType());
        currentEdge.offsetTarget = edge.offsetTarget;
        RelationViewGraphEdge relationViewGraphEdge = currentEdge;
        this.edges[this.edges.length - 1] = relationViewGraphEdge;
        graph.edges.add(relationViewGraphEdge);
        graph.removeEdge(edge);
    }

    @Override
    public void revert() {
        Object element;
        this.edge.start = this.edges[0].start;
        this.edge.end = this.edges[this.edges.length - 1].end;
        this.edge.vNodes = new NodeList();
        Object[] objectArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            this.graph.removeEdge((Edge)element);
            ++n2;
        }
        objectArray = this.nodes;
        n = this.nodes.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            this.edge.vNodes.add(element);
            this.graph.removeNode((Node)element);
            ++n2;
        }
        this.edge.source.outgoing.add(this.edge);
        this.edge.target.incoming.add(this.edge);
        this.graph.edges.add(this.edge);
    }
}

