/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.frame.client.lib.relationviews.GraphToViewPartConverter;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewViewPartFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planview.print.PrintProcessor;
import com.arcway.planagent.planview.view.PVView;
import de.plans.lib.util.gui.IProgressDisplay;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class RelationViewGraphicProvider
implements IGraphicProvider {
    private final PVView view;
    private final String uid;
    private final String name;
    private final LabelCreator labelCreator;

    public RelationViewGraphicProvider(IRelationViewGraphBuilder graphBuilder, IRelationViewViewPartFactory viewPartFactory, LabelCreator labelCreator, ICockpitProjectData item, String itemName) {
        Font defaultFont;
        this.uid = item.getUID();
        this.name = itemName;
        this.labelCreator = labelCreator;
        Display display = Display.getDefault();
        GC gc = new GC((Drawable)display);
        Font font = defaultFont = gc.getFont();
        DirectedGraph graph = graphBuilder.createGraph(font, item);
        this.view = GraphToViewPartConverter.getViewPart(viewPartFactory, graph, font, labelCreator);
        gc.dispose();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public boolean launch(IProgressDisplay pDisplay) {
        return true;
    }

    @Override
    public void export(IPrinter printer, PageSetup hints) throws PrintingFailure {
        PrintProcessor printProcessor = new PrintProcessor();
        printProcessor.print(printer, this.view, hints, this.getName());
    }

    @Override
    public Rectangle getViewSizeInMM() {
        Rectangle viewSizeInMM;
        Rectangle viewSizeInPixels = this.view.calculateBounds();
        if (viewSizeInPixels != null) {
            double dpi = Display.getDefault().getDPI().x;
            double dpmm = dpi * 0.03937007874015748;
            double mmPerPixel = 1.0 / dpmm;
            viewSizeInMM = viewSizeInPixels.scale(mmPerPixel);
        } else {
            viewSizeInMM = null;
        }
        return viewSizeInMM;
    }

    @Override
    public void close() {
    }

    @Override
    public void dispose() {
        this.labelCreator.dispose();
    }
}

