/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.projectmanager;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListenerManager;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.IProjectAssociationManager;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.IPropertyChangesMultiplexer;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.ProjectSelectionService;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.PropertyListenerAndClassWrapper;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IViewFacade;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IWorkbenchWindow;

public class ProjectAssociationManager
implements IProjectAssociationManager,
IPropertyChangesMultiplexer,
IProjectAgentProvider {
    private final Map<String, IModuleProjectAgent> map_projectUID_projectAgent = new HashMap<String, IModuleProjectAgent>();
    private final Map<IViewFacade, String> map_viewFacade_projectUID = new HashMap<IViewFacade, String>();
    private final SetMap<String, IViewFacade> map_projectUID_viewFacade = new SetMap();
    private final Map<IViewFacade, Collection<PropertyListenerAndClassWrapper>> map_viewFacade_propertiesListeners = new HashMap<IViewFacade, Collection<PropertyListenerAndClassWrapper>>();
    private final ProjectSelectionService projectSelectionService = new ProjectSelectionService(this);

    private void storeProjectAgent(IModuleProjectAgent projectAgent) {
        this.map_projectUID_projectAgent.put(projectAgent.getProjectUID(), projectAgent);
    }

    private void removeProjectAgent(String projectUID) {
        this.map_projectUID_projectAgent.remove(projectUID);
    }

    @Override
    public IModuleProjectAgent getProjectAgent(String projectUID) {
        return this.map_projectUID_projectAgent.get(projectUID);
    }

    @Override
    public Collection<IModuleProjectAgent> getProjectAgentsOfAllOpenProjects() {
        return this.map_projectUID_projectAgent.values();
    }

    public boolean isOpenedProject(String projectUid) {
        return this.map_projectUID_projectAgent.containsKey(projectUid);
    }

    @Override
    public void storeView(IViewFacade viewFacade) {
        assert (viewFacade != null) : "view facade must not be null";
    }

    @Override
    public void activateView(IViewFacade viewFacade) {
        this.projectSelectionService.registerView(viewFacade);
        this.switchProjectForView(this.projectSelectionService.getActiveProjectForView(viewFacade), viewFacade);
    }

    @Override
    public void removeView(IViewFacade viewFacade) {
        assert (viewFacade != null) : "view facade must not be null";
        String projectUID = this.map_viewFacade_projectUID.get(viewFacade);
        if (projectUID != null) {
            this.map_viewFacade_projectUID.remove(viewFacade);
            this.map_projectUID_viewFacade.remove((Object)projectUID, (Object)viewFacade);
        }
        this.projectSelectionService.deregisterView(viewFacade);
        this.map_viewFacade_propertiesListeners.remove(viewFacade);
    }

    @Override
    public void registerPropertyChangesListener(IViewFacade viewFacade, IPropertyChangesListener listener, Class<?> clazz) {
        String projectUid;
        IModuleProjectAgent projectAgent;
        if (this.map_viewFacade_projectUID.containsKey(viewFacade) && (projectAgent = this.getProjectAgent(projectUid = this.map_viewFacade_projectUID.get(viewFacade))) != null) {
            projectAgent.getPropertyChangesListenerManager().register(listener, clazz);
        }
        PropertyListenerAndClassWrapper wrapper = new PropertyListenerAndClassWrapper(listener, clazz);
        Collection<PropertyListenerAndClassWrapper> listeners = this.map_viewFacade_propertiesListeners.containsKey(viewFacade) ? this.map_viewFacade_propertiesListeners.get(viewFacade) : new ArrayList<PropertyListenerAndClassWrapper>();
        listeners.add(wrapper);
        this.map_viewFacade_propertiesListeners.put(viewFacade, listeners);
    }

    @Override
    public void deregisterPropertyChangesListener(IViewFacade viewFacade, IPropertyChangesListener listener) {
        if (this.map_viewFacade_propertiesListeners.containsKey(viewFacade)) {
            ArrayList<PropertyListenerAndClassWrapper> listenerWrappers = new ArrayList<PropertyListenerAndClassWrapper>(this.map_viewFacade_propertiesListeners.get(viewFacade));
            for (PropertyListenerAndClassWrapper wrapper : listenerWrappers) {
                if (wrapper.listener != listener) continue;
                if (this.map_viewFacade_projectUID.containsKey(viewFacade)) {
                    String projectUid = this.map_viewFacade_projectUID.get(viewFacade);
                    IModuleProjectAgent projectAgent = this.getProjectAgent(projectUid);
                    projectAgent.getPropertyChangesListenerManager().deregister(wrapper.listener, wrapper.clazz);
                }
                this.map_viewFacade_propertiesListeners.get(viewFacade).remove(wrapper);
            }
        }
    }

    private void deregisterPropertyChangesListenersInFrame(IViewFacade viewFacade, String projectUID) {
        if (this.map_viewFacade_propertiesListeners.containsKey(viewFacade)) {
            IPropertyChangesListenerManager propertiesManager = this.getProjectAgent(projectUID).getPropertyChangesListenerManager();
            for (PropertyListenerAndClassWrapper wrapper : this.map_viewFacade_propertiesListeners.get(viewFacade)) {
                propertiesManager.deregister(wrapper.listener, wrapper.clazz);
            }
        }
    }

    private void registerPropertyChangesListenersInFrame(IViewFacade viewFacade, String projectUID) {
        if (projectUID != null && this.map_viewFacade_propertiesListeners.containsKey(viewFacade)) {
            IModuleProjectAgent projectAgent = this.getProjectAgent(projectUID);
            IPropertyChangesListenerManager propertiesManager = projectAgent.getPropertyChangesListenerManager();
            for (PropertyListenerAndClassWrapper wrapper : this.map_viewFacade_propertiesListeners.get(viewFacade)) {
                propertiesManager.register(wrapper.listener, wrapper.clazz);
            }
        }
    }

    public void switchProject(String projectUID, Collection<IViewFacade> views) {
        for (IViewFacade viewFacade : views) {
            this.switchProjectForView(projectUID, viewFacade);
        }
    }

    private void switchProjectForView(String projectUID, IViewFacade viewFacade) {
        String oldProjectUID;
        String newProjectUID = null;
        if (this.isOpenedProject(projectUID)) {
            newProjectUID = projectUID;
        }
        if ((oldProjectUID = this.map_viewFacade_projectUID.get(viewFacade)) == null && newProjectUID == null || oldProjectUID != null && newProjectUID != null && oldProjectUID.equals(newProjectUID)) {
            return;
        }
        if (oldProjectUID != null) {
            this.deregisterPropertyChangesListenersInFrame(viewFacade, oldProjectUID);
            this.map_viewFacade_projectUID.remove(viewFacade);
            this.map_projectUID_viewFacade.remove((Object)oldProjectUID, (Object)viewFacade);
        }
        if (newProjectUID != null) {
            this.map_viewFacade_projectUID.put(viewFacade, newProjectUID);
            this.map_projectUID_viewFacade.add((Object)newProjectUID, (Object)viewFacade);
        }
        viewFacade.projectSwitch_beforeAssigningNewProject(newProjectUID);
        if (newProjectUID != null) {
            this.registerPropertyChangesListenersInFrame(viewFacade, newProjectUID);
        }
        viewFacade.projectSwitch_afterAssigningNewProject(newProjectUID);
    }

    public void openProject(IProjectAgent projectAgent) {
        assert (projectAgent != null);
        this.storeProjectAgent((IModuleProjectAgent)projectAgent);
    }

    public void closeProject(String projectUID) {
        ArrayList<IViewFacade> viewFacades = new ArrayList<IViewFacade>(this.map_projectUID_viewFacade.get((Object)projectUID));
        this.switchProject(null, viewFacades);
        this.callback_projectClosed(projectUID);
        this.removeProjectAgent(projectUID);
    }

    protected void callback_projectClosed(String projectUID) {
    }

    protected final String getActiveProjectForWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        return this.projectSelectionService.getActiveProjectForWorkbenchWindow(workbenchWindow);
    }
}

