/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.dnd;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import com.arcway.lib.eclipse.transfer.dnd.IDropHandler;
import java.util.Set;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public final class DropTarget
implements IDropHandler {
    private final int operations;
    private final Set<Transfer> transferTypes;
    private final IDropHandler dropHandler;
    private IClientFunctionLicenseType2 licenseType = null;
    private IProjectAgentProvider projectAgentProvider;
    private IActiveProjectProvider activeProjectProvider;

    public DropTarget(int operations, Set<Transfer> transferTypes, IDropHandler dropHandler, IClientFunctionLicenseType2 licenseType, IProjectAgentProvider projectAgentProvider, IActiveProjectProvider activeProjectProvider) {
        this(operations, transferTypes, dropHandler);
        assert (licenseType == null || projectAgentProvider != null);
        this.licenseType = licenseType;
        this.projectAgentProvider = projectAgentProvider;
        this.activeProjectProvider = activeProjectProvider;
    }

    public DropTarget(int operations, Set<Transfer> transferTypes, IDropHandler handler) {
        assert (transferTypes != null) : "transferTypes must not be null";
        assert (handler != null) : "listener must not be null";
        this.operations = operations;
        this.transferTypes = transferTypes;
        this.dropHandler = handler;
    }

    public int getOperations() {
        return this.operations;
    }

    public Set<Transfer> getTransferTypes() {
        return this.transferTypes;
    }

    public boolean isDropPossible(DropTargetEvent event, int location, Control targetControl, DropTargetParameters parametersToChoose) {
        if (this.licenseAvailable()) {
            return this.dropHandler.isDropPossible(event, location, targetControl, parametersToChoose);
        }
        return false;
    }

    public boolean performDrop(DropTargetEvent event, int location, Control targetControl) {
        if (this.licenseAvailable()) {
            return this.dropHandler.performDrop(event, location, targetControl);
        }
        return false;
    }

    public boolean licenseAvailable() {
        if (this.licenseType != null) {
            String projectUID = this.activeProjectProvider.getActiveProject();
            if (projectUID != null) {
                IFrameProjectAgent projectAgent = (IFrameProjectAgent)this.projectAgentProvider.getProjectAgent(projectUID);
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense(this.licenseType);
                boolean hasLicense = !this.licenseType.isDenial(license);
                return hasLicense;
            }
            return false;
        }
        return true;
    }
}

