/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.dnd;

import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.lib.eclipse.transfer.dnd.IDragSourceListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class DataViewDragSourceListener
implements IDragSourceListener {
    private final Collection<DragSource> dragSources;
    private ISelectionProvider selectionProvider;
    private org.eclipse.swt.dnd.DragSource swtDragAgent;
    private int supportedOperations = 0;
    private Set<DragSource> activeDragSources;

    public DataViewDragSourceListener(ISelectionProvider selectionProvider, DragSource[] dragSources) {
        this.selectionProvider = selectionProvider;
        this.dragSources = Arrays.asList(dragSources);
        for (DragSource dragSource : this.dragSources) {
            this.supportedOperations |= dragSource.getOperations();
        }
        this.activeDragSources = Collections.emptySet();
    }

    public void dragStart(DragSourceEvent event) {
        boolean dragPossible = false;
        this.activeDragSources = new HashSet<DragSource>();
        HashSet<Transfer> availableTransfers = new HashSet<Transfer>();
        for (DragSource dragSource : this.dragSources) {
            if (!dragSource.isDragPossible(event, this.selectionProvider)) continue;
            dragPossible = true;
            this.activeDragSources.add(dragSource);
            availableTransfers.addAll(dragSource.getTransferTypes());
        }
        this.swtDragAgent.setTransfer(availableTransfers.toArray(new Transfer[availableTransfers.size()]));
        event.doit = dragPossible;
    }

    public void dragSetData(DragSourceEvent event) {
        for (DragSource dragSource : this.activeDragSources) {
            for (Transfer transfer : dragSource.getTransferTypes()) {
                if (!transfer.isSupportedType(event.dataType)) continue;
                event.data = dragSource.getDragData(event, this.selectionProvider);
                return;
            }
        }
        event.data = null;
    }

    public void dragFinished(DragSourceEvent event) {
        for (DragSource dragSource : this.activeDragSources) {
            dragSource.finishDrag(event, this.selectionProvider);
        }
        this.activeDragSources = Collections.emptySet();
    }

    public int getSupportedOperations() {
        return this.supportedOperations;
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public void setSWTDragAgent(org.eclipse.swt.dnd.DragSource dragSource) {
        this.swtDragAgent = dragSource;
    }
}

