/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards.newproject;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.properties.IFramePropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.PropertyAdvancedProject;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.IProjectTemplate;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileFormatVersionIncompatibleException;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.java.locale.LocaleHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class CreateNewProjectAdvancedPage
extends WizardPage
implements IFramePropertiesDialog {
    private static final ILogger logger = Logger.getLogger(CreateNewProjectAdvancedPage.class);
    private static final String NO_TEMPLATE = "noTemplate";
    private static final String USER_DEFINED_TEMPLATE = "userDefinedTemplate";
    private final PropertyAdvancedProject dialogPage;
    private final IWorkbenchPage workbenchPage;
    private Composite rootComposite;
    private Composite compTemplateSelection;
    private Text txtDescription;
    private List lstTemplates;
    private Composite compLanguageSelect;
    private Combo cmbLanguage;
    private final ArrayList<String> languageList = new ArrayList();
    private Composite compTemplatePath;
    private Label labelTemplatePath;
    private Text txtTemplatePath;
    private Button btnSelectTemplate;
    private String language = Locale.getDefault().getLanguage();
    private IProjectTemplate selectedTemplate = null;
    private ProjectFileAccess projectFileAccess = null;
    private final String predefinedCopyright;
    private final IStreamResource predefinedLogoFile;

    protected CreateNewProjectAdvancedPage(IWorkbenchPage workbenchPage, String predefinedCopyright, IStreamResource predefinedLogoFile, ProjectFileAccess projectTemplate) {
        super("advanced");
        this.workbenchPage = workbenchPage;
        this.projectFileAccess = projectTemplate;
        this.dialogPage = new PropertyAdvancedProject();
        this.dialogPage.init(this);
        this.predefinedCopyright = predefinedCopyright;
        this.predefinedLogoFile = predefinedLogoFile;
    }

    @Override
    public boolean mayModify() {
        return true;
    }

    @Override
    public String getProjectUID() {
        return null;
    }

    public void createControl(Composite parent) {
        this.rootComposite = new Composite(parent, 0);
        this.rootComposite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        this.rootComposite.setLayoutData((Object)gd);
        if (this.projectFileAccess == null) {
            this.compTemplateSelection = new Composite(this.rootComposite, 0);
            this.compTemplateSelection.setLayout((Layout)new GridLayout(3, false));
            gd = new GridData(1808);
            gd.minimumHeight = 100;
            this.compTemplateSelection.setLayoutData((Object)gd);
            Composite comp1 = new Composite(this.compTemplateSelection, 0);
            comp1.setLayout((Layout)new GridLayout());
            gd = new GridData(1808);
            comp1.setLayoutData((Object)gd);
            Label header1 = new Label(comp1, 0);
            header1.setText(Messages.getString("CreateNewProjectAdvancedPage.ProjectTemplate"));
            this.lstTemplates = new List(comp1, 2564);
            gd = new GridData(1808);
            gd.minimumWidth = 250;
            gd.minimumHeight = 60;
            this.lstTemplates.setLayoutData((Object)gd);
            this.lstTemplates.add(Messages.getString("CreateNewProjectAdvancedPage.none"));
            this.lstTemplates.setData("0", (Object)NO_TEMPLATE);
            this.lstTemplates.add(Messages.getString("CreateNewProjectAdvancedPage.user_defined_template"));
            this.lstTemplates.setData("1", (Object)USER_DEFINED_TEMPLATE);
            Set<IProjectTemplate> templates = CreateNewProjectAdvancedPage.getExtensionTemplates();
            int index = 2;
            for (IProjectTemplate template : templates) {
                this.lstTemplates.add(template.getName());
                this.lstTemplates.setData(Integer.toString(index), (Object)template);
                ++index;
            }
            this.lstTemplates.select(0);
            this.lstTemplates.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CreateNewProjectAdvancedPage.this.templateSelected();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Composite comp3 = new Composite(this.compTemplateSelection, 0);
            comp3.setLayout((Layout)new GridLayout());
            gd = new GridData(1808);
            gd.widthHint = 250;
            comp3.setLayoutData((Object)gd);
            Label header3 = new Label(comp3, 0);
            header3.setText(Messages.getString("CreateNewProjectAdvancedPage.TemplateDescription"));
            this.txtDescription = new Text(comp3, 8389186);
            this.txtDescription.setEditable(false);
            this.txtDescription.setLayoutData((Object)new GridData(1808));
            this.createTemplatePathArea();
        }
        this.dialogPage.getPropertyPage(this.rootComposite);
        if (this.predefinedCopyright != null) {
            this.dialogPage.setCopyrightText(this.predefinedCopyright);
        }
        if (this.predefinedLogoFile != null) {
            this.dialogPage.setLogoFile(this.predefinedLogoFile);
        }
        this.setTitle(Messages.getString("CreateNewProjectAdvancedPage.Title"));
        if (this.compTemplateSelection != null) {
            this.setMessage(Messages.getString("CreateNewProjectAdvancedPage.StandardMessage"));
        } else {
            this.setMessage(Messages.getString("CreateNewProjectAdvancedPage.set_advanced_attributes"));
        }
        this.templateSelected();
        this.setControl((Control)this.rootComposite);
    }

    private void activateTemplatePathWidget() {
        if (this.compLanguageSelect != null && !this.compLanguageSelect.isDisposed()) {
            this.compLanguageSelect.dispose();
            this.compLanguageSelect = null;
        }
        if (this.compTemplatePath == null || this.compTemplatePath.isDisposed()) {
            this.createTemplatePathArea();
        }
        this.compTemplateSelection.layout();
    }

    private void activateSelectLanguageWidget() {
        if (this.compTemplatePath != null && !this.compTemplatePath.isDisposed()) {
            this.compTemplatePath.dispose();
            this.compTemplatePath = null;
        }
        if (this.compLanguageSelect == null || this.compLanguageSelect.isDisposed()) {
            this.createLanguageSelectArea();
        }
        this.compTemplateSelection.layout();
    }

    private void createTemplatePathArea() {
        this.compTemplatePath = new Composite(this.compTemplateSelection, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.compTemplatePath.setLayoutData((Object)gridData);
        this.compTemplatePath.setLayout((Layout)new GridLayout(3, false));
        this.labelTemplatePath = new Label(this.compTemplatePath, 0);
        this.labelTemplatePath.setText(Messages.getString("CreateNewProjectAdvancedPage.TemplateFileLabel"));
        this.txtTemplatePath = new Text(this.compTemplatePath, 2048);
        this.txtTemplatePath.setEditable(false);
        this.txtTemplatePath.setLayoutData((Object)new GridData(768));
        this.btnSelectTemplate = new Button(this.compTemplatePath, 0);
        this.btnSelectTemplate.setLayoutData((Object)new GridData());
        this.btnSelectTemplate.setText("...");
        this.btnSelectTemplate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateNewProjectAdvancedPage.this.chooseFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.projectFileAccess != null) {
            this.projectFileAccess.dispose();
            this.projectFileAccess = null;
        }
    }

    private void createLanguageSelectArea() {
        this.compLanguageSelect = new Composite(this.compTemplateSelection, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.compLanguageSelect.setLayoutData((Object)gridData);
        this.compLanguageSelect.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.compLanguageSelect, 0);
        label.setText(Messages.getString("CreateNewProjectAdvancedPage.LanguageLabel"));
        this.cmbLanguage = new Combo(this.compLanguageSelect, 0);
        this.cmbLanguage.setLayoutData((Object)new GridData(768));
        this.cmbLanguage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateNewProjectAdvancedPage.this.languageSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void templateSelected() {
        if (this.lstTemplates != null) {
            this.clearLanguageCombo();
            int templateIndex = this.lstTemplates.getSelectionIndex();
            if (templateIndex > -1) {
                String strIndex = Integer.toString(templateIndex);
                Object data = this.lstTemplates.getData(strIndex);
                if (data instanceof IProjectTemplate) {
                    this.activateSelectLanguageWidget();
                    this.selectedTemplate = (IProjectTemplate)data;
                    Set<Locale> locals = CreateNewProjectAdvancedPage.getAvailableLanguages(this.selectedTemplate);
                    this.fillLanguageListAndSelectDefault(locals);
                    this.txtDescription.setText(this.selectedTemplate.getDescription());
                    this.loadDataFromTemplate(null);
                } else {
                    this.selectedTemplate = null;
                    String entry = (String)data;
                    if (entry.equals(NO_TEMPLATE)) {
                        Locale[] allLocals;
                        this.activateSelectLanguageWidget();
                        Set<Locale> allLanguages = CreateNewProjectAdvancedPage.createLanguageSortingSet();
                        Locale[] localeArray = allLocals = LocaleHelper.getAvailableLocales();
                        int n = allLocals.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Locale element = localeArray[n2];
                            allLanguages.add(element);
                            ++n2;
                        }
                        this.fillLanguageListAndSelectDefault(allLanguages);
                        this.txtDescription.setText(Messages.getString("CreateNewProjectAdvancedPage.create_empty"));
                        this.dialogPage.resetLogoFile();
                        this.dialogPage.setDefaultCopyrightText(new Locale(this.getLanguage()));
                        if (this.projectFileAccess != null) {
                            this.projectFileAccess.dispose();
                            this.projectFileAccess = null;
                        }
                    } else {
                        this.activateTemplatePathWidget();
                        this.txtDescription.setText(Messages.getString("CreateNewProjectAdvancedPage.choose_file"));
                    }
                }
            }
        }
    }

    private void languageSelected() {
        if (this.selectedTemplate != null) {
            this.loadDataFromTemplate(null);
        } else {
            this.dialogPage.setDefaultCopyrightText(new Locale(this.getLanguage()));
        }
    }

    private void fillLanguageListAndSelectDefault(Set<Locale> locals) {
        this.clearLanguageCombo();
        for (Locale locale : locals) {
            this.addLanguageToList(locale);
        }
        this.selectDefaultLanguage();
    }

    private void clearLanguageCombo() {
        if (this.cmbLanguage != null && !this.cmbLanguage.isDisposed()) {
            this.cmbLanguage.removeAll();
            this.languageList.clear();
        }
    }

    private void addLanguageToList(Locale locale) {
        if (this.cmbLanguage != null && !this.cmbLanguage.isDisposed()) {
            this.cmbLanguage.add(LocaleHelper.getDisplayLanguage((Locale)locale));
            this.languageList.add(locale.getLanguage());
        }
    }

    private void selectDefaultLanguage() {
        if (this.cmbLanguage != null && !this.cmbLanguage.isDisposed()) {
            int index = this.languageList.indexOf(Locale.getDefault().getLanguage());
            if (index >= 0) {
                this.cmbLanguage.select(index);
            } else if (this.languageList.size() > 0) {
                this.cmbLanguage.select(0);
            }
        }
    }

    private static Set<Locale> createLanguageSortingSet() {
        return new TreeSet<Locale>(new Comparator<Locale>(){

            @Override
            public int compare(Locale l0, Locale l1) {
                return LocaleHelper.getDisplayLanguage((Locale)l0).compareToIgnoreCase(LocaleHelper.getDisplayLanguage((Locale)l1));
            }
        });
    }

    private static Set<Locale> getAvailableLanguages(IProjectTemplate template) {
        Set<Locale> result = CreateNewProjectAdvancedPage.createLanguageSortingSet();
        result.addAll(template.getAvailableLanguages());
        return result;
    }

    private static File getLocalFile(IProjectTemplate template, Locale locale) {
        return template.getTemplateFile(locale);
    }

    private static Set<IProjectTemplate> getExtensionTemplates() {
        TreeSet<IProjectTemplate> sortedSet = new TreeSet<IProjectTemplate>(new Comparator<IProjectTemplate>(){

            @Override
            public int compare(IProjectTemplate p0, IProjectTemplate p1) {
                return p0.getName().compareToIgnoreCase(p1.getName());
            }
        });
        sortedSet.addAll(ExtensionMgr.getDefault().getExtension("projecttemplates", "template", "template", IProjectTemplate.class));
        return sortedSet;
    }

    private void chooseFile() {
        String fileExtension = FramePlugin.getFileExtensionForTemplate();
        File startPath = new File(this.txtTemplatePath.getText().trim()).getParentFile();
        FileChooserDialog dialog = new FileChooserDialog(new String[]{"*." + fileExtension}, startPath, this.getShell());
        File file = dialog.openForLoad();
        if (file != null) {
            this.selectedTemplate = null;
            this.loadDataFromTemplate(file);
            if (this.projectFileAccess != null) {
                this.txtTemplatePath.setText(file.getAbsolutePath());
            } else {
                this.txtTemplatePath.setText("");
            }
        }
    }

    private void loadDataFromTemplate(File file) {
        if (this.projectFileAccess != null) {
            this.projectFileAccess.dispose();
            this.projectFileAccess = null;
        }
        try {
            EOProject project;
            if (file != null) {
                this.projectFileAccess = new ProjectFileAccess(file, 1, this.workbenchPage.getWorkbenchWindow().getShell());
            } else if (this.selectedTemplate != null) {
                File localeFile = CreateNewProjectAdvancedPage.getLocalFile(this.selectedTemplate, new Locale(this.getLanguage()));
                this.projectFileAccess = new ProjectFileAccess(localeFile, 1, null);
            }
            if (this.projectFileAccess != null && (project = this.projectFileAccess.getProjectMetaData()) != null) {
                String copyright = Project.getCopyright(project);
                String containedLanguage = Project.getLanguage(project);
                IStreamResource logoFile = this.projectFileAccess.getProjectLogo();
                if (copyright != null) {
                    this.dialogPage.setCopyrightText(copyright);
                }
                if (containedLanguage != null) {
                    this.dialogPage.setLanguage(containedLanguage);
                    this.language = containedLanguage;
                }
                if (logoFile != null) {
                    this.dialogPage.setLogoFile(logoFile);
                }
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException e) {
            logger.error("Error when accessing project file.", (Throwable)e);
            if (this.projectFileAccess != null) {
                this.projectFileAccess.dispose();
                this.projectFileAccess = null;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ProjectTemplateFileDropListener.cant_access_file.title"), (String)Messages.getString("ProjectTemplateFileDropListener.cant_access_file.message"));
        }
        catch (ProjectFileFormatVersionIncompatibleException e) {
            logger.error("Incompatible project file version.", (Throwable)e);
            if (this.projectFileAccess != null) {
                this.projectFileAccess.dispose();
                this.projectFileAccess = null;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ProjectTemplateFileDropListener.file_format_incompatible"), (String)Messages.getString("ProjectTemplateFileDropListener.FileHasIncompatibleVersion.Message"));
        }
    }

    public IStreamResource getLogoFileResource() {
        return this.dialogPage.getLogoFile();
    }

    public ProjectFileAccess getTemplateFile() {
        return this.projectFileAccess;
    }

    public String getCopyrightNotice() {
        return this.dialogPage.getCopyrightNotice();
    }

    public String getLanguage() {
        int index;
        if (this.cmbLanguage != null && !this.cmbLanguage.isDisposed() && (index = this.cmbLanguage.getSelectionIndex()) > -1) {
            return this.languageList.get(index);
        }
        return this.language;
    }

    @Override
    public void setMessage(String message, int severity, IPropertiesListEntry caller) {
        this.setMessage(message, severity);
    }

    @Override
    public void setTitle(String title, IPropertiesListEntry entry) {
        this.setTitle(title);
    }

    @Override
    public void setIsCommitable(boolean isCommitable, IPropertiesListEntry caller) {
        this.setPageComplete(isCommitable);
        this.getContainer().updateButtons();
    }

    @Override
    public void setIsCancelable(boolean isCancelable, IPropertiesListEntry caller) {
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    @Override
    public IFrameProjectAgent getProjectAgent() {
        return null;
    }

    public void projectCreationCompleted() {
        this.dialogPage.cancelPropertyChanges1();
    }
}

