/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.MainImportWizard;
import com.arcway.cockpit.frame.client.global.gui.wizards.WizardInformation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MainImportWizardSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    public static final String PROJECT_AGENT_HACK_VARIABLE = "ProjectImporter";
    public static final String PARENT_SECTION_HACK_VARIABLE = "ParentSection";
    private final List importWizards;

    public MainImportWizardSelectionPage(String pageName, List importWizards) {
        super(pageName);
        this.importWizards = importWizards;
        this.setTitle(Messages.getString("MainImportWizardSelectionPage.Select_1"));
    }

    public void createControl(Composite parent) {
        parent.getShell().setData(PROJECT_AGENT_HACK_VARIABLE, (Object)((MainImportWizard)this.getWizard()).getProjectAgent());
        parent.getShell().setData(PARENT_SECTION_HACK_VARIABLE, (Object)((MainImportWizard)this.getWizard()).getSection());
        Composite filler = new Composite(parent, 0);
        filler.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(filler, 0);
        composite.setLayout((Layout)new GridLayout());
        Label importSource = new Label(composite, 0);
        importSource.setText(Messages.getString("MainImportWizardSelectionPage.Select_an_import_source__4"));
        importSource.setLayoutData((Object)new GridData(512));
        Composite fillC = new Composite(composite, 0);
        fillC.setLayout((Layout)new FillLayout());
        fillC.setLayoutData((Object)new GridData(1808));
        TableViewer listViewer = new TableViewer(fillC, 2816);
        listViewer.setContentProvider((IContentProvider)new ImportWizardListContentProvider());
        listViewer.setLabelProvider((IBaseLabelProvider)new ImportWizardListLabelProvider());
        listViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        listViewer.addDoubleClickListener((IDoubleClickListener)this);
        listViewer.setSorter(new ViewerSorter());
        listViewer.setInput((Object)this.importWizards);
        this.setControl((Control)filler);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        WizardInformation wi = (WizardInformation)selection.getFirstElement();
        this.setDescription(wi.getDescription());
        if (!wi.hasPermission()) {
            this.setMessage(wi.getPermissionErrorText(), 3);
            this.setSelectedNode(null);
        } else {
            this.setMessage(null, 3);
            this.setSelectedNode(wi);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        WizardInformation wi = (WizardInformation)selection.getFirstElement();
        this.setSelectedNode(wi);
        if (wi.hasPermission()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    private static class ImportWizardListContentProvider
    implements IStructuredContentProvider {
        private ImportWizardListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ImportWizardListLabelProvider
    implements ILabelProvider {
        private ImportWizardListLabelProvider() {
        }

        public Image getImage(Object element) {
            return ((WizardInformation)element).getImage();
        }

        public String getText(Object element) {
            return ((WizardInformation)element).getWizardName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

