/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.validators.RenamePlanValidator;
import com.arcway.cockpit.frame.client.global.gui.wizards.AbstractWizardPageWithCategorySelection;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanFileFactoryDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreatePlanWizardPage
extends AbstractWizardPageWithCategorySelection {
    private static final ILogger logger = Logger.getLogger(CreatePlanWizardPage.class);
    private final ISection parentSection;
    private final RenamePlanValidator renamePlanValidator;
    private String newName;
    private String newDescription;
    private PlanFileFactoryDescription selectedFactory;
    private final Collection<IModificationProblem> problems = new ArrayList<IModificationProblem>();
    private final List<Image> images = new ArrayList<Image>();
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return CreatePlanWizardPage.this.parentSection;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            if (!(childOperand instanceof ISection)) {
                return null;
            }
            return (IPermissionOperand)CreatePlanWizardPage.this.projectAgent.getFrameSectionManager().getParent((IAttributeOwner)((ISection)childOperand));
        }
    };
    private Combo categoryCombo;

    public CreatePlanWizardPage(ISection section, IFrameProjectAgent projectAgent) {
        super(projectAgent, "main page");
        this.parentSection = section;
        this.renamePlanValidator = new RenamePlanValidator(projectAgent, section.getUID());
    }

    @Override
    public void createControl_internal(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(2, false));
        this.setPageComplete(false);
        this.setTitle(Messages.getString("CreatePlanWizard.New_Plan_4"));
        Label label = new Label(base, 256);
        GridDataFactory.fillDefaults().align(4, 2).grab(false, false).applyTo((Control)label);
        label.setText(String.valueOf(ObjectTypeCategoryLabels.LABEL_CATEGORY) + ":");
        this.categoryCombo = new Combo(base, 12);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this.categoryCombo);
        LineSeparator line = new LineSeparator(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)line);
        Label space = new Label(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)space);
        Label lblName = new Label(base, 0);
        lblName.setText(Messages.getString("CreatePlanWizardPage.Name__1"));
        final Text txtName = new Text(base, 2048);
        txtName.setLayoutData((Object)new GridData(768));
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String msg = CreatePlanWizardPage.this.renamePlanValidator.isValid(txtName.getText().trim());
                if (msg != null) {
                    CreatePlanWizardPage.this.setErrorMessage(msg);
                    CreatePlanWizardPage.this.setPageComplete(false);
                } else {
                    CreatePlanWizardPage.this.setErrorMessage(null);
                    CreatePlanWizardPage.this.newName = txtName.getText().trim();
                    CreatePlanWizardPage.this.setPageComplete(true);
                }
            }
        });
        Label lblDescription = new Label(base, 0);
        lblDescription.setText(Messages.getString("CreatePlanWizardPage.Description__3"));
        final Text txtDescription = new Text(base, 2626);
        txtDescription.setLayoutData((Object)new GridData(1808));
        txtDescription.setText("\n\n\n\n");
        GridData gridData = new GridData(768);
        gridData.heightHint = txtDescription.computeSize((int)-1, (int)-1).y;
        txtDescription.setText("");
        IAttributeTypesProvider attributeTypesProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.plan");
        IAttributeType attributeTypeDescription = attributeTypesProv.getAttributeType(PlanAttributeTypeProvider.ATTRID_DESCRIPTION);
        if (!this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeTypeDescription, this.operandTree, true)) {
            this.addModificationProblem(new ModificationProblem(attributeTypeDescription, this.operandTree, this.projectAgent));
            txtDescription.setEditable(false);
        } else {
            txtDescription.setEditable(true);
            txtDescription.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreatePlanWizardPage.this.newDescription = txtDescription.getText().trim();
                }
            });
        }
        this.setControl((Control)base);
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        IWizardContainer container = newWizard.getContainer();
        if (container instanceof ArcwayWizardDialog) {
            ArcwayWizardDialog wizardDialog = (ArcwayWizardDialog)container;
            wizardDialog.setHelpEnabled(!this.problems.isEmpty());
        }
    }

    private void addModificationProblem(IModificationProblem problem) {
        assert (problem != null);
        IWizardContainer container = this.getWizard().getContainer();
        if (container instanceof ArcwayWizardDialog) {
            ArcwayWizardDialog dialog = (ArcwayWizardDialog)container;
            dialog.setHelpEnabled(true);
        }
        this.problems.add(problem);
    }

    public void performHelp() {
        ModificationProblemsDialog dialog = new ModificationProblemsDialog(this.problems, this.getShell());
        dialog.open();
    }

    protected String getNewName() {
        return this.newName;
    }

    protected String getNewDescription() {
        return this.newDescription;
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.images) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
    }

    @Override
    protected Combo getCategoryCombo() {
        return this.categoryCombo;
    }

    @Override
    protected String getFrameDataTypeID() {
        return "com.arcway.cockpit.plan";
    }
}

