/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.editors.UniqueElementOccurrenceListTransfer;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferAgent;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.eclipse.transfer.TransferContentBackdoorStorage;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanElementTypeDescription;
import com.arcway.planagent.controllinginterface.planeditor.plugin.PlanEditorExtensionMgr;
import com.arcway.planagent.controllinginterface.planeditor.plugin.TransferableTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class PlanEditorDragSupport {
    public DragSource getDragSource() {
        return new DragSource(this.getDragOperations(), this.getTransfers(), this.getDragHandler());
    }

    private int getDragOperations() {
        return 17;
    }

    private Set<Transfer> getTransfers() {
        return Collections.singleton(MultipleObjectTransferAgent.getInstance());
    }

    private IDragHandler getDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){

            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                Collection content = PlanEditorDragSupport.createContent(selectionProvider);
                if (content != null) {
                    TransferContentBackdoorStorage.setContent((Object)this, (MultipleObjectTransferContent)new MultipleObjectTransferContent((Object)content, (AbstractTransferAgentForMultipleObjectTransfer)MultipleObjectTransferAgent.getInstance()));
                    event.image = null;
                    return true;
                }
                return false;
            }

            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                Collection content = (Collection)TransferContentBackdoorStorage.getContent((AbstractTransferAgentForMultipleObjectTransfer)MultipleObjectTransferAgent.getInstance(), (Object)this);
                if (content == null) {
                    content = PlanEditorDragSupport.createContent(selectionProvider);
                }
                return content;
            }

            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                TransferContentBackdoorStorage.clearContent((Object)this);
            }
        };
        return dragHandler;
    }

    private static Collection<MultipleObjectTransferContent> createContent(ISelectionProvider selectionProvider) {
        ArrayList<MultipleObjectTransferContent> contentCollection = null;
        ISelection selection = selectionProvider.getSelection();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object dragData = structuredSelection.getFirstElement();
        if (dragData instanceof IUniqueElement) {
            final IUniqueElement ue = (IUniqueElement)dragData;
            ArrayList tmps = new ArrayList();
            Collection<PlanElementTypeDescription> descrs = ExtensionMgr.getDefault().getPlanElementTypeDescriptionForConstructionElementType(ue.getElementTypeID());
            for (PlanElementTypeDescription descr : descrs) {
                tmps.addAll(PlanEditorExtensionMgr.getDefault().getTransferableTemplates(descr.getPlanElementTypeID(), ue.getElementName(), null));
            }
            ArrayList<2> occurenceList = new ArrayList<2>(tmps.size());
            contentCollection = new ArrayList<MultipleObjectTransferContent>(tmps.size() + 1);
            for (final TransferableTemplate t : tmps) {
                contentCollection.add(t.getTransferableTemplate());
                IUniqueElementOccurrence occurenceToCreate = new IUniqueElementOccurrence(){

                    public String getElementUID() {
                        return ue.getUID();
                    }

                    public String getProjectUID() {
                        return ue.getProjectUID();
                    }

                    public String getPlanElementUID() {
                        return t.getPlanElement().getPlanElementUID();
                    }

                    public String getPlanUID() {
                        return "template";
                    }
                };
                occurenceList.add(occurenceToCreate);
            }
            contentCollection.add(new MultipleObjectTransferContent(UniqueElementOccurrenceListTransfer.createListToTransfer(occurenceList), (AbstractTransferAgentForMultipleObjectTransfer)UniqueElementOccurrenceListTransfer.getInstance()));
        }
        return contentCollection;
    }
}

