/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.lib.dataview;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataView;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewLabelProvider;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CustomPropertiesTreeDataViewProvider;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.GeneralTreeDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.ProjectAssociationManager;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewLabelProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewProvider;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.swt.graphics.Image;

public abstract class CockpitTreeDataViewProvider<ContentType>
extends TreeDataViewProvider<ContentType> {
    public CockpitTreeDataViewProvider(CockpitTreeDataView<ContentType> dataView) {
        super(dataView);
    }

    protected abstract ProjectAssociationManager getProjectAssociationManager();

    protected abstract Collection<Class<?>> getDataTypesThatTriggerRefresh();

    @Override
    public Collection<IColumnDescription> getColumnDescriptions(String projectUID) {
        LinkedList<IColumnDescription> columnDescriptions = new LinkedList<IColumnDescription>(this.getFixColumnProvider().getColumnDescriptions());
        columnDescriptions.addAll(GeneralTreeDataViewProvider.getColumnDescriptions(this.getGeneralColumnProvider()));
        if (projectUID != null) {
            CustomPropertiesTreeDataViewProvider<ContentType> customPropertyTreeDataViewProvider = CustomPropertiesTreeDataViewProvider.getInstance(projectUID, this.getFullModuleID(), this.getCustomPropertyColumnProvider(), true);
            columnDescriptions.addAll(customPropertyTreeDataViewProvider.getColumnDescriptions());
        }
        return columnDescriptions;
    }

    @Override
    protected ITreeDataViewLabelProvider createTreeLabelProvider() {
        return new CockpitTreeDataViewLabelProvider<ContentType>(this.getFullModuleID(), this.getFixColumnProvider(), this.getGeneralColumnProvider(), this.getCustomPropertyColumnProvider());
    }

    protected abstract IFixColumnProvider<ContentType> getFixColumnProvider();

    protected abstract IGeneralColumnProvider<ContentType> getGeneralColumnProvider();

    protected abstract ICustomPropertyColumnProvider<ContentType> getCustomPropertyColumnProvider();

    public static interface ICustomPropertyColumnProvider<ContentType> {
        public Collection<String> getDatatypesForWhichCustomPropertyColumnsAreToBeCreated();

        public String getProjectUID(ContentType var1);

        public IAttributeOwner getAttributeOwner(ContentType var1);
    }

    public static interface IFixColumnProvider<ContentType> {
        public Collection<IColumnDescription> getColumnDescriptions();

        public Image getColumnImage(ContentType var1, String var2);

        public String getColumnText(ContentType var1, String var2);
    }

    public static interface IGeneralColumnProvider<ContentType> {
        public boolean isCategoryColumnNeeded();

        public ObjectTypeCategory getCategory(ContentType var1);

        public String getAuthor(ContentType var1);

        public Long getCreationDate(ContentType var1);

        public String getCreationDateStringRepresentation(ContentType var1);

        public String getLastModifier(ContentType var1);

        public Long getDateOfLastModification(ContentType var1);

        public String getDateOfLastModificationStringRepresentation(ContentType var1);
    }
}

