/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.client.base.interfaces.general.ICategoryOwner;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.CEProperties;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsView;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsViewResources;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTitle;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.IDetailsProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoriesManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.resource.IStreamResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDetailsProvider2
implements IDetailsProvider,
IDetailsResourceProvider {
    private static final int SPACING = 3;
    private static final int OUTER_MARGIN_TOP = 45;
    private static final int OUTER_MARGIN_BOTTOM = 14;
    private static final int OUTER_MARGIN_LEFT = 25;
    private static final int OUTER_MARGIN_RIGHT = 25;
    private ScrolledComposite scroller;
    private ControlListener resizeListener;
    private Composite detailsArea;
    private Composite mainArea;
    private Composite footerArea;
    private List<Control> currentControls;
    private int currentMinWidthOfDetailsArea;
    public static final int LABEL_COLUMN_WIDTH = 200;
    public static final int VALUE_COLUMN_WIDTH = 100;
    private IWorkbenchPage containingWorkbenchPage;
    private ICockpitProjectData currentElementToShow = null;
    private DetailsView part = null;
    private IWorkbenchPartSite site = null;
    private IAction editAction;
    private CEProperties.Input currentEditActionInput;
    private boolean disposed = false;
    private Display display = null;
    private List<DetailsElement> currentlyDisplayedDetailsElements = new ArrayList<DetailsElement>();
    private List<DetailsElement> footerDetailsElements = new ArrayList<DetailsElement>();
    private DetailsViewResources detailsResources;

    public abstract String getTypeName(ICockpitProjectData var1);

    protected List<DetailsElement> getTitleDetailsElements(ICockpitProjectData itemToShow) {
        return Collections.emptyList();
    }

    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        return Collections.emptyList();
    }

    protected abstract List<DetailsElement> getCustomPropertyDetailsElements(ICockpitProjectData var1);

    protected List<DetailsElement> getAdditionalInformationDetailsElements(ICockpitProjectData itemToShow) {
        return Collections.emptyList();
    }

    protected List<DetailsElement> getFooterDetailsElements(ICockpitProjectData itemToShow) {
        return Collections.emptyList();
    }

    protected abstract IAttributeOwner getAttributeOwner(ICockpitProjectData var1);

    @Override
    public final String getTitle(ICockpitProjectData itemToBeDisplayed) {
        ObjectTypeCategoryID categoryID;
        if (itemToBeDisplayed instanceof ICategoryOwner && (categoryID = ((ICategoryOwner)itemToBeDisplayed).getCategoryID()) != null) {
            ObjectTypeCategoriesManager objectTypeCategoriesManager = ProjectMgr.getProjectMgr().getProjectAgent(itemToBeDisplayed.getProjectUID()).getObjectTypeCategoriesManager();
            ObjectTypeCategory category = objectTypeCategoriesManager.getCategory(categoryID);
            return category.getDisplayName();
        }
        return this.getTypeName(itemToBeDisplayed);
    }

    @Override
    public Collection<Class<?>> getDataTypesThatTriggerRefresh() {
        return new ArrayList(Collections.singleton(EOLink.class));
    }

    @Override
    public Collection<Class<?>> getDataTypesToBeRegisteredForPropertyChangeEvents() {
        return Collections.emptyList();
    }

    protected void init(IWorkbenchPartSite site_, IMemento memento) {
    }

    @Override
    public final Control createPartControl(Composite parent, IWorkbenchPartSite site_, IMemento memento, DetailsViewResources resources) {
        this.init(site_, memento);
        this.display = parent.getDisplay();
        this.detailsResources = resources;
        this.site = site_;
        if (site_ != null) {
            this.containingWorkbenchPage = site_.getPage();
            this.part = (DetailsView)site_.getPart();
        }
        this.editAction = new Action(){

            public void run() {
                if (AbstractDetailsProvider2.this.currentEditActionInput != null) {
                    CEProperties.openProperties(AbstractDetailsProvider2.this.currentEditActionInput, AbstractDetailsProvider2.this.containingWorkbenchPage, true);
                }
            }
        };
        this.editAction.setEnabled(false);
        this.editAction.setText(Messages.getString("DetailsView.Edit_1"));
        this.editAction.setToolTipText(Messages.getString("DetailsView.Edit_2"));
        this.editAction.setImageDescriptor(FramePlugin.getImageDescriptor("pencil.png"));
        this.createDetailsArea(parent);
        return this.scroller;
    }

    private Composite createDetailsArea(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 768);
        this.scroller.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scroller.getHorizontalBar().setIncrement(10);
        this.scroller.getVerticalBar().setIncrement(10);
        this.scroller.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractDetailsProvider2.this.disposeMMPRes();
            }
        });
        this.detailsArea = new Composite((Composite)this.scroller, 0);
        this.detailsArea.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout();
        layout.marginTop = 45;
        layout.marginRight = 25;
        layout.marginLeft = 25;
        layout.marginBottom = 14;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        this.detailsArea.setLayout((Layout)layout);
        this.mainArea = new Composite(this.detailsArea, 0);
        this.mainArea.setBackground(parent.getDisplay().getSystemColor(1));
        GridData mainLayoutData = new GridData(4, 4, true, false);
        this.mainArea.setLayoutData((Object)mainLayoutData);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        mainLayout.verticalSpacing = 3;
        this.mainArea.setLayout((Layout)mainLayout);
        Composite whitespace = new Composite(this.detailsArea, 0);
        whitespace.setBackground(parent.getDisplay().getSystemColor(1));
        Layout whiteSpaceLayout = new Layout(){

            protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
                return new Point(Math.max(1, hint), Math.max(1, hint2));
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        };
        whitespace.setLayout(whiteSpaceLayout);
        GridData whitespaceLayoutData = new GridData(4, 4, true, true);
        whitespace.setLayoutData((Object)whitespaceLayoutData);
        this.footerArea = new Composite(this.detailsArea, 0);
        this.footerArea.setBackground(parent.getDisplay().getSystemColor(1));
        GridData footerLayoutData = new GridData(4, 4, true, false);
        this.footerArea.setLayoutData((Object)footerLayoutData);
        GridLayout footerLayout = new GridLayout();
        footerLayout.marginWidth = 0;
        footerLayout.marginHeight = 0;
        footerLayout.verticalSpacing = 0;
        this.footerArea.setLayout((Layout)footerLayout);
        this.scroller.setContent((Control)this.detailsArea);
        this.currentControls = new ArrayList<Control>();
        return this.detailsArea;
    }

    @Override
    public final void showElement(ICockpitProjectData elementToShow) {
        if (elementToShow == null) {
            return;
        }
        this.currentElementToShow = elementToShow;
        this.currentEditActionInput = CEProperties.checkSuitabilityForPropertiesCommand(Collections.singleton(elementToShow));
        this.editAction.setEnabled(this.currentEditActionInput != null);
        this.updateView();
    }

    private void updateView() {
        int minWidthOfDetailsElements = 0;
        this.currentlyDisplayedDetailsElements = this.collectDetailsElementsAndValues(this.currentElementToShow);
        int newMinWidth = this.createDetailsElementWidgets(this.currentlyDisplayedDetailsElements, this.mainArea, this.site, false, this.currentControls);
        minWidthOfDetailsElements = Math.max(minWidthOfDetailsElements, newMinWidth);
        this.footerDetailsElements = this.collectFooterElementsAndValues(this.currentElementToShow);
        newMinWidth = this.createDetailsElementWidgets(this.footerDetailsElements, this.footerArea, this.site, true, this.currentControls);
        minWidthOfDetailsElements = Math.max(minWidthOfDetailsElements, newMinWidth);
        this.detailsArea.layout(true, true);
        this.detailsArea.redraw();
        if (this.resizeListener == null) {
            this.resizeListener = new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    AbstractDetailsProvider2.this.handleResize();
                }
            };
        }
        this.scroller.addControlListener(this.resizeListener);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.scroller.setOrigin(0, 0);
        this.currentMinWidthOfDetailsArea = minWidthOfDetailsElements + 25 + 25;
        this.scroller.setMinWidth(this.currentMinWidthOfDetailsArea);
        this.handleResize();
    }

    private int createDetailsElementWidgets(Collection<DetailsElement> detailsElements, Composite detailsArea_, IWorkbenchPartSite site_, boolean greyed, Collection<Control> controls) {
        int minWidthOfDetailsElements = 0;
        for (DetailsElement element : detailsElements) {
            Control childControl = element.createWidget(detailsArea_, site_, (IDetailsResourceProvider)this);
            if (childControl == null) continue;
            controls.add(childControl);
            childControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            element.fillWidget((IDetailsResourceProvider)this);
            element.setGrayed(greyed);
            int minElementWidth = element.getMinimumWidth();
            minWidthOfDetailsElements = Math.max(minWidthOfDetailsElements, minElementWidth);
        }
        return minWidthOfDetailsElements;
    }

    private void handleResize() {
        int availableHorizontalSpace = Math.max(this.scroller.getClientArea().width, this.currentMinWidthOfDetailsArea);
        Point detailsAreaSize = this.detailsArea.computeSize(availableHorizontalSpace, -1);
        this.scroller.setMinHeight(detailsAreaSize.y);
    }

    public void resourceResized() {
        this.handleResize();
        if (this.part != null) {
            this.part.triggerControlResizeTasks();
        }
    }

    @Override
    public void stopShowingElement() {
        this.currentElementToShow = null;
        this.currentEditActionInput = null;
        this.editAction.setEnabled(false);
        if (this.scroller != null && this.resizeListener != null) {
            this.scroller.removeControlListener(this.resizeListener);
        }
        for (Control control : this.currentControls) {
            control.dispose();
        }
        this.currentControls.clear();
        for (DetailsElement detailsElement : this.currentlyDisplayedDetailsElements) {
            detailsElement.dispose();
        }
        this.currentlyDisplayedDetailsElements.clear();
        for (DetailsElement detailsElement : this.footerDetailsElements) {
            detailsElement.dispose();
        }
        this.footerDetailsElements.clear();
        if (this.part != null) {
            this.part.clearControlResizeDelayedTasks();
        }
    }

    @Override
    public final boolean isEditEnabled() {
        return this.editAction.isEnabled();
    }

    @Override
    public final void edit() {
        this.editAction.run();
    }

    @Override
    public final IAction getEditAction() {
        return this.editAction;
    }

    protected final ICockpitProjectData getCurrentElementToShow() {
        return this.currentElementToShow;
    }

    private List<DetailsElement> collectDetailsElementsAndValues(ICockpitProjectData itemToShow) {
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        List<DetailsElement> title = this.getTitleDetailsElements(itemToShow);
        List<DetailsElement> fixAttributes = this.getFixAttributeDetailsElements(itemToShow);
        List<DetailsElement> customProperties = this.getCustomPropertyDetailsElements(itemToShow);
        List<DetailsElement> additionalInformation = this.getAdditionalInformationDetailsElements(itemToShow);
        detailsElements.addAll(title);
        detailsElements.addAll(fixAttributes);
        if (!customProperties.isEmpty()) {
            if (!fixAttributes.isEmpty()) {
                detailsElements.add(new DetailsElementSeparator("general.cpd.cps.sep", 8, new DetailsValueSeparator()));
            }
            detailsElements.addAll(customProperties);
        }
        if (!additionalInformation.isEmpty()) {
            if (!fixAttributes.isEmpty() || !customProperties.isEmpty()) {
                detailsElements.add(new DetailsElementSeparator("general.aid.ais.sep", 8, new DetailsValueSeparator()));
            }
            detailsElements.addAll(additionalInformation);
        }
        return detailsElements;
    }

    private List<DetailsElement> collectFooterElementsAndValues(ICockpitProjectData itemToShow) {
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        List<DetailsElement> footer = this.getFooterDetailsElements(itemToShow);
        if (!footer.isEmpty()) {
            detailsElements.add(new DetailsElementSeparator("general.fd.fs.sep", 0, new DetailsValueSeparator()));
            detailsElements.addAll(footer);
        }
        return detailsElements;
    }

    protected final List<DetailsElement> getDefaultCustomPropertyDetailsElements(ICockpitProjectData itemToShow) {
        return this.getDefaultCustomPropertyDetailsElements(itemToShow, false);
    }

    protected final List<DetailsElement> getDefaultCustomPropertyDetailsElements(ICockpitProjectData itemToShow, boolean isHistoricItem) {
        ArrayList<DetailsElement> detailsElements_ = new ArrayList<DetailsElement>();
        Locale projectLanguage = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID()).getLanguage());
        IAttributeOwner attributeOwner = this.getAttributeOwner(itemToShow);
        if (attributeOwner != null) {
            Shell shell = this.getContainingShell();
            IWorkbenchPage page = this.getAssociatedWorkbenchPage();
            for (IAttributeType attributeType : ObjectTypeCategories.getVisibleUserDefinedAttributeTypesForItem(attributeOwner, isHistoricItem)) {
                if (!attributeType.displayToUser()) continue;
                IAttribute attribute = attributeOwner.getAttribute(attributeType.getAttributeTypeID());
                detailsElements_.add(attributeType.getDataType().getDetailsElement(attributeType, attribute.getAttributeValue(), projectLanguage, shell, page));
            }
        }
        return detailsElements_;
    }

    protected final DetailsElement getDetailsElementForAttribute(ICockpitProjectData itemToShow, IAttributeTypeID attributeTypeID) {
        IAttributeOwner attributeOwner = this.getAttributeOwner(itemToShow);
        if (attributeOwner != null) {
            IAttributeType attributeType = attributeOwner.getAttributeType(attributeTypeID);
            IAttribute attribute = attributeOwner.getAttribute(attributeTypeID);
            Locale projectLanguage = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID()).getLanguage());
            if (attributeType != null) {
                return attributeType.getDataType().getDetailsElement(attributeType, attribute.getAttributeValue(), projectLanguage, this.getContainingShell(), this.getAssociatedWorkbenchPage());
            }
            return null;
        }
        return null;
    }

    protected final DetailsElementTitle getDetailsElementTitleForAttribute(ICockpitProjectData itemToShow, IAttributeTypeID attributeTypeID) {
        return this.getDetailsElementTitleForAttribute(itemToShow, attributeTypeID, null);
    }

    protected final DetailsElementTitle getDetailsElementTitleForAttribute(ICockpitProjectData itemToShow, IAttributeTypeID attributeTypeID, Image image) {
        IAttributeOwner attributeOwner = this.getAttributeOwner(itemToShow);
        if (attributeOwner != null) {
            IAttributeType attributeType = attributeOwner.getAttributeType(attributeTypeID);
            IAttribute attribute = attributeOwner.getAttribute(attributeTypeID);
            if (attributeType != null && attribute != null) {
                Locale projectLanguage = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID()).getLanguage());
                return new DetailsElementTitle(null, new DetailsValueTitle(attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), ",", projectLanguage), image));
            }
            return null;
        }
        return null;
    }

    protected final DetailsElement getDetailsElementMultiWithoutLabelForAttribute(ICockpitProjectData itemToShow, IAttributeTypeID attributeTypeID) {
        IAttributeOwner attributeOwner = this.getAttributeOwner(itemToShow);
        IAttributeType attributeType = attributeOwner.getAttributeType(attributeTypeID);
        Object value = attributeOwner.getAttribute(attributeTypeID).getAttributeValue();
        String valueAsString = attributeType.getDataType() instanceof DataTypeText ? DataTypeText.getInstanceText().getValueAsMultiLineString(value) : attributeType.getDataType().getValueAsSingleLineString(value, attributeType.getValueRange(), ",", Locale.getDefault());
        return new DetailsElementMulti(String.valueOf(attributeType.getCockpitDataTypeID()) + "-" + attributeType.getHumanReadableID(), attributeType.getDisplayName(), new DetailsValueMulti(valueAsString), false);
    }

    public final Font getTitleFont() {
        return this.detailsResources.getTitleFont();
    }

    public final Font getLabelFont() {
        return this.detailsResources.getLabelFont();
    }

    public final Font getValueFont() {
        return this.detailsResources.getValueFont();
    }

    public final Color getColour(int colourCode) {
        return this.detailsResources.getColor(colourCode);
    }

    public final Image getShowAllImage() {
        return this.detailsResources.getShowAllImage();
    }

    public Image getImage(IStreamResource imageResource) {
        return this.detailsResources.getImage(imageResource);
    }

    protected final DetailsView getContainingDetailsView() {
        DetailsView containingDetailsView = null;
        if (this.containingWorkbenchPage != null) {
            containingDetailsView = this.part;
        } else {
            IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (activePart instanceof DetailsView) {
                containingDetailsView = (DetailsView)activePart;
            }
        }
        return containingDetailsView;
    }

    protected final Shell getContainingShell() {
        Shell containingShell = this.containingWorkbenchPage != null ? this.containingWorkbenchPage.getWorkbenchWindow().getShell() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return containingShell;
    }

    protected final IWorkbenchPage getAssociatedWorkbenchPage() {
        DetailsView containingDetailsView = this.getContainingDetailsView();
        if (containingDetailsView != null) {
            return containingDetailsView.getSite().getPage();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public final Display getDisplay() {
        return this.display;
    }

    private void disposeMMPRes() {
        this.disposeResources();
        this.disposed = true;
    }

    protected void disposeResources() {
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    protected final List<DetailsElement> getCurrentlyDisplayedDetailsElements() {
        return this.currentlyDisplayedDetailsElements;
    }

    protected static ISelectionProvider createSelectionProvider(Object itemToShow) {
        StructuredSelection structuredSelection = new StructuredSelection(itemToShow);
        ISelectionProvider selectionProvider = new ISelectionProvider((IStructuredSelection)structuredSelection){
            private final /* synthetic */ IStructuredSelection val$structuredSelection;
            {
                this.val$structuredSelection = iStructuredSelection;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return this.val$structuredSelection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
        return selectionProvider;
    }

    public void addControlResizeDelayedTask(Runnable task) {
        if (this.part != null) {
            this.part.addControlResizeDelayedTask(task);
        }
    }
}

