/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class AttributeTextField
implements ModifyListener {
    private static final ILogger logger = Logger.getLogger(AttributeTextField.class);
    private final IAttributeType attributeType;
    private final Text textField;
    private boolean textIsModified = false;
    private final IAttributeOwner attributeOwner;
    private Collection<IModificationProblem> modificationProblems;

    public AttributeTextField(IAttributeOwner attributeOwner, IAttributeType attributeType, Text textField, IPropertiesDialog dialog) {
        assert (attributeType != null);
        this.attributeType = attributeType;
        this.textField = textField;
        this.attributeOwner = attributeOwner;
        textField.setEditable(dialog.mayModify());
        textField.addModifyListener((ModifyListener)this);
        if (attributeOwner instanceof IAttributeOwnerRW) {
            textField.setEnabled(true);
            IAttributeOwnerRW rw = (IAttributeOwnerRW)attributeOwner;
            this.modificationProblems = rw.checkGeneralAttributeModificationPermission(attributeType);
            textField.setEnabled(this.modificationProblems.isEmpty());
        } else {
            textField.setEnabled(false);
        }
        this.reset();
    }

    public Collection<IModificationProblem> getModificationProblems() {
        return this.modificationProblems;
    }

    public boolean mayModifyInGeneral() {
        if (this.attributeOwner instanceof IAttributeOwnerRW) {
            IAttributeOwnerRW rw = (IAttributeOwnerRW)this.attributeOwner;
            Collection<IModificationProblem> modProblems = rw.checkGeneralAttributeModificationPermission(this.attributeType);
            return modProblems.isEmpty();
        }
        return false;
    }

    public void reset() {
        this.textField.removeModifyListener((ModifyListener)this);
        try {
            Object value = this.attributeOwner.getAttribute(this.attributeType.getAttributeTypeID()).getAttributeValue();
            String valueAsString = this.attributeType.getDataType() instanceof DataTypeText ? DataTypeText.getInstanceText().getValueAsMultiLineString(value) : this.attributeType.getDataType().getValueAsSingleLineString(value, this.attributeType.getValueRange(), ",", Locale.getDefault());
            this.setText(valueAsString);
            this.textIsModified = false;
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
        }
        this.textField.addModifyListener((ModifyListener)this);
    }

    public boolean isModified() {
        return this.textIsModified;
    }

    public void modifyText(ModifyEvent e) {
        this.textIsModified = true;
    }

    public Object getText() {
        if (this.attributeType.getDataType() instanceof DataTypeText) {
            return DataTypeText.getInstanceText().getAttributeValueFromString(this.textField.getText(), null, null);
        }
        return DataTypeString.getInstanceString().getAttributeValueFromString(this.textField.getText(), null, null);
    }

    public IAttributeTypeID getAttributeTypeID() {
        return this.attributeType.getAttributeTypeID();
    }

    public String getAttributeTypeDisplayName() {
        return this.attributeType.getDisplayName();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }
}

