/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.global.gui.views.project.CreateProjectFromFileHelper;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import de.plans.psc.client.communication.ServerConnection;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHFileOpenProjectFile
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (activeShell != null) {
            String[] fileExtensions;
            FileChooserDialog dialog;
            File projectFile;
            IStructuredSelection currentSelection = CommandHandlerHelper.getRelevantSelection(event);
            ServerConnection serverConnection = null;
            if (currentSelection != null && !currentSelection.isEmpty()) {
                String serverID = ProjectSelectionAnalyser.extractServerID((ISelection)currentSelection);
                if (serverID != null) {
                    serverConnection = ProjectMgr.getProjectMgr().getServerConnectionByServerID(serverID);
                }
            } else {
                Collection<ServerConnection> serverConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections();
                if (serverConnections.size() == 1) {
                    serverConnection = serverConnections.iterator().next();
                }
            }
            if (serverConnection != null && serverConnection.isConnected() && (projectFile = (dialog = new FileChooserDialog(fileExtensions = new String[]{"*." + FramePlugin.getFileExtensionForProjectData()}, activeShell)).openForLoad()) != null) {
                IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage((IWorkbenchWindow)activeWorkbenchWindow);
                CreateProjectFromFileHelper.createProjectFromFile(currentPage, serverConnection, projectFile);
            }
        }
        return null;
    }
}

