/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.stakeholder;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.dialogs.AbstractDialogWithCategorySelection;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameStakeholderRoleValidator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRoleAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddRoleDialog
extends AbstractDialogWithCategorySelection {
    private final RenameStakeholderRoleValidator inputValidator;
    private final Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return AddRoleDialog.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };
    private Text descriptionText;
    private Text nameText;
    private String newName;
    private String newDescription;
    private Combo categoryCombo;

    public AddRoleDialog(Shell parentShell, IFrameProjectAgent projectAgent) {
        super(parentShell, true, projectAgent);
        this.inputValidator = new RenameStakeholderRoleValidator(projectAgent);
    }

    @Override
    protected Control createDialogArea_internal(Composite parent) {
        this.getShell().setText(Messages.getString("AddRoleDialog.Create_new_Stakeholder_role_1"));
        this.setTitle(Messages.getString("AddRoleDialog.Create_new_Stakeholder_role_2"));
        this.setMessage(Messages.getString("AddRoleDialog.Please_enter_the_values_3"));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(2, false));
        IAttributeTypesProvider attributeTypeProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.stakeholderrole");
        Label label = new Label(base, 256);
        GridDataFactory.fillDefaults().align(4, 2).grab(false, false).applyTo((Control)label);
        label.setText(String.valueOf(ObjectTypeCategoryLabels.LABEL_CATEGORY) + ":");
        this.categoryCombo = new Combo(base, 12);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this.categoryCombo);
        LineSeparator line = new LineSeparator(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)line);
        Label space = new Label(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)space);
        IAttributeType attrName = attributeTypeProv.getAttributeType(StakeholderRoleAttributeTypesProvider.ATTRID_NAME);
        Label l = new Label(base, 0);
        l.setText(attrName.getDisplayName());
        this.nameText = new Text(base, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRoleDialog.this.setErrorMessage(AddRoleDialog.this.inputValidator.isValid(AddRoleDialog.this.nameText.getText()));
            }
        });
        IAttributeType attrDescription = attributeTypeProv.getAttributeType(StakeholderRoleAttributeTypesProvider.ATTRID_DESCRIPTION);
        l = new Label(base, 0);
        l.setText(attrDescription.getDisplayName());
        this.descriptionText = new Text(base, 2560);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setEditable(this.mayEdit(attrDescription));
        return base;
    }

    protected void dialogConstructed() {
        this.setModificationProblems(this.modificationProblems);
    }

    private boolean mayEdit(IAttributeType attributeType) {
        if (!this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, this.operandTree, true)) {
            this.modificationProblems.add(new ModificationProblem(attributeType, this.operandTree, this.projectAgent));
            this.setModificationProblems(this.modificationProblems);
            return false;
        }
        return true;
    }

    protected void okPressed() {
        this.newName = this.nameText.getText().trim();
        if (this.descriptionText.getEditable()) {
            this.newDescription = this.descriptionText.getText();
            if (this.newDescription != null) {
                this.newDescription = this.newDescription.trim();
            }
        }
        super.okPressed();
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public void setErrorMessage(String msg) {
        this.getButton(0).setEnabled(msg == null);
        super.setErrorMessage(msg);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.setErrorMessage(this.inputValidator.isValid(null));
    }

    protected void dispose() {
    }

    @Override
    protected Combo getCategoryCombo() {
        return this.categoryCombo;
    }

    @Override
    protected String getFrameDataTypeID() {
        return "com.arcway.cockpit.stakeholderrole";
    }
}

