/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import de.plans.fmca.client.FMCAServerPreferencePage;
import de.plans.psc.shared.message.EOServer;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ServerPropertiesDialog
extends TitleAreaDialog
implements IPreferencePageContainer {
    public static final int OPEN_FOR_ADD = 1;
    public static final int OPEN_FOR_MODIFY = 2;
    private EOServer server;
    private FMCAServerPreferencePage page;
    private int mode = 0;

    public ServerPropertiesDialog(Shell parentShell) {
        super(parentShell);
        this.mode = 1;
        this.setTitleImage(FramePlugin.getImageDescriptor("newserver_wiz_big.gif").createImage());
    }

    public ServerPropertiesDialog(EOServer server, Shell parentShell, int mode) {
        super(parentShell);
        this.server = server;
        this.mode = mode;
        this.setTitleImage(FramePlugin.getImageDescriptor("newserver_wiz_big.gif").createImage());
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(1, false));
        base.setLayoutData((Object)new GridData(1808));
        this.page = new FMCAServerPreferencePage();
        this.page.setContainer((IPreferencePageContainer)this);
        switch (this.mode) {
            case 1: {
                this.page.initForAdd(base);
                this.setTitle(Messages.getString("ServerPropertiesDialog.Add_server_1"));
                this.getShell().setText(Messages.getString("ServerPropertiesDialog.Add_Server_1"));
                break;
            }
            case 2: {
                this.page.initForModify(base, this.server);
                this.setTitle(Messages.getString("ServerPropertiesDialog.Change_Server_Properties_2"));
                this.getShell().setText(Messages.getString("ServerPropertiesDialog.Change_Server_2"));
                break;
            }
            default: {
                assert (false) : "invalid mode";
                break;
            }
        }
        return base;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.updateButtons();
        return c;
    }

    protected void okPressed() {
        if (this.page.performOk()) {
            super.okPressed();
        }
    }

    public void updateButtons() {
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(this.page.isValid());
        }
    }

    public void updateMessage() {
        if (this.page.getErrorMessage() != null) {
            this.setMessage(this.page.getErrorMessage(), 3);
        } else {
            this.setMessage(this.page.getMessage(), this.page.getMessageType());
        }
    }

    public void updateTitle() {
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }
}

