/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.copypaste;

import com.arcway.cockpit.frame.client.global.gui.copypaste.DTRepositorySnippetClipboardContent;
import com.arcway.cockpit.frame.client.global.gui.copypaste.RepositorySnippetClipboardContent;
import com.arcway.cockpit.frame.client.global.gui.copypaste.RepositorySnippetClipboardContentTransferAgent;
import com.arcway.cockpit.frame.client.global.gui.copypaste.RepositorySnippetRootExplicitObjectTypeIDsTransferAgent;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.canonicalstring.CanonicalStringCoDecForData;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.EXXMLEncodingFailed;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.importexport.imporT.InterpretationMessageCollector;
import com.arcway.repository.interFace.manager.EXCannotSerializeRepositoryInterfaces;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class ClipboardManager {
    private static final ILogger LOGGER = Logger.getLogger(ClipboardManager.class);

    public static final void setToClipboard(IRepositoryInterfaceRO repositoryInterface, IRepositorySnippetRO repositorySnippet) {
        String textData;
        IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
        IRepositoryPropertySetSample sourceWorkspaceID = RepositorySamples.getWorkspaceID((IRepositoryObjectSample)repositoryInterface.getWorkspace().getWorkspaceInformation(), (IRepositoryTypeManagerRO)typeManager);
        RepositorySnippetClipboardContent clipboardContent = new RepositorySnippetClipboardContent(sourceWorkspaceID, repositoryInterface, repositorySnippet);
        HashSet_ rootObjectTypeIDs = new HashSet_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        for (RepositoryObjectSampleWithParentObjectReference explicitObject : repositorySnippet.getExplicitObjects()) {
            if (explicitObject.getParentObjectReference() != null) continue;
            rootObjectTypeIDs.add((Object)explicitObject.getObjectSample().getObjectTypeID());
        }
        try {
            textData = CanonicalStringCoDecForData.encodeIntoCanonicalString((IDataType)DTRepositorySnippetClipboardContent.getInstance(typeManager), (Object)clipboardContent);
            if (LOGGER.isDebugEnabled(29)) {
                try {
                    LOGGER.debug(29, "Copy to clipboard, String representation:\n" + textData);
                    String textData2 = XMLCoDecForData.encodeIntoString((Object)clipboardContent, (IDataType)DTRepositorySnippetClipboardContent.getInstance(typeManager), (String)"repositorysnippetclipboardcontent", null, (String)"UTF-8", (XMLFormatMode)XMLFormatMode.WITH_INDENTION);
                    LOGGER.debug(29, "Copy to clipboard, XML representation:\n" + textData2);
                }
                catch (EXXMLEncodingFailed e) {
                    textData = null;
                    LOGGER.error("Logging clipboard content failed", (Throwable)e);
                }
            }
        }
        catch (EXCannotSerializeRepositoryInterfaces e) {
            textData = null;
            LOGGER.error("Copy to clipboard failed", (Throwable)e);
        }
        if (textData != null) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                try {
                    RepositorySnippetRootExplicitObjectTypeIDsTransferAgent rootObjectTypeIDsTransfer = new RepositorySnippetRootExplicitObjectTypeIDsTransferAgent();
                    RepositorySnippetClipboardContentTransferAgent clipboardContentTransfer = new RepositorySnippetClipboardContentTransferAgent(typeManager);
                    Transfer[] transfers = new Transfer[]{rootObjectTypeIDsTransfer, clipboardContentTransfer};
                    Object[] data = new Object[]{rootObjectTypeIDs, clipboardContent};
                    clipboard.setContents(data, transfers);
                }
                catch (EXCannotSerializeRepositoryInterfaces e) {
                    LOGGER.error("Copy to clipboard failed", (Throwable)e);
                    clipboard.dispose();
                }
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    public static ISet_<IRepositoryObjectTypeID> retrieveExplicitRootObjectTypeIDsContentInClipboard() {
        HashSet_ rootObjectTypeIDs = null;
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            RepositorySnippetRootExplicitObjectTypeIDsTransferAgent rootObjectTypeIDsTransfer = new RepositorySnippetRootExplicitObjectTypeIDsTransferAgent();
            ICollection_ collection = (ICollection_)clipboard.getContents((Transfer)rootObjectTypeIDsTransfer);
            if (collection != null) {
                rootObjectTypeIDs = new HashSet_(collection, IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
            }
        }
        finally {
            clipboard.dispose();
        }
        return rootObjectTypeIDs;
    }

    public static final Tuple<RepositorySnippetClipboardContent, IMessageSet> retrieveFromClipboard(final IRepositoryTypeManagerRO typeManager) {
        final RepositorySnippetClipboardContent[] clipboardContent = new RepositorySnippetClipboardContent[1];
        IMessageSet interpretationMessages = InterpretationMessageCollector.doWhileCollectingInterpretationMessages((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RepositorySnippetClipboardContentTransferAgent clipboardContentTransfer = new RepositorySnippetClipboardContentTransferAgent(typeManager);
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    try {
                        clipboardContent[0] = (RepositorySnippetClipboardContent)clipboard.getContents((Transfer)clipboardContentTransfer);
                    }
                    finally {
                        clipboard.dispose();
                    }
                }
                catch (EXCannotSerializeRepositoryInterfaces e) {
                    LOGGER.error("Paste failed", (Throwable)e);
                }
            }
        });
        Tuple clipboardContentAndInterpretationMessages = clipboardContent[0] == null ? null : new Tuple((Object)clipboardContent[0], (Object)interpretationMessages);
        return clipboardContentAndInterpretationMessages;
    }
}

