/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.ServerPropertiesDialog;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.shared.message.EOServer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ChangeServerPropertiesAction
extends Action {
    private final ISelectionProvider selectionProvider;
    private final int mode;

    public ChangeServerPropertiesAction(ISelectionProvider selectionProvider, int mode) {
        this.selectionProvider = selectionProvider;
        this.mode = mode;
        ImageDescriptor descriptor = null;
        this.setEnabled(ProjectMgr.getProjectMgr().getGeneralServerProxy().mayAdministrateServers());
        switch (mode) {
            case 1: {
                this.setText(Messages.getString("ChangeServerPropertiesAction.Server_1"));
                descriptor = FramePlugin.getImageDescriptor("new_server.gif");
                break;
            }
            case 2: {
                this.setText(Messages.getString("ChangeServerPropertiesAction.Change_Server_Properties_3"));
                descriptor = FramePlugin.getImageDescriptor("server_connected.gif");
                break;
            }
            default: {
                assert (false) : "invalid mode";
                break;
            }
        }
        this.setImageDescriptor(descriptor);
    }

    public void update() {
        block6: {
            block5: {
                if (!ProjectMgr.getProjectMgr().getGeneralServerProxy().mayAdministrateServers()) break block5;
                switch (this.mode) {
                    case 2: {
                        this.setEnabled(this.getSelectedServer() != null);
                        break block6;
                    }
                    case 1: {
                        this.setEnabled(true);
                        break block6;
                    }
                    default: {
                        assert (false) : "invalid mode";
                        break block6;
                    }
                }
            }
            this.setEnabled(false);
        }
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ServerPropertiesDialog dialog = null;
        switch (this.mode) {
            case 1: {
                dialog = new ServerPropertiesDialog(shell);
                break;
            }
            case 2: {
                EOServer server = this.getSelectedServer();
                if (server == null) break;
                dialog = new ServerPropertiesDialog(this.getSelectedServer(), shell, this.mode);
                break;
            }
            default: {
                assert (false) : "invalid mode";
                break;
            }
        }
        if (dialog != null) {
            dialog.open();
        }
    }

    private EOServer getSelectedServer() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        if (selection.size() != 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof ServerConnection) {
            ServerConnection serverConnection = (ServerConnection)o;
            return serverConnection.getServerData();
        }
        return null;
    }
}

