/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.gui.FrameUIManager;
import com.arcway.cockpit.frame.client.global.gui.IFrameUIManager;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModuleFactory;
import com.arcway.cockpit.frame.client.project.modules.IModuleUserInterface;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UserInterfaceManager
implements IWindowListener {
    private static UserInterfaceManager instance;
    private final SetMap<IWorkbenchWindow, IModuleUserInterface> moduleUserInterfaces = new SetMap();
    private final Map<IWorkbenchWindow, IFrameUIManager> frameUIManagers = new HashMap<IWorkbenchWindow, IFrameUIManager>();

    public static UserInterfaceManager getDefault() {
        if (instance == null) {
            instance = new UserInterfaceManager();
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)instance);
        }
        return instance;
    }

    public Collection<IModuleUserInterface> getModuleUserInterfaces(IWorkbenchWindow window) {
        if (this.moduleUserInterfaces.get((Object)window).isEmpty()) {
            this.createModuleUserInterfaces(window);
        }
        return new HashSet<IModuleUserInterface>(this.moduleUserInterfaces.get((Object)window));
    }

    private UserInterfaceManager() {
    }

    private void createModuleUserInterfaces(IWorkbenchWindow window) {
        List<IFMCAModuleFactory> moduleFactories = ExtensionMgr.getModuleFactories();
        for (IFMCAModuleFactory factory : moduleFactories) {
            this.moduleUserInterfaces.add((Object)window, (Object)factory.getNewModuleUserInterface(window));
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.moduleUserInterfaces.remove((Object)window);
        this.frameUIManagers.remove(window);
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (!this.frameUIManagers.containsKey(window)) {
            this.frameUIManagers.put(window, new FrameUIManager(window));
        }
    }

    public IFrameUIManager getFrameUIManager(IWorkbenchWindow window) {
        return this.frameUIManagers.get(window);
    }
}

