/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.data;

import com.arcway.cockpit.errorreporting.data.CockpitLogFetcher;
import com.arcway.cockpit.errorreporting.data.IDataFetcher;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class EclipseLogFetcher
implements IDataFetcher {
    private static final ILogger LOGGER = Logger.getLogger(CockpitLogFetcher.class);

    @Override
    public void fetchData(File sessionTempSubDir) {
        IPath logFileLocation = Platform.getLogFileLocation();
        File destinationParentLogDir = new File(sessionTempSubDir, "Logfiles");
        File destinationEclipseLogDir = new File(destinationParentLogDir, "PlatformLog");
        File platformLogfile = logFileLocation.toFile();
        File logFileDir = platformLogfile.getParentFile();
        if (!destinationParentLogDir.exists()) {
            destinationParentLogDir.mkdir();
        }
        destinationEclipseLogDir.mkdir();
        File[] fileArray = logFileDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(platformLogfile.getName())) {
                try {
                    File targetFile = new File(destinationEclipseLogDir, file.getName());
                    DataCopyHelper.copyFile((File)file, (File)targetFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    LOGGER.error("Unable to copy Platform-logfile(s) to temporary directory.", (Throwable)e);
                    throw new Error(e);
                }
            }
            ++n2;
        }
    }
}

