/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.data;

public class CockpitVariantDetector {
    public static final String VARIANT_ENTERPRISE_CLIENT = "ENTERPRISE_CLIENT";
    public static final String VARIANT_PROFESSIONAL = "PROFESSIONAL";
    public static final String VARIANT_DESIGNER = "DESIGNER";
    public static final String VARIANT_UNKNOWN = "UNKNOWN";

    public static String detectCockpitVariant() {
        String variant = VARIANT_UNKNOWN;
        try {
            String eclipseProduct = System.getProperty("eclipse.product");
            if (eclipseProduct.indexOf(".framestandaloneserverproxywithcommit.") > 0) {
                variant = VARIANT_PROFESSIONAL;
            } else if (eclipseProduct.indexOf(".frameserverproxy.") > 0) {
                variant = VARIANT_ENTERPRISE_CLIENT;
            } else if (eclipseProduct.indexOf(".designer.") > 0) {
                variant = VARIANT_DESIGNER;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return variant;
    }

    public static String convertDetectedCockpitVariant2ShortString(String cockpitVariant) {
        if (cockpitVariant != VARIANT_UNKNOWN) {
            if (cockpitVariant == VARIANT_ENTERPRISE_CLIENT) {
                return "CS";
            }
            if (cockpitVariant == VARIANT_PROFESSIONAL) {
                return "SA";
            }
            if (cockpitVariant == VARIANT_DESIGNER) {
                return "D";
            }
            assert (false);
            return "U";
        }
        return "U";
    }
}

