/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import de.plans.lib.util.valueranges.IString;
import de.plans.lib.util.valueranges.ValueString;

public class PathPrefixMapping {
    private final IString subPathToReplace;
    private final IString replacePath;
    private boolean projectSpanning;
    private boolean isActive;

    public PathPrefixMapping() {
        this.subPathToReplace = new ValueString("");
        this.replacePath = new ValueString("");
        this.projectSpanning = false;
        this.isActive = true;
    }

    public PathPrefixMapping(String subPathToReplace, String replacePath, boolean spanning, boolean active) {
        this.subPathToReplace = new ValueString(subPathToReplace);
        this.replacePath = new ValueString(replacePath);
        this.projectSpanning = spanning;
        this.isActive = active;
    }

    public IString getReplacePath() {
        return this.replacePath;
    }

    public IString getSubPathToReplace() {
        return this.subPathToReplace;
    }

    public boolean getProjectSpannning() {
        return this.projectSpanning;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean equals(Object mapping) {
        assert (this.subPathToReplace != null);
        assert (this.replacePath != null);
        boolean equals = false;
        try {
            if (((PathPrefixMapping)mapping).subPathToReplace.getValue().length() > 0 && this.subPathToReplace.getValue().length() > 0) {
                if (this.subPathToReplace.getValue().length() > 2 && this.subPathToReplace.getValue().substring(1, 3).equals(":\\")) {
                    String myMappingHead = ((PathPrefixMapping)mapping).subPathToReplace.getValue().substring(0, 1);
                    String myMappingTail = ((PathPrefixMapping)mapping).subPathToReplace.getValue().substring(1);
                    String thisHead = this.subPathToReplace.getValue().substring(0, 1);
                    String thisTail = this.subPathToReplace.getValue().substring(1);
                    if (myMappingHead.equalsIgnoreCase(thisHead) && myMappingTail.equals(thisTail) && this.projectSpanning == ((PathPrefixMapping)mapping).getProjectSpannning()) {
                        equals = true;
                    }
                } else if (this.subPathToReplace.getValue().equals(((PathPrefixMapping)mapping).subPathToReplace.getValue()) && this.projectSpanning == ((PathPrefixMapping)mapping).getProjectSpannning()) {
                    equals = true;
                }
            }
        }
        catch (ClassCastException e) {
            equals = false;
        }
        return equals;
    }

    public int hashCode() {
        assert (false) : "Hashing not supported / implemented most inefficently.";
        return 0;
    }

    public String getDisplayRepresentation() {
        return String.valueOf(this.subPathToReplace.getValue()) + " --> " + this.replacePath.getValue();
    }

    public void setReplacePath(String replacePath) {
        assert (replacePath != null);
        this.replacePath.setValue(replacePath);
    }

    public void setSubPathToReplace(String subPathToReplace) {
        assert (subPathToReplace != null);
        this.subPathToReplace.setValue(subPathToReplace);
    }

    public void setProjectSpanning(boolean spanning) {
        this.projectSpanning = spanning;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

