/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RefreshDataViewRunnable;
import com.arcway.cockpit.documentmodule.client.messages.RefreshFileLinkThread;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.description.RLFileSystemLinkDescription;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.gui.elements.UIETextField;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EditFileSystemLinkAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener {
    private RLFileSystemLink fileSystemLink = null;
    private DocumentContainer parentContainer;
    private IModelController model = null;
    private UIETextField url;
    private Button fileChooserButton;
    private LockAccess lock;

    public EditFileSystemLinkAdapter() {
        super(false);
    }

    public EditFileSystemLinkAdapter(DocumentContainer parent) {
        super(true);
        this.parentContainer = parent;
    }

    public String getDataTypeID() {
        return "dcm.filesystemlink";
    }

    public Class getDataClass() {
        return RLFileSystemLink.class;
    }

    public String getPropertyName() {
        return RLFileSystemLink.MODULE_DATA_NAME;
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return DocumentModulePlugin.getImageDescriptor("filesystemlink.gif");
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return DocumentModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public Composite createEditPage_internal(Composite parent) {
        this.setMessageText();
        Composite editArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        editArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        editArea.setLayoutData((Object)gridData);
        this.createCategoryWidget(editArea, 5, (IModuleData)this.fileSystemLink);
        Label labelURL = new Label(editArea, 0);
        labelURL.setText(String.valueOf(ResourceLocator.URL_NAME) + ":");
        Control widget = this.url.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 150;
        widget.setLayoutData((Object)gridData);
        this.url.setEditable(false);
        this.fileChooserButton = new Button(editArea, 0);
        this.fileChooserButton.setText(Messages.getString("EditFileSystemLinkDialog.ChooseFile"));
        this.fileChooserButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileChooserDialog fileDialog;
                File chosenFile;
                File currentValueParent;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String currentValue = EditFileSystemLinkAdapter.this.url.getCurrentValue();
                File startPath = null;
                if (currentValue != null && (currentValueParent = new File(currentValue).getParentFile()) != null && currentValueParent.isDirectory()) {
                    startPath = currentValueParent;
                }
                if ((chosenFile = (fileDialog = new FileChooserDialog(new String[0], startPath, shell)).openForLoad()) != null) {
                    EditFileSystemLinkAdapter.this.url.forceText(chosenFile.getAbsolutePath());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setWidgetState();
        this.setValues();
        this.url.addModifyListener((ModifyListener)this);
        this.handleModifications(null, false);
        return editArea;
    }

    private void setMessageText() {
        if (this.isCreationDialogue()) {
            String msg = Messages.getString("EditFileSystemLinkDialog.CreateFileSystemLinkDetails");
            this.getCallback().setMessage(msg, 0);
        }
    }

    private void setWidgetState() {
        AbstractPermissionMgr permissionMgr = this.model.getPermissionMgr();
        boolean mayEdit = true;
        if (!this.isCreationDialogue()) {
            mayEdit &= permissionMgr.mayEditItemStructurally((IModuleData)this.fileSystemLink, (IModuleData)this.parentContainer);
        }
        if (mayEdit && !this.isCreationDialogue() && !this.lock.hasLock()) {
            mayEdit = false;
        }
        if (mayEdit) {
            this.fileChooserButton.setEnabled(true);
        } else {
            this.fileChooserButton.setEnabled(false);
        }
        if (mayEdit) {
            this.setCategoryEditable(true);
        } else {
            this.setCategoryEditable(false);
        }
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            this.fileSystemLink = (RLFileSystemLink)items[0];
            this.model = DocumentModulePlugin.getDefault().getProjectManager().getModelController(this.fileSystemLink.getProjectUID());
            if (!this.isCreationDialogue()) {
                this.parentContainer = (DocumentContainer)this.model.getParent((IModuleData)this.fileSystemLink);
            }
            this.internalConstruct(this.model);
            if (!this.isCreationDialogue()) {
                ModuleLockManager lockMgr = (ModuleLockManager)this.model.getLockMgr();
                this.lock = lockMgr.acquireEditLock((ICockpitProjectData)this.fileSystemLink);
                if (!this.lock.hasLock()) {
                    this.lock.releaseLocks();
                } else {
                    this.fileSystemLink = (RLFileSystemLink)this.model.getItem("dcm.filesystemlink", this.fileSystemLink.getUID());
                    if (this.fileSystemLink == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    private void internalConstruct(IModelController modelCtrl) {
        this.url = new UIETextField(Messages.getString("ResourceLocator.URL_NAME"), this.fileSystemLink.getPreMappedURL().getValueRangeHelper());
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return RLFileSystemLinkDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    private void setValues() {
        this.url.setValue();
    }

    private void getValues() {
        if (this.isCreationDialogue()) {
            this.fileSystemLink.getURL().setValueViaDisplayStringRepresentation(this.url.getCurrentValue());
        } else {
            this.url.getValue();
            String eclipseInstallPath = System.getProperty("osgi.install.area").substring(6);
            File file = new File(eclipseInstallPath);
            try {
                eclipseInstallPath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String newServerURL = this.fileSystemLink.getPreMappedURL().getValue();
            if (newServerURL.startsWith(eclipseInstallPath)) {
                newServerURL = "com.arcway.cockpit.documentmodule.PREDEFINED_MAPPING".concat(this.fileSystemLink.getPreMappedURL().getValue().substring(eclipseInstallPath.length()));
            }
            this.fileSystemLink.getURL().setValueViaDisplayStringRepresentation(newServerURL);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(e, true);
    }

    private void handleModifications(ModifyEvent e, boolean notAtInitialisation) {
        String checkResult = null;
        checkResult = this.url.checkCurrentValue();
        if (notAtInitialisation) {
            this.getCallback().setErrMsg(checkResult);
            this.getCallback().setChangedStatus(true);
        } else {
            if (checkResult != null) {
                this.getCallback().setCommitable(false);
            }
            this.getCallback().setChangedStatus(false);
        }
    }

    public RLFileSystemLink getFileSystemLink() {
        return this.fileSystemLink;
    }

    public void cancelChanges1() {
        if (this.lock != null) {
            this.lock.releaseLocks();
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.emptyList();
    }

    public void rollbackCommitRequest() {
    }

    protected void doCommitChanges() {
        this.getValues();
        if (this.isCreationDialogue()) {
            this.model.addItem((IModuleData)this.fileSystemLink);
            this.model.createLink(this.parentContainer.getUID(), (IModuleData)this.fileSystemLink, "FilelinkDocumentContainer");
        } else {
            this.model.itemPropertiesModified((IModuleData)this.fileSystemLink, null);
        }
        this.fileSystemLink.calculateLocalURLs(0, (IProjectAgent)this.model.getProjectAgent());
        new RefreshFileLinkThread(this.fileSystemLink, new RefreshDataViewRunnable(Display.getCurrent(), this.fileSystemLink, DocumentModulePlugin.getDefault().getProjectManager().getProjectAgent(this.model.getProjectUID()).getPropertyChangesProviderManager())).start();
        this.model.getPropertyChangesManager().signalPropertyChanges(null, (Object)this.fileSystemLink, null, RLFileSystemLink.class);
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return DocumentModulePlugin.getDefault();
    }

    public ImageDescriptor getDialogImageDescriptor() {
        return DocumentModulePlugin.getImageDescriptor("container_big.gif");
    }
}

