/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractDiscreteValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractStringListFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DiscreteValueListFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.StringListFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.TextListFilterItem;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.documentmodule.shared.ModuleIdentification;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters.FilterHelper;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ObjectTypeCategoryFilter;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ObjectTypeCategoryTableListFilterItem;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.filters.AbstractStringValueFilter;
import com.arcway.cockpit.modulelib2.client.gui.filters.ModuleDataTableListFilterItem;
import com.arcway.cockpit.modulelib2.client.gui.filters.StringValueFilterItem;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import de.plans.lib.util.valueranges.IString;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.ValueRangeHelperString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class DocumentFilters
implements IModuleProjectSwitchListener {
    private IModelController model;
    private final IModuleProjectSwitchListenerManager projectSwitchListenerManager;
    private ModuleDataTableListFilterItem categoryFilterItem;
    private static final IModuleDataTypeDescription[] dataTypesWithCategoryFilter = new IModuleDataTypeDescription[]{DocumentContainer.DATA_TYPE_DESCRIPTION, RLFileSystemLink.DATA_TYPE_DESCRIPTION, RLWebLink.DATA_TYPE_DESCRIPTION};

    public DocumentFilters(IModuleProjectSwitchListenerManager projectSwitchListenerManager) {
        assert (projectSwitchListenerManager != null) : "view facade must not be null";
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
        this.projectSwitchListenerManager = projectSwitchListenerManager;
    }

    public List<IFilterItem> createFilters() {
        StringValueFilterItem containerNameFilterItem = new StringValueFilterItem(FilterHelper.getFilterName((String)DocumentContainer.MODULE_DATA_NAME, (String)DocumentContainer.NAME_NAME), new AbstractStringValueFilter(){

            protected IString getStringAttribute(Object element) {
                if (element instanceof DocumentContainer) {
                    return ((DocumentContainer)element).getName();
                }
                return null;
            }

            protected IValueRangeHelperText getValueRangeHelper() {
                return new ValueRangeHelperString(this.filterString);
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "ContainerNameFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof DocumentContainer;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("documentcontainer_name");
            }
        });
        StringValueFilterItem fileNameFilterItem = new StringValueFilterItem(FilterHelper.getFilterName((String)ResourceLocator.MODULE_DATA_NAME, (String)Messages.getString("DataViewProvider.FilterURL")), new AbstractStringValueFilter(){

            protected IString getStringAttribute(Object element) {
                if (element instanceof ResourceLocator) {
                    return ((ResourceLocator)((Object)element)).getURL();
                }
                return null;
            }

            protected IValueRangeHelperText getValueRangeHelper() {
                return new ValueRangeHelperString(this.filterString);
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "URLFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof ResourceLocator;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("resourcelocator_url");
            }
        });
        this.categoryFilterItem = new ModuleDataTableListFilterItem(FilterHelper.getFilterName((String)Category.MODULE_DATA_NAME, null), "dcm.category", this.projectSwitchListenerManager, (IModelControllerProvider)DocumentModulePlugin.getDefault().getProjectManager(), new AbstractTextValuesFilter(true){

            protected String getStringAttribute(Object element) {
                Category category = null;
                if (element instanceof Category) {
                    category = (Category)((Object)element);
                } else if (element instanceof DocumentContainer) {
                    category = (Category)DocumentFilters.this.model.getParent((IModuleData)((DocumentContainer)element));
                } else if (element instanceof ResourceLocator) {
                    category = (Category)DocumentFilters.this.model.getParent(DocumentFilters.this.model.getParent((IModuleData)((ResourceLocator)((Object)element))));
                }
                if (category != null) {
                    return category.getDisplayRepresentation();
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "categoryFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof Category || element instanceof DocumentContainer || element instanceof ResourceLocator;
            }
        }, false);
        this.categoryFilterItem.setComparator((Comparator)new Comparator<Category>(){

            @Override
            public int compare(Category c1, Category c2) {
                return c1.getDisplayRepresentation().compareTo(c2.getDisplayRepresentation());
            }
        });
        this.projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this.categoryFilterItem);
        DiscreteValueListFilterItem stateFilterItem = new DiscreteValueListFilterItem(FilterHelper.getFilterName((String)DocumentContainer.MODULE_DATA_NAME, (String)Messages.getString("DataViewProvider.FilterState")), Arrays.asList(DocumentContainer.getStateKeys()), new AbstractDiscreteValueFilter(){

            protected int getDiscreteIndex(Object element) {
                if (element instanceof DocumentContainer) {
                    return ((DocumentContainer)element).getState().getValue();
                }
                return -1;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "StatesFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof DocumentContainer;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("documentcontainer_state");
            }
        });
        final String[] typeFilterValues = new String[]{Messages.getString("DataViewProvider.FilterFile"), Messages.getString("DataViewProvider.FilterWeblink")};
        TextListFilterItem typeFilterItem = new TextListFilterItem(FilterHelper.getFilterName((String)ResourceLocator.MODULE_DATA_NAME, (String)Messages.getString("DataViewProvider.FilterType")), new AbstractTextValuesFilter(false){

            protected String getStringAttribute(Object element) {
                if (element instanceof RLFileSystemLink) {
                    return typeFilterValues[0];
                }
                if (element instanceof RLWebLink) {
                    return typeFilterValues[1];
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "TypeFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof ResourceLocator;
            }
        });
        typeFilterItem.setFilterValues(Arrays.asList(typeFilterValues));
        DiscreteValueListFilterItem linkStateFilterItem = new DiscreteValueListFilterItem(FilterHelper.getFilterName((String)ResourceLocator.MODULE_DATA_NAME, (String)Messages.getString("DataViewProvider.FilterFileState")), Arrays.asList(RLFileSystemLink.getLinkStateKeys()), new AbstractDiscreteValueFilter(){

            protected int getDiscreteIndex(Object element) {
                if (element instanceof RLFileSystemLink) {
                    return ((RLFileSystemLink)((Object)element)).getLinkState().getValue();
                }
                return -1;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "linkStatesFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof RLFileSystemLink;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals(RLFileSystemLink.LINK_STATE_NAME);
            }
        });
        StringListFilterItem keywordsFilterItem = new StringListFilterItem(FilterHelper.getFilterName((String)DocumentContainer.MODULE_DATA_NAME, (String)Messages.getString("DataViewProvider.KeywFilterName")), new AbstractStringListFilter(){

            protected String getStringAttribute(Object element) {
                if (element instanceof DocumentContainer) {
                    return ((DocumentContainer)element).getKeywords().getValue();
                }
                return null;
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof DocumentContainer;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "keywordsFilter";
            }
        });
        ArrayList<IFilterItem> filterItems = new ArrayList<IFilterItem>();
        IModuleDataTypeDescription[] iModuleDataTypeDescriptionArray = dataTypesWithCategoryFilter;
        int n = dataTypesWithCategoryFilter.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleDataTypeDescription singleDataType = iModuleDataTypeDescriptionArray[n2];
            if (singleDataType.isSupportingCategories()) {
                String typeName = singleDataType.getModuleDataTypeDescriptionForFrame().getDisplayName();
                String objectsCockpitTypeID = singleDataType.getTypeID();
                String filterName = String.valueOf(typeName) + ": " + ObjectTypeCategoryLabels.LABEL_CATEGORY;
                ObjectTypeCategoryFilter filter = new ObjectTypeCategoryFilter(objectsCockpitTypeID);
                ObjectTypeCategoryTableListFilterItem filterItem = new ObjectTypeCategoryTableListFilterItem(filterName, objectsCockpitTypeID, this.projectSwitchListenerManager, (AbstractTextValuesFilter)filter);
                filterItems.add((IFilterItem)filterItem);
            }
            ++n2;
        }
        filterItems.add((IFilterItem)this.categoryFilterItem);
        filterItems.add((IFilterItem)containerNameFilterItem);
        filterItems.add((IFilterItem)stateFilterItem);
        filterItems.add((IFilterItem)keywordsFilterItem);
        filterItems.add((IFilterItem)fileNameFilterItem);
        filterItems.add((IFilterItem)typeFilterItem);
        filterItems.add((IFilterItem)linkStateFilterItem);
        return filterItems;
    }

    public void dispose() {
        if (this.projectSwitchListenerManager != null) {
            this.projectSwitchListenerManager.deregisterProjectSwitchListener((IModuleProjectSwitchListener)this);
            if (this.categoryFilterItem != null) {
                this.projectSwitchListenerManager.deregisterProjectSwitchListener((IModuleProjectSwitchListener)this.categoryFilterItem);
            }
        }
        this.model = null;
    }

    public void projectSwitched(String projectUID) {
        this.model = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
    }
}

