/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOObjectInfo;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class EOMediaObject
extends EOCommonObject {
    public static String XML_NAME = "mediaobject";
    private EOObjectInfo objectInfo = null;
    private final List mediaObjects = new ArrayList();

    public EOMediaObject() {
        super(XML_NAME);
    }

    public EOMediaObject(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected boolean hasChildren() {
        return this.objectInfo != null || this.mediaObjects.size() > 0;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.objectInfo != null) {
            this.objectInfo.writeXMLBody(writeContext, depth);
        }
        if (this.mediaObjects.size() > 0) {
            for (Object mediaObj : this.mediaObjects) {
                if (!(mediaObj instanceof EOImageObject)) continue;
                EOImageObject imgObj = (EOImageObject)((Object)mediaObj);
                imgObj.writeXMLBody(writeContext, depth);
            }
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean result = true;
        if (newChild instanceof EOObjectInfo) {
            this.objectInfo = (EOObjectInfo)newChild;
        } else if (newChild instanceof EOImageObject) {
            this.mediaObjects.add(newChild);
        }
        return result;
    }

    public void setObjectInfo(EOObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
    }

    public EOObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    public void add(EOImageObject imageObject) {
        assert (imageObject != null) : "EOImageObject is null";
        this.mediaObjects.add(imageObject);
    }

    public List getContent() {
        return new ArrayList(this.mediaObjects);
    }
}

