/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.FileInReportDescription;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.Record;
import com.arcway.cockpit.docgen.provider.interfaces.IFileHelper;
import com.arcway.cockpit.docgen.provider.interfaces.IImageInfo;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.DTRecord;
import com.arcway.lib.codec.Base64;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.EXXMLEncodingFailed;
import com.arcway.lib.codec.xml.IXMLRootElementFactoryWO;
import com.arcway.lib.codec.xml.IXMLRootElementRO;
import com.arcway.lib.codec.xml.XMLCoDec;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.graphics.SWTDefaultRendererManager;
import com.arcway.lib.eclipse.graphics.SWTRenderer;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class ReportFileHelper
implements IReportRelatedReportProvider,
IFileHelper {
    private static final ILogger LOGGER = Logger.getLogger(ReportFileHelper.class);
    private IReportRelatedReportContext reportContext;
    private DTRecord dataTypeRecord;

    @Override
    public void setup(IReportRelatedReportContext reportContext) {
        this.reportContext = reportContext;
        this.dataTypeRecord = new DTRecord(reportContext.getGraphicsProvider(), reportContext.getPresentationContext().getLocale());
    }

    @Override
    public String convertStringToPortableFileName(String string) {
        return FileHelper.convertStringToPortableFileName((String)string);
    }

    @Override
    public List<String> readFileIntoStringList(String fileName, String characterEncoding) {
        byte[] fileContent = ReportFileHelper.readFileContent(fileName);
        return AbstractAttributeOwnerDocGenProxy.convertFileContentIntoRawStringList(characterEncoding, fileContent);
    }

    @Override
    public String writeStringListIntoPreProcessingFile(List<String> stringList, String prefix, String extension, String characterEncoding, boolean addCR, boolean addLF) throws IOException {
        File tempFile = ReportFileHelper.writeTextIntoPreProcessingFile(stringList, prefix, extension, characterEncoding, addCR, addLF);
        tempFile.deleteOnExit();
        return tempFile.getAbsolutePath();
    }

    @Override
    public String writeBase64IntoPreProcessingFile(List<String> base64FileContent, String prefix, String extension) {
        String fileContentBase64Encoded = ReportFileHelper.concatenate(base64FileContent, false, false);
        File tempFile = ReportFileHelper.writeBase64IntoPreProcessingFile(fileContentBase64Encoded, prefix, extension);
        tempFile.deleteOnExit();
        return tempFile.getAbsolutePath();
    }

    @Override
    public String writeBase64IntoPostProcessingFile(List<String> base64FileContent, String originalFileName) throws IOException {
        return this.writeBase64IntoPostProcessingFile(base64FileContent, originalFileName, 0.0, 0.0);
    }

    @Override
    public String writeBase64IntoPostProcessingFile(List<String> base64FileContent, String originalFileName, double width_mm, double height_mm) throws IOException {
        String fileContentBase64Encoded = ReportFileHelper.concatenate(base64FileContent, false, false);
        return this.writeBase64IntoPostProcessingFile(originalFileName, fileContentBase64Encoded, width_mm, height_mm);
    }

    private String writeBase64IntoPostProcessingFile(String originalFileName, String fileContentBase64Encoded, double width_mm, double height_mm) {
        byte[] fileContent = ReportFileHelper.decodeBase64File(fileContentBase64Encoded);
        String snippet = ReportFileHelper.writeFileIntoPostProcessingFile(this.reportContext.getGraphicsProvider(), originalFileName, fileContent, width_mm, height_mm);
        return snippet;
    }

    @Override
    public String createPostProcessingFile(String fileName) {
        String prefix = de.plans.lib.util.FileHelper.getFileNameWithoutExtension((String)de.plans.lib.util.FileHelper.getFileName((String)fileName));
        String extension = "." + de.plans.lib.util.FileHelper.getFileType((String)fileName);
        File fileInStore = this.reportContext.getGraphicsProvider().createTempFileObject(prefix, extension);
        return fileInStore.getAbsolutePath();
    }

    public static String writeFileIntoPostProcessingFile(IGraphicsAndFilesHelper graphicsAndFilesHelper, String originalFileName, byte[] fileContent, double width_mm, double height_mm) {
        String snippet;
        try {
            String prefix = ReportFileHelper.convertFileNameToPrefix(originalFileName);
            File tempFile = SessionTempDirectoryManager.createSessionTempFile((String)prefix, (String)de.plans.lib.util.FileHelper.getFileType((String)originalFileName));
            try {
                try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
                    fileOutputStream.write(fileContent);
                }
                File fileInStore = graphicsAndFilesHelper.createTempFileObject(tempFile, prefix);
                String fileName = fileInStore.getName();
                FileInReportDescription fileInReportDescription = new FileInReportDescription(fileName, originalFileName);
                snippet = graphicsAndFilesHelper.getSnippetForFileInRawReportFormat(fileInReportDescription, width_mm, height_mm);
            }
            finally {
                tempFile.delete();
            }
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return snippet;
    }

    @Override
    public List<String> readFileIntoBase64StringList(String fileName, boolean breakLines) {
        byte[] fileContent = ReportFileHelper.readFileContent(fileName);
        try {
            return AbstractAttributeOwnerDocGenProxy.getBase64StringList(breakLines, fileContent);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] readFileContent(String fileName) {
        FileInputStream inputStream;
        File file = new File(fileName);
        int length = (int)file.length();
        byte[] fileContent = new byte[length];
        try {
            inputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            try {
                inputStream.read(fileContent);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return fileContent;
    }

    private static File writeTextIntoPreProcessingFile(List<String> fileContentAsStringList, String prefix, String extension, String characterEncoding, boolean addCR, boolean addLF) {
        File tempFile;
        String fileContentAsString = ReportFileHelper.concatenate(fileContentAsStringList, addCR, addLF);
        try {
            byte[] fileContent = fileContentAsString.getBytes(characterEncoding);
            tempFile = ReportFileHelper.writeFileIntoPreProcessingFile(fileContent, prefix, extension);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return tempFile;
    }

    private static File writeBase64IntoPreProcessingFile(String fileContentBase64Encoded, String prefix, String extension) {
        byte[] fileContent = ReportFileHelper.decodeBase64File(fileContentBase64Encoded);
        File tempFile = ReportFileHelper.writeFileIntoPreProcessingFile(fileContent, prefix, extension);
        return tempFile;
    }

    @Override
    public IImageInfo readImageInfo(String imagefileName) {
        File file = new File(imagefileName);
        return ReportFileHelper.readImageInfo(file);
    }

    public static IImageInfo readImageInfo(File file) {
        Image image;
        FileResource fileResource = new FileResource(file);
        IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
        try {
            image = renderer.loadImage((IStreamResource)fileResource);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        final int wInPixels = image.getWidthInPixels();
        final int hInPixels = image.getHeightInPixels();
        final Dimension dimensionInMM = image.getDimensionInMM();
        IImageInfo imageInfo = new IImageInfo(){

            @Override
            public int getWinPixels() {
                return wInPixels;
            }

            @Override
            public double getWinMM() {
                return dimensionInMM.width;
            }

            @Override
            public int getHinPixels() {
                return hInPixels;
            }

            @Override
            public double getHinMM() {
                return dimensionInMM.height;
            }
        };
        return imageInfo;
    }

    @Override
    public String writeDecoratedImage(String fileNameOfImageToDecorate, double toGray, String fileNameOfDecoratorImage) {
        return this.writeDecoratedImage(fileNameOfImageToDecorate, toGray, fileNameOfDecoratorImage, 0.0, 0.0);
    }

    @Override
    public String writeDecoratedImage(String fileNameOfImageToDecorate, double toGray, String fileNameOfDecoratorImage, double width_mm, double height_mm) {
        return this.writeDecoratedImageAligned(fileNameOfImageToDecorate, toGray, 2, 2, fileNameOfDecoratorImage, 0, 0, 0, 0, width_mm, height_mm);
    }

    @Override
    public String writeDecoratedImageAligned(String fileNameOfImageToDecorate, double toGray, int baseAlignX, int baseAlignY, String fileNameOfDecoratorImage, int alignX, int alignY, int offX, int offY) {
        return this.writeDecoratedImageAligned(fileNameOfImageToDecorate, toGray, baseAlignX, baseAlignY, fileNameOfDecoratorImage, alignX, alignY, offX, offY, 0.0, 0.0);
    }

    @Override
    public String writeDecoratedImageAligned(String fileNameOfImageToDecorate, double toGray, int baseAlignX, int baseAlignY, String fileNameOfDecoratorImage, int alignX, int alignY, int offX, int offY, double width_mm, double height_mm) {
        byte[] byteArray = ReportFileHelper.getDecoratedImageAligned(fileNameOfImageToDecorate, toGray, baseAlignX, baseAlignY, fileNameOfDecoratorImage, alignX, alignY, offX, offY);
        String originalFileName = String.valueOf(ReportFileHelper.convertFileNameToPrefix(fileNameOfImageToDecorate)) + '_' + ReportFileHelper.convertFileNameToPrefix(fileNameOfDecoratorImage) + '.' + ImageCoDec.determineFileType((String)fileNameOfImageToDecorate).getFileExtension();
        return ReportFileHelper.writeFileIntoPostProcessingFile(this.reportContext.getGraphicsProvider(), originalFileName, byteArray, width_mm, height_mm);
    }

    private static byte[] getDecoratedImageAligned(final String fileNameOfImageToDecorate, final double toGray, final int baseAlignX, final int baseAlignY, final String fileNameOfDecoratorImage, final int alignX, final int alignY, final int offX, final int offY) {
        final byte[][] byteArray = new byte[1][];
        final Throwable[] t = new Throwable[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    File fileOfImageToDecorate = new File(fileNameOfImageToDecorate);
                    File fileOfDecoratorImage = new File(fileNameOfDecoratorImage);
                    SWTRenderer swtRenderer = SWTDefaultRendererManager.getDefaultSWTRendererOfCurrentThread();
                    FileResource imageResoruce = new FileResource(fileOfImageToDecorate);
                    Image baseImage = swtRenderer.loadImage((IStreamResource)imageResoruce);
                    if (Geo.isGreaterThanZero((double)toGray)) {
                        Image grayImage = swtRenderer.createGrayImage(baseImage, toGray);
                        baseImage.dispose();
                        baseImage = grayImage;
                    }
                    FileResource imageResoruce2 = new FileResource(fileOfDecoratorImage);
                    Image decoratorImage = swtRenderer.loadImage((IStreamResource)imageResoruce2);
                    Alignment positionOnBase = ReportFileHelper.getAlignment(baseAlignX, baseAlignY);
                    Alignment layoutDirection = ReportFileHelper.getAlignment(alignX, alignY);
                    Image decoratedImage = swtRenderer.createDecoratedImage(baseImage, decoratorImage, positionOnBase, layoutDirection, offX, offY);
                    byteArray[0] = ImageCoDec.encodeIntoByteArray((Image)decoratedImage, (ImageFileType)ImageCoDec.determineFileType((boolean)baseImage.isLossyImage()));
                }
                catch (Exception e) {
                    t[0] = e;
                }
            }
        });
        if (t[0] != null) {
            if (t[0] instanceof RuntimeException) {
                throw (RuntimeException)t[0];
            }
            throw new RuntimeException(t[0]);
        }
        return byteArray[0];
    }

    private static Alignment getAlignment(int h, int v) {
        int ah = h == 0 ? 1 : (h == 1 ? 2 : (h == 2 ? 4 : 2));
        int av = v == 0 ? 8 : (v == 1 ? 16 : (v == 2 ? 32 : 16));
        return new Alignment(ah, av);
    }

    public static File writeFileIntoPreProcessingFile(byte[] fileContent, String prefix, String extension) {
        File tempFile;
        try {
            tempFile = SessionTempDirectoryManager.createSessionTempFile((String)prefix, (String)extension);
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
                fileOutputStream.write(fileContent);
            }
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tempFile;
    }

    public static byte[] decodeBase64File(String fileContentBase64Encoded) {
        byte[] fileContent;
        try {
            fileContent = Base64.decode((String)fileContentBase64Encoded);
        }
        catch (EXDecoderException e) {
            throw new RuntimeException(e);
        }
        return fileContent;
    }

    public static String concatenate(List<String> fileContentAsStringList, boolean addCR, boolean addLF) {
        StringBuffer fileContentAsStringBuffer = new StringBuffer();
        for (String line : fileContentAsStringList) {
            fileContentAsStringBuffer.append(line);
            if (addCR) {
                fileContentAsStringBuffer.append('\r');
            }
            if (!addLF) continue;
            fileContentAsStringBuffer.append('\n');
        }
        String fileContentAsString = fileContentAsStringBuffer.toString();
        return fileContentAsString;
    }

    @Override
    public String writeDecoratedImageAlignedIntoPreProcessingFile(String fileNameOfImageToDecorate, double toGray, int baseAlignX, int baseAlignY, String fileNameOfDecoratorImage, int alignX, int alignY, int offX, int offY) {
        byte[] fileContent = ReportFileHelper.getDecoratedImageAligned(fileNameOfImageToDecorate, toGray, baseAlignX, baseAlignY, fileNameOfDecoratorImage, alignX, alignY, offX, offY);
        String prefix = String.valueOf(ReportFileHelper.convertFileNameToPrefix(fileNameOfImageToDecorate)) + "_" + ReportFileHelper.convertFileNameToPrefix(fileNameOfDecoratorImage);
        File tempFile = ReportFileHelper.writeFileIntoPreProcessingFile(fileContent, prefix, "." + ImageCoDec.determineFileType((String)fileNameOfImageToDecorate).getFileExtension());
        tempFile.deleteOnExit();
        return tempFile.getAbsolutePath();
    }

    private static String convertFileNameToPrefix(String fileName) {
        String prefix = FileHelper.shortenFileName((String)de.plans.lib.util.FileHelper.getFileNameWithoutExtension((String)de.plans.lib.util.FileHelper.getFileName((String)fileName)), (int)32);
        return prefix;
    }

    @Override
    public String encodeRecordIntoPreprocessingXMLFile(IRecord record, String rootName, String namespace, String encoding, boolean formatOutput) throws EXXMLEncodingFailed {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLCoDecForData.encodeIntoOutputStream((OutputStream)byteArrayOutputStream, (Object)record, (IDataType)this.dataTypeRecord, (String)rootName, (String)namespace, (String)encoding, (XMLFormatMode)(formatOutput ? XMLFormatMode.WITH_INDENTION : XMLFormatMode.WITHOUT_INDENTION));
        byte[] fileContent = byteArrayOutputStream.toByteArray();
        File tempFile = ReportFileHelper.writeFileIntoPreProcessingFile(fileContent, "record", ".xml");
        tempFile.deleteOnExit();
        return tempFile.getAbsolutePath();
    }

    @Override
    public String encodeRecordIntoXMLString(IRecord record, String rootName, String namespace, String encoding, boolean formatOutput) throws EXXMLEncodingFailed {
        return XMLCoDecForData.encodeIntoString((Object)record, (IDataType)this.dataTypeRecord, (String)rootName, (String)namespace, (String)encoding, (XMLFormatMode)(formatOutput ? XMLFormatMode.WITH_INDENTION : XMLFormatMode.WITHOUT_INDENTION));
    }

    @Override
    public IRecord decodeRecordFromXMLFile(String fileNameOfFileToBeRead) throws EXXMLDecodingFailed, IOException {
        IRecord record;
        File file = new File(fileNameOfFileToBeRead);
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = XMLCoDecForData.decodeIntoObject((InputStream)bufferedInputStream, (IDataType)this.dataTypeRecord);
            record = (IRecord)object;
        }
        return record;
    }

    @Override
    public IRecord decodeRecordFromXMLString(String xmlString, String encoding) throws UnsupportedEncodingException, EXXMLDecodingFailed {
        byte[] bytes = xmlString.getBytes(encoding);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        Object object = XMLCoDecForData.decodeIntoObject((InputStream)byteArrayInputStream, (IDataType)this.dataTypeRecord);
        IRecord record = (IRecord)object;
        return record;
    }

    @Override
    public String addExtensionIfMissing(String fileName, String extension) {
        File file = FileHelper.addExtensionIfMissing((File)new File(fileName), (String)extension);
        return file.getAbsolutePath();
    }

    @Override
    public boolean moveFile(String sourceFileName, String destinationFileName) {
        try {
            FileHelper.moveFile((File)new File(sourceFileName), (File)new File(destinationFileName));
            return true;
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean deleteFileOrDirectory(String fileOrDirectoryName) {
        try {
            FileHelper.deleteFileOrDirectory((File)new File(fileOrDirectoryName));
            return true;
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean deleteExistingFileOrDirectory(String fileOrDirectoryName) {
        try {
            FileHelper.deleteFileOrDirectory((File)new File(fileOrDirectoryName));
            return true;
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean deleteContentOfDirectory(String directoryName) {
        try {
            FileHelper.deleteContentOfDirectory((File)new File(directoryName));
            return true;
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean ensureDirectoryExistance(String directoryName) {
        try {
            FileHelper.ensureDirectoryExistance((File)new File(directoryName));
            return true;
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean copyFile(String sourceName, String destinationName) {
        try {
            DataCopyHelper.copyFile((File)new File(sourceName), (File)new File(destinationName));
            return true;
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean copyDirectoryContent(String srcDirectoryName, String trgtDirectoryName) {
        try {
            FileHelper.copyDirectoryContent((File)new File(srcDirectoryName), (File)new File(trgtDirectoryName));
            return true;
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    @Override
    public String getFileExtension(String fileName) {
        return FileHelper.getFileExtension((String)fileName);
    }

    @Override
    public boolean doesDirectoryContainEssentialFiles(String directoryName, boolean ignoreDirectoryEntries, boolean ignoreAuxiliaryFiles) {
        return FileHelper.doesDirectoryContainEssentialFiles((File)new File(directoryName), (boolean)ignoreDirectoryEntries, (boolean)ignoreAuxiliaryFiles);
    }

    @Override
    public String shortenFileName(String fileName, int maxLength) {
        return FileHelper.shortenFileName((String)fileName, (int)maxLength);
    }

    @Override
    public IRecord loadXMLFileIntoRecord(String fileNameOfFileToBeRead) throws IOException, EXXMLDecodingFailed {
        Record record = new Record(this.reportContext.getGraphicsProvider(), this.reportContext.getPresentationContext().getLocale());
        File file = new File(fileNameOfFileToBeRead);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        try {
            XMLCoDec.decode((InputStream)bufferedInputStream, (IXMLRootElementFactoryWO)record, (boolean)true);
        }
        finally {
            fileInputStream.close();
        }
        return record;
    }

    @Override
    public IRecord loadXMLFileIntoRecord(String xmlString, String encoding) throws UnsupportedEncodingException, EXXMLDecodingFailed {
        Record record = new Record(this.reportContext.getGraphicsProvider(), this.reportContext.getPresentationContext().getLocale());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlString.getBytes(encoding));
        XMLCoDec.decode((InputStream)byteArrayInputStream, (IXMLRootElementFactoryWO)record, (boolean)true);
        return record;
    }

    public String saveXMLFileFromRecordIntoPreprocessingXMLFile(IRecord record, String fileNamePrefix, String encoding, boolean formatOutput) throws EXXMLEncodingFailed {
        return this.saveXMLFileFromRecordIntoPreprocessingXMLFile(record, fileNamePrefix, encoding, formatOutput ? 1 : 0);
    }

    @Override
    public String saveXMLFileFromRecordIntoPreprocessingXMLFile(IRecord record, String fileNamePrefix, String encoding, int formatOutput) throws EXXMLEncodingFailed {
        Record typedRecord = (Record)record;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLCoDec.encodeIntoOutputStream((OutputStream)byteArrayOutputStream, (String)encoding, (IXMLRootElementRO)typedRecord, (XMLFormatMode)ReportFileHelper.decodeXMLFormatMode(formatOutput));
        byte[] fileContent = byteArrayOutputStream.toByteArray();
        File tempFile = ReportFileHelper.writeFileIntoPreProcessingFile(fileContent, fileNamePrefix, ".xml");
        tempFile.deleteOnExit();
        return tempFile.getAbsolutePath();
    }

    private static XMLFormatMode decodeXMLFormatMode(int formatOutput) {
        return formatOutput == 0 ? XMLFormatMode.WITHOUT_INDENTION : (formatOutput == 2 ? XMLFormatMode.WITHOUT_INDENTION_DONT_ESCAPE_CRLFTAB_WITHIN_CONTENT : XMLFormatMode.WITH_INDENTION);
    }

    public String saveXMLFileFromRecordIntoXMLString(IRecord record, String encoding, boolean formatOutput) throws EXXMLEncodingFailed {
        return this.saveXMLFileFromRecordIntoXMLString(record, encoding, formatOutput ? 1 : 0);
    }

    @Override
    public String saveXMLFileFromRecordIntoXMLString(IRecord record, String encoding, int formatOutput) throws EXXMLEncodingFailed {
        Record typedRecord = (Record)record;
        return XMLCoDec.encodeIntoString((String)encoding, (IXMLRootElementRO)typedRecord, (XMLFormatMode)ReportFileHelper.decodeXMLFormatMode(formatOutput));
    }

    @Override
    public Collection<String> listDirectoryContent(String directory) {
        File dir = new File(directory);
        File[] children = dir.listFiles();
        ArrayList<String> childNames = new ArrayList<String>(children.length);
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            childNames.add(child.getAbsolutePath());
            ++n2;
        }
        return childNames;
    }

    @Override
    public String getFileNameWithoutPath(String fileName) {
        File file = new File(fileName);
        return file.getName();
    }

    @Override
    public String getParent(String fileName) {
        File file = new File(fileName);
        File parentFile = file.getParentFile();
        return parentFile != null ? parentFile.getAbsolutePath() : null;
    }

    @Override
    public String getChild(String parentFileName, String childName) {
        File file = new File(parentFileName, childName);
        return file.getAbsolutePath();
    }

    @Override
    public boolean isDirectory(String fileName) {
        File file = new File(fileName);
        return file.isDirectory();
    }

    @Override
    public boolean isFile(String fileName) {
        File file = new File(fileName);
        return file.isFile();
    }

    @Override
    public boolean isHidden(String fileName) {
        File file = new File(fileName);
        return file.isHidden();
    }

    @Override
    public long lastModified(String fileName) {
        File file = new File(fileName);
        return file.lastModified();
    }

    @Override
    public long length(String fileName) {
        File file = new File(fileName);
        return file.length();
    }

    @Override
    public boolean setLastModified(String fileName, long time) {
        File file = new File(fileName);
        return file.setLastModified(time);
    }

    @Override
    public boolean setReadOnly(String fileName) {
        File file = new File(fileName);
        return file.setReadOnly();
    }
}

