/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.AbstractCustomPropertiesAccessDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.PlanDocGenProxy;
import com.arcway.cockpit.docgen.provider.SectionDocGenProxy;
import com.arcway.cockpit.docgen.provider.StakeholderDocGenProxy;
import com.arcway.cockpit.docgen.provider.StakeholderRoleDocGenProxy;
import com.arcway.cockpit.docgen.provider.UniqueElementDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IFolder;
import com.arcway.cockpit.docgen.provider.interfaces.IHistoryEntry;
import com.arcway.cockpit.docgen.provider.interfaces.IModelElement;
import com.arcway.cockpit.docgen.provider.interfaces.IPlan;
import com.arcway.cockpit.docgen.provider.interfaces.IProject;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.interfaces.IStakeholder;
import com.arcway.cockpit.docgen.provider.interfaces.IStakeholderRole;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.docgen.provider.utils.PlanComparator;
import com.arcway.cockpit.docgen.provider.utils.StakeholderComparator;
import com.arcway.cockpit.docgen.provider.utils.StakeholderRoleComparator;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class ProjectDocGenProxy
extends AbstractCustomPropertiesAccessDocGenProxy
implements IProject {
    private final IDocGeneratorProjectAgent projectAgent;
    private final ICockpitProject project;
    private final Collection<AbstractFilter> filters;
    private final Locale projectLocale;
    private final PresentationContext presentationContext;
    private final IWorkbenchPage currentPage;

    public ProjectDocGenProxy(ICockpitProject project, IDocGeneratorProjectAgent projectAgent, Collection<AbstractFilter> filters, IGraphicsAndFilesHelper fileAttributeProvider, Locale projectLocale, PresentationContext presentationContext_, IWorkbenchPage currentPage) {
        super((IAttributeOwner)project, fileAttributeProvider, (IFrameProjectAgent)projectAgent.getProjectAgent(), projectLocale);
        this.project = project;
        this.projectAgent = projectAgent;
        this.filters = filters;
        this.projectLocale = projectLocale;
        this.presentationContext = presentationContext_;
        this.currentPage = currentPage;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.project.getUID();
    }

    @Override
    public String getTypeID() {
        return "project";
    }

    @Override
    public String getTypeName() {
        return ((IFrameDataTypeDescription)FrameDataTypes.getDataType((String)"frame.project")).getDisplayName(this.projectLocale);
    }

    @Override
    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.project.getName());
    }

    @Override
    public String getName() {
        String result = HTMLEncoder.encode((String)this.project.getName());
        return result;
    }

    @Override
    public List<String> getDescription() {
        String description = this.project.getDescription();
        List descriptionList = StringUtil.splitTextLines((String)description);
        List<String> resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(descriptionList);
        return resultAsList;
    }

    @Override
    public String getLogo() {
        if (this.hasPropertyValue("logo")) {
            return this.getFileProperty("logo");
        }
        return Messages.getString("ProjectDocGenProxy.NoLogo", this.projectLocale);
    }

    @Override
    public String getLanguage() {
        return this.project.getLanguage();
    }

    public IFolder[] getAllFolders() {
        ArrayList folders = new ArrayList(this.projectAgent.getAllFolders(this.filters));
        IFolder[] result = new SectionDocGenProxy[folders.size()];
        int counter = 0;
        for (ISection folder : folders) {
            SectionDocGenProxy folderDescription = new SectionDocGenProxy(folder, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
            result[counter] = folderDescription;
            ++counter;
        }
        return result;
    }

    public List<IFolder> getRootFolders() {
        IFolder[] allFolders;
        ArrayList<IFolder> rootFolders = new ArrayList<IFolder>();
        IFolder[] iFolderArray = allFolders = this.getAllFolders();
        int n = allFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            if (folder.getParent() == null) {
                rootFolders.add(folder);
            }
            ++n2;
        }
        return rootFolders;
    }

    public List<IFolder> getRootFoldersSortedBy(String propertyID) {
        List<IFolder> result = this.getRootFolders();
        AbstractAttributeOwnerDocGenProxy.sortList(result, propertyID);
        return result;
    }

    @Override
    public IFolder findFolder(String sectionPath) {
        String decodedSectionPath = HTMLEncoder.decode((String)sectionPath);
        String[] pathElements = decodedSectionPath.trim().split("/");
        if (pathElements.length == 0) {
            return null;
        }
        boolean folderFoundOnLevel = true;
        int pathElementIndex = 0;
        List<IFolder> foldersOnLevel = this.getRootFolders();
        IFolder foundFolder = null;
        while (folderFoundOnLevel && pathElementIndex < pathElements.length) {
            folderFoundOnLevel = false;
            for (IFolder folder : foldersOnLevel) {
                if (!folder.getName().equals(pathElements[pathElementIndex])) continue;
                foundFolder = folder;
                folderFoundOnLevel = true;
                break;
            }
            if (!folderFoundOnLevel) continue;
            ++pathElementIndex;
            foldersOnLevel = foundFolder.getSubFolders();
        }
        if (folderFoundOnLevel) {
            return foundFolder;
        }
        return null;
    }

    public List<IFolder> getRootFoldersWithCategory(String categoryID) {
        List<IFolder> rootFolders = this.getRootFolders();
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(rootFolders, categoryID);
    }

    public List<IFolder> getRootFoldersWithDefaultCategory() {
        return this.getRootFoldersWithCategory(null);
    }

    public List<IFolder> getRootFoldersWithCategorySortedBy(String categoyID, String propertyID) {
        List<IFolder> result = this.getRootFoldersWithCategory(categoyID);
        AbstractAttributeOwnerDocGenProxy.sortList(result, propertyID);
        return result;
    }

    public List<IFolder> getRootFoldersWithDefaultCategorySortedBy(String propertyID) {
        List<IFolder> result = this.getRootFoldersWithDefaultCategory();
        AbstractAttributeOwnerDocGenProxy.sortList(result, propertyID);
        return result;
    }

    @Deprecated
    public SectionDocGenProxy getRootSection() {
        return new SectionDocGenProxy(this.projectAgent.getRootSection(), this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
    }

    @Override
    public List<? extends IPlan> getRootPlans() {
        ArrayList<IPlan> rootPlans = new ArrayList<IPlan>();
        List<? extends IPlan> allPlans = this.getAllPlans();
        for (IPlan iPlan : allPlans) {
            if (iPlan.getFolder() != null) continue;
            rootPlans.add(iPlan);
        }
        return rootPlans;
    }

    @Override
    public List<? extends IPlan> getAllPlans() {
        ArrayList plans = new ArrayList(this.projectAgent.getAllPlans(this.filters));
        Collections.sort(plans, new PlanComparator());
        ArrayList<PlanDocGenProxy> result = new ArrayList<PlanDocGenProxy>(plans.size());
        for (com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan plan : plans) {
            PlanDocGenProxy planDescription = new PlanDocGenProxy(plan, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
            result.add(planDescription);
        }
        return result;
    }

    @Override
    public List<? extends IPlan> getAllPlansInDefinedOrder() {
        ArrayList<IPlan> result = new ArrayList<IPlan>();
        result.addAll(this.getRootPlans());
        ProjectDocGenProxy.addPlansOfFolders(result, this.getRootFolders());
        return result;
    }

    private static void addPlansOfFolders(List<IPlan> result, List<? extends IFolder> folders) {
        for (IFolder iFolder : folders) {
            result.addAll(iFolder.getPlans());
            ProjectDocGenProxy.addPlansOfFolders(result, iFolder.getSubFolders());
        }
    }

    public List<? extends IPlan> getRootPlansWithCategory(String categoryID) {
        List<? extends IPlan> rootPlans = this.getRootPlans();
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(rootPlans, categoryID);
    }

    public List<? extends IPlan> getAllPlansWithCategory(String categoryID) {
        List<? extends IPlan> result = this.getAllPlans();
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(result, categoryID);
    }

    public List<? extends IPlan> getRootPlansWithDefaultCategory() {
        return this.getRootPlansWithCategory(null);
    }

    public List<? extends IPlan> getAllPlansWithDefaultCategory() {
        return this.getAllPlansWithCategory(null);
    }

    @Deprecated
    public IModelElement[] getAllUniqueElements() {
        return this.getAllModelElements().toArray(new IModelElement[0]);
    }

    @Deprecated
    public IModelElement[] getAllUniqueElements(String typeID) {
        return this.getAllModelElements(typeID).toArray(new IModelElement[0]);
    }

    public List<IModelElement> getAllModelElements() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getAllUniqueElements(this.filters));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
    }

    public List<IModelElement> getAllModelElements(String typeID) {
        assert (typeID != null) : "typeID must not be null";
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getAllUniqueElements(this.filters));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, typeID, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
    }

    public List<IModelElement> getAllModelElementsWithCategory(String categoryID) {
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllModelElements(), categoryID);
    }

    public List<IModelElement> getAllModelElementsWithCategory(String categoryID, String typeID) {
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllModelElements(typeID), categoryID);
    }

    public List<IModelElement> getAllModelElementsWithDefaultCategory() {
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllModelElements(), null);
    }

    public List<IModelElement> getAllModelElementsWithDefaultCategory(String typeID) {
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllModelElements(typeID), null);
    }

    public Collection<IModelElement> filterModelElementsOfType(Collection<IModelElement> modelElements, String typeID) {
        ArrayList<IModelElement> filteredUniqueElements = new ArrayList<IModelElement>(modelElements.size());
        for (IModelElement uniqueElementProxy : modelElements) {
            if (!((UniqueElementDocGenProxy)uniqueElementProxy).getElementTypeID().equals(typeID)) continue;
            filteredUniqueElements.add(uniqueElementProxy);
        }
        return filteredUniqueElements;
    }

    public List<IModelElement> getRootModelElementsOfCausalityRelationship() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getFirstUniqueElements_byACu());
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
    }

    public List<IModelElement> getLeafModelElementsOfCausalityRelationship() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getLastUniqueElements());
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
    }

    public List<IModelElement> getRootModelElementsOfContainmentRelationship() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getFirstUniqueElements_byACu());
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
    }

    public List<IModelElement> getLeafModelElementsOfContainmentRelationship() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getLastUniqueElements());
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.projectLocale, this.currentPage);
    }

    @Override
    public List<? extends IStakeholder> getAllStakeholders() {
        ArrayList stakeholders = new ArrayList(this.projectAgent.getStakeholders());
        Collections.sort(stakeholders, new StakeholderComparator());
        ArrayList<StakeholderDocGenProxy> result = new ArrayList<StakeholderDocGenProxy>(stakeholders.size());
        for (com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder stakeholder : stakeholders) {
            StakeholderDocGenProxy stakeholderProxy = new StakeholderDocGenProxy(stakeholder, this.projectAgent, this.getGraphicsAndFilesHelper(), this.filters, this.projectLocale);
            result.add(stakeholderProxy);
        }
        return result;
    }

    @Override
    public List<? extends IStakeholder> getAllStakeholdersWithCategory(String categoryID) {
        List<? extends IStakeholder> stakeholders = this.getAllStakeholders();
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(stakeholders, categoryID);
    }

    @Override
    public List<? extends IStakeholder> getAllStakeholdersWithDefaultCategory() {
        return this.getAllStakeholdersWithCategory(null);
    }

    @Override
    public StakeholderDocGenProxy getStakeholderForCurrentUser() {
        com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder stakeholder = this.projectAgent.getStakeholderForCurrentUser();
        StakeholderDocGenProxy stakeholderProxy = null;
        if (stakeholder != null) {
            stakeholderProxy = new StakeholderDocGenProxy(stakeholder, this.projectAgent, this.getGraphicsAndFilesHelper(), this.filters, this.projectLocale);
        }
        return stakeholderProxy;
    }

    @Override
    public List<? extends IStakeholderRole> getAllStakeholderRoles() {
        ArrayList stakeholderRoles = new ArrayList(this.projectAgent.getRoles());
        Collections.sort(stakeholderRoles, new StakeholderRoleComparator());
        ArrayList<StakeholderRoleDocGenProxy> result = new ArrayList<StakeholderRoleDocGenProxy>(stakeholderRoles.size());
        for (com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole stakeholderRole : stakeholderRoles) {
            StakeholderRoleDocGenProxy stakeholderRoleProxy = new StakeholderRoleDocGenProxy(stakeholderRole, this.projectAgent, this.getGraphicsAndFilesHelper(), this.filters, this.projectLocale);
            result.add(stakeholderRoleProxy);
        }
        return result;
    }

    @Override
    public List<? extends IStakeholderRole> getAllStakeholderRolesWithCategory(String categoryID) {
        List<? extends IStakeholderRole> result = this.getAllStakeholderRoles();
        return ProjectDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(result, categoryID);
    }

    @Override
    public List<? extends IStakeholderRole> getAllStakeholderRolesWithDefaultCategory() {
        return this.getAllStakeholderRolesWithCategory(null);
    }

    @Override
    public IStakeholderRole getStakeholderRole(String roleName) {
        ArrayList stakeholderRoles = new ArrayList(this.projectAgent.getRoles());
        for (com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole stakeholderRole : stakeholderRoles) {
            if (!stakeholderRole.getName().equals(roleName)) continue;
            StakeholderRoleDocGenProxy stakeholderRoleProxy = new StakeholderRoleDocGenProxy(stakeholderRole, this.projectAgent, this.getGraphicsAndFilesHelper(), this.filters, this.projectLocale);
            return stakeholderRoleProxy;
        }
        return null;
    }

    @Override
    public List<? extends IHistoryEntry> getProjectHistoryEntries() {
        List commitInformations = this.projectAgent.getProjectHistory();
        ArrayList<HistoryEntry> historyEntries = new ArrayList<HistoryEntry>(commitInformations.size());
        for (EOCommitCountAndCommitInformation commitInformation : commitInformations) {
            historyEntries.add(new HistoryEntry(commitInformation, this.projectLocale, this.presentationContext));
        }
        return historyEntries;
    }

    public List<IPlan> getAllPlansForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IPlan> plansForHistoryItem = new ArrayList<IPlan>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<? extends IPlan> plans = this.getAllPlans();
            for (IPlan iPlan : plans) {
                if (!commitVersion.equals(iPlan.getCommitVersion())) continue;
                plansForHistoryItem.add(iPlan);
            }
        }
        return plansForHistoryItem;
    }

    public List<IFolder> getAllFoldersForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IFolder> foldersForHistoryItem = new ArrayList<IFolder>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<IFolder> rootFolders = this.getRootFolders();
            for (IFolder rootFolder : rootFolders) {
                foldersForHistoryItem.addAll(this.retrieveFoldersWithVersion(rootFolder, commitVersion));
            }
        }
        return foldersForHistoryItem;
    }

    private List<IFolder> retrieveFoldersWithVersion(IFolder root, String version) {
        ArrayList<IFolder> foldersForVersion = new ArrayList<IFolder>();
        if (version.equals(root.getCommitVersion())) {
            foldersForVersion.add(root);
        }
        for (IFolder iFolder : root.getSubFolders()) {
            foldersForVersion.addAll(this.retrieveFoldersWithVersion(iFolder, version));
        }
        return foldersForVersion;
    }

    public List<IModelElement> getAllModelElementsForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IModelElement> modelElementsForHistoryItem = new ArrayList<IModelElement>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<IModelElement> modelElements = this.getAllModelElements();
            for (IModelElement modelElement : modelElements) {
                if (!commitVersion.equals(modelElement.getCommitVersion())) continue;
                modelElementsForHistoryItem.add(modelElement);
            }
        }
        return modelElementsForHistoryItem;
    }

    @Override
    public String getCommitVersion() {
        int commitCount = this.project.getCommitCount();
        return HistoryEntry.getVersionForCommitCount(commitCount);
    }

    public List<IStakeholder> getAllStakeholdersForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IStakeholder> stakeholdersForHistoryItem = new ArrayList<IStakeholder>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<? extends IStakeholder> stakeholders = this.getAllStakeholders();
            for (IStakeholder iStakeholder : stakeholders) {
                if (!commitVersion.equals(iStakeholder.getCommitVersion())) continue;
                stakeholdersForHistoryItem.add(iStakeholder);
            }
        }
        return stakeholdersForHistoryItem;
    }

    public List<IStakeholderRole> getAllStakeholderRolesForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IStakeholderRole> stakeholderRolesForHistoryItem = new ArrayList<IStakeholderRole>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<? extends IStakeholderRole> stakeholderRoles = this.getAllStakeholderRoles();
            for (IStakeholderRole iStakeholderRole : stakeholderRoles) {
                if (!commitVersion.equals(iStakeholderRole.getCommitVersion())) continue;
                stakeholderRolesForHistoryItem.add(iStakeholderRole);
            }
        }
        return stakeholderRolesForHistoryItem;
    }

    @Override
    public String getDateOfLastModification() {
        String lastModDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        return lastModDateHTML;
    }

    @Override
    public Long getDateOfLastModification_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("lastEditDate");
    }

    @Override
    public String getLastModifier() {
        String lastModifierHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        return lastModifierHTML;
    }

    @Override
    public String getCreationDate() {
        String creationDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        return creationDateHTML;
    }

    @Override
    public Long getCreationDate_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("creationDate");
    }

    @Override
    public String getCreator() {
        String creatorHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        return creatorHTML;
    }

    private String getHTMLEncodeSingleLineAttributeValue(IAttributeTypeID attrType) {
        IAttributeType attributeType;
        String htmlString = "-";
        IAttribute attribute = this.project.getAttribute(attrType);
        if (attribute != null && (attributeType = this.project.getAttributeType(attrType)) != null) {
            htmlString = HTMLEncoder.encode((String)attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), null, this.projectLocale));
        }
        return htmlString;
    }

    @Override
    public String getModificationCount() {
        return String.valueOf(this.project.getModificationCount());
    }

    @Override
    public String getLabelForUID(String uid) {
        String label = null;
        IFrameProjectAgent frameProjectAgent = (IFrameProjectAgent)this.projectAgent.getProjectAgent();
        List dataManagers = frameProjectAgent.getDataManagers();
        for (IFrameDataManager dm : dataManagers) {
            try {
                ICockpitProjectData cockpitProjectData = dm.getCockpitProjectData(uid);
                if (cockpitProjectData == null) continue;
                IDataLabelProvider dataLabelProvider = dm.getDataLabelProvider();
                label = dataLabelProvider.getText((Object)cockpitProjectData);
                break;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return label;
    }

    @Override
    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", this.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

