/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.IReportRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.interfaces.ICSVHelper;
import de.plans.lib.util.HTMLEncoder;
import java.util.Collection;
import java.util.Iterator;

public class CSVHelper
implements IReportRelatedReportProvider,
ICSVHelper {
    private static final String LINE_DELIMITER = "\n";

    @Override
    public void setup(IReportRelatedReportContext reportContext) {
    }

    @Override
    public String getCSVStringForAttribute(Object attribute) {
        if (attribute == null) {
            return "";
        }
        String resultAsString = this.getStringForAttribute(attribute);
        String result = this.getCSVStringForString(resultAsString);
        return result;
    }

    @Override
    public String getCSVStringForString(String string) {
        if (string == null) {
            return "";
        }
        return "\"" + string.replaceAll("\"", "\"\"") + "\"";
    }

    @Override
    public String getStringForAttribute(Object attribute) {
        if (attribute == null) {
            return "";
        }
        String result = null;
        if (attribute instanceof String) {
            result = HTMLEncoder.decode((String)((String)attribute));
        } else if (attribute instanceof String[]) {
            StringBuffer resultBuffer = new StringBuffer();
            String[] array = (String[])attribute;
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    resultBuffer.append(LINE_DELIMITER);
                }
                resultBuffer.append(HTMLEncoder.decode((String)array[i]));
                ++i;
            }
            result = resultBuffer.toString();
        } else if (attribute instanceof Collection) {
            StringBuffer resultBuffer = new StringBuffer();
            Collection coll = (Collection)attribute;
            boolean first = true;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    resultBuffer.append(LINE_DELIMITER);
                }
                String line = iter.next().toString();
                resultBuffer.append(HTMLEncoder.decode((String)line));
            }
            result = resultBuffer.toString();
        } else {
            result = "";
        }
        return result;
    }

    @Override
    public String getCSVLine(Object[] attributes, String separator) {
        if (attributes == null || separator == null) {
            return "";
        }
        StringBuffer line = new StringBuffer();
        int i = 0;
        while (i < attributes.length) {
            if (i > 0) {
                line.append(separator);
            }
            line.append(this.getCSVStringForAttribute(attributes[i]));
            ++i;
        }
        String result = line.toString();
        return result;
    }

    public String getCSVLine(Collection attributes, String separator) {
        if (attributes == null || separator == null) {
            return "";
        }
        StringBuffer line = new StringBuffer();
        boolean first = true;
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                line.append(separator);
            }
            line.append(this.getCSVStringForAttribute(iter.next()));
        }
        String result = line.toString();
        return result;
    }
}

