/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPhrase;
import com.arcway.cockpit.docgen.writer.word.docbook2word.AnchorWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.LinkWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.List;

public class PhraseWriter {
    private static ILogger logger = Logger.getLogger(PhraseWriter.class);
    private static PhraseWriter writer;

    public static PhraseWriter getInstance() {
        if (writer == null) {
            writer = new PhraseWriter();
        }
        return writer;
    }

    private PhraseWriter() {
    }

    public Range write(EOPhrase phrase, Range originalRange, Document document, ProcessingContext processingContext) {
        boolean newRangeCreatedForPhrase;
        Range phraseRange;
        if (originalRange.get_End() - originalRange.get_Start() > 0) {
            phraseRange = originalRange.Next();
            phraseRange.set_End(phraseRange.get_End() - 1);
            newRangeCreatedForPhrase = true;
        } else {
            phraseRange = originalRange;
            newRangeCreatedForPhrase = false;
        }
        List contentList = phrase.getContent(processingContext.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                phraseRange.InsertAfter((String)obj);
                if (!logger.isDebugEnabled(150)) continue;
                logger.debug(150, "[write paragraph] inserted text " + (String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, phraseRange, processingContext);
                continue;
            }
            if (!(obj instanceof EOLink)) continue;
            LinkWriter.getInstance().write((EOLink)obj, phraseRange, document, processingContext);
        }
        Range rangeAfterPhrase = phraseRange.Next();
        rangeAfterPhrase.set_End(rangeAfterPhrase.get_End() - 1);
        if (newRangeCreatedForPhrase) {
            phraseRange.dispose();
        }
        return rangeAfterPhrase;
    }
}

