/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.DocBookAnalyzer;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBook;
import com.arcway.cockpit.docgen.writer.docbook.model.EOChapter;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPreface;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.ChapterWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.PrefaceWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.TableWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.TitleWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.BodyNodeWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.ChapterWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.DocumentPropertiesWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.WordMLReader;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentWriter {
    private static DocumentWriter writer;

    public static DocumentWriter getInstance() {
        if (writer == null) {
            writer = new DocumentWriter();
        }
        return writer;
    }

    private DocumentWriter() {
    }

    public void write(EOBook docBook, WordMLReader wordMLFile, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ReportJob reportJob, IProgressMonitor progressMonitor) throws ReportGenerationCanceledException, ReportGenerationException {
        DocBookAnalyzer analyzer = new DocBookAnalyzer();
        DocBookPostProcessingProgress progress = new DocBookPostProcessingProgress(progressMonitor, analyzer.countChaptersAndSections(docBook));
        DocBook2WordMLGenerationContext context = new DocBook2WordMLGenerationContext(graphicsAndFilesStore, reportJob);
        BodyNodeWrapper body = new BodyNodeWrapper(wordMLFile, styleMap);
        body.removeAuxHintTags();
        body.extractRelevantSectionPropertiesAndNormaliseSectionPropertiesOfLastSection(context);
        Collection<Node> templateContent = body.getTemplateContent();
        this.determinePageSize(context);
        ArrayList docBookContentList = new ArrayList(docBook.getContent());
        progress.checkCancelState();
        this.writeCoverSheet(docBook, docBookContentList, body, styleMap, context);
        progress.checkCancelState();
        body.appendTemplateContent(templateContent);
        progress.checkCancelState();
        this.writeMainChapters(body, docBookContentList, styleMap, context, progress);
        progress.checkCancelState();
        body.adjustSectionPropertiesOfLastSection(context);
        progress.checkCancelState();
        this.writeDocumentProperties(docBook, wordMLFile, context);
        wordMLFile.getWordRootElement().normalize();
        wordMLFile.write();
    }

    private void determinePageSize(DocBook2WordMLGenerationContext context) {
        Node pageSize = null;
        Node pageMargins = null;
        NodeList sectPrChildren = context.getMainSectionProperties().getChildNodes();
        int i = 0;
        while (i < sectPrChildren.getLength()) {
            Node child = sectPrChildren.item(i);
            if (child.getNodeName().equals("w:pgSz")) {
                pageSize = child;
            } else if (child.getNodeName().equals("w:pgMar")) {
                pageMargins = child;
            }
            ++i;
        }
        if (pageSize != null) {
            NamedNodeMap pageSizeAttributes = pageSize.getAttributes();
            Node pageHeightInTwips = pageSizeAttributes.getNamedItem("w:h");
            int absolutePageHeightInTwips = Integer.parseInt(pageHeightInTwips.getNodeValue());
            Node pageWidthInTwips = pageSizeAttributes.getNamedItem("w:w");
            int absolutePageWidthInTwips = Integer.parseInt(pageWidthInTwips.getNodeValue());
            int relativePageHeight = 0;
            int relativePageWidth = 0;
            if (pageMargins != null) {
                NamedNodeMap pageMarginsAttributes = pageMargins.getAttributes();
                Node bottom = pageMarginsAttributes.getNamedItem("w:bottom");
                Node top = pageMarginsAttributes.getNamedItem("w:top");
                relativePageHeight = (absolutePageHeightInTwips - (Integer.parseInt(bottom.getNodeValue()) + Integer.parseInt(top.getNodeValue()))) / 20;
                Node left = pageMarginsAttributes.getNamedItem("w:left");
                Node right = pageMarginsAttributes.getNamedItem("w:right");
                relativePageWidth = (absolutePageWidthInTwips - (Integer.parseInt(left.getNodeValue()) + Integer.parseInt(right.getNodeValue()))) / 20;
            }
            context.setPageHeight(relativePageHeight);
            context.setPageWidth(relativePageWidth);
        }
    }

    private void writeCoverSheet(EOBook docBook, List<?> docBookContentList, BodyNodeWrapper body, StyleMap styleMap, DocBook2WordMLGenerationContext context) throws ReportGenerationException {
        EOSubtitle subtitle;
        ChapterWrapper chapterWrapper = body.addChapter();
        boolean hasAnyTitlePageContent = false;
        EOTitle title = docBook.getTitle();
        if (title != null) {
            String style = styleMap.findStyle("Title");
            TitleWriter.getInstance().write(title, chapterWrapper.addParagraph(style), context);
            hasAnyTitlePageContent = true;
        }
        if ((subtitle = docBook.getSubtitle()) != null) {
            String style = styleMap.findStyle("Subtitle");
            SubTitleWriter.getInstance().write(subtitle, chapterWrapper.addParagraph(style), context);
            hasAnyTitlePageContent = true;
        }
        Iterator<?> contentIter = docBookContentList.iterator();
        while (contentIter.hasNext()) {
            Object obj = contentIter.next();
            if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, chapterWrapper, context);
                hasAnyTitlePageContent = true;
            } else if (obj instanceof EOTable) {
                TableWriter.getInstance().write((EOTable)obj, chapterWrapper, context);
                hasAnyTitlePageContent = true;
            } else if (obj instanceof EOPreface) {
                PrefaceWriter.getInstance().write((EOPreface)obj, chapterWrapper, styleMap, context);
                hasAnyTitlePageContent = true;
            } else if (obj instanceof EOChapter) break;
            contentIter.remove();
        }
        int chapterIndex = context.getNextFreeChapterIndex();
        if (hasAnyTitlePageContent) {
            chapterWrapper.terminateChapter(chapterIndex, context);
        }
    }

    private void writeMainChapters(BodyNodeWrapper body, List<?> docBookContentList, StyleMap styleMap, DocBook2WordMLGenerationContext context, DocBookPostProcessingProgress progress) throws ReportGenerationCanceledException, ReportGenerationException {
        for (Object obj : docBookContentList) {
            if (obj instanceof EOChapter) {
                ChapterWriter.getInstance().write((EOChapter)obj, body, styleMap, context, progress);
            }
            progress.checkCancelState();
        }
    }

    private void writeDocumentProperties(EOBook docBook, WordMLReader wordMLFile, DocBook2WordMLGenerationContext context) {
        EOSubtitle docSubtitle;
        DocumentPropertiesWrapper docProps = new DocumentPropertiesWrapper(wordMLFile);
        EOTitle docTitle = docBook.getTitle();
        if (docTitle != null) {
            List titleContentList = docTitle.getContent(context.getReportJob());
            for (Object obj : titleContentList) {
                if (!(obj instanceof String)) continue;
                docProps.addTitle((String)obj);
            }
        }
        if ((docSubtitle = docBook.getSubtitle()) != null) {
            List subtitleContentList = docSubtitle.getContent(context.getReportJob());
            for (Object obj : subtitleContentList) {
                if (!(obj instanceof String)) continue;
                docProps.addSubject((String)obj);
            }
        }
    }
}

