/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.dom.AnchorWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.HeadingWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.IAnchorParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IHeadingParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ILinkParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IMediaObjectParent;
import com.arcway.cockpit.docgen.writer.odt.dom.IParagraphParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ISectionParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ISimpleListParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.odt.dom.ImageObjectWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.LinkWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.MediaObjectWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.ParagraphWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.SimpleListWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.TableWrapper;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SectionWrapper
implements IHeadingParent,
IParagraphParent,
ISectionParent,
ITableParent,
ISimpleListParent,
IAnchorParent,
ILinkParent,
IMediaObjectParent {
    private final Node parent;
    private final Document document;
    private final Locale projectLocale;
    private final StyleMap styleMap;
    private ParagraphWrapper paragraphWrapper = null;

    public SectionWrapper(Document document, Node parent, Locale projectLocale, StyleMap styleMap) {
        this.document = document;
        this.parent = parent;
        this.projectLocale = projectLocale;
        this.styleMap = styleMap;
    }

    @Override
    public HeadingWrapper addHeading(int outlinelevel, String style) {
        return new HeadingWrapper(this.document, this.parent, outlinelevel, style, this.styleMap, this.projectLocale);
    }

    @Override
    public ParagraphWrapper addParagraph() {
        return this.addParagraph(null);
    }

    @Override
    public ParagraphWrapper addParagraph(String style) {
        ParagraphWrapper p;
        this.paragraphWrapper = p = new ParagraphWrapper(this.document, this.parent, style, this.styleMap, this.projectLocale);
        return p;
    }

    @Override
    public SectionWrapper addSection() {
        return new SectionWrapper(this.document, this.parent, this.projectLocale, this.styleMap);
    }

    @Override
    public TableWrapper addTable(String tabstyle, DocBook2ODTGenerationContext context) {
        return new TableWrapper(this.document, this.parent, tabstyle, context);
    }

    @Override
    public AnchorWrapper addAnchor(String anchorId, String anchorName) {
        if (this.paragraphWrapper == null) {
            this.addParagraph();
        }
        return this.paragraphWrapper.addAnchor(anchorId, anchorName);
    }

    @Override
    public LinkWrapper addLink(String anchorName) {
        if (this.paragraphWrapper == null) {
            this.addParagraph();
        }
        return this.paragraphWrapper.addLink(anchorName);
    }

    @Override
    public SimpleListWrapper addSimpleList() {
        if (this.paragraphWrapper == null) {
            this.addParagraph();
        }
        return this.paragraphWrapper.addSimpleList();
    }

    @Override
    public MediaObjectWrapper addMediaObject() {
        return this.paragraphWrapper.addMediaObject();
    }

    @Override
    public ImageObjectWrapper addImageObject(String name, String format, float width, float height, boolean newImage, int imageCounter, String filename) {
        return this.paragraphWrapper.addImageObject(name, format, width, height, newImage, imageCounter, filename);
    }
}

