/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.writer.odt.ModulePlugin;
import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class LinkWrapper {
    private final Document document;
    private Element linkT = null;

    public LinkWrapper(Document document, Node parent, String anchorName, Locale projectLocale) {
        this.document = document;
        Element linkElement = document.createElement("text:a");
        linkElement.setAttribute("xlink:type", "simple");
        linkElement.setAttribute("xlink:href", "#" + anchorName);
        linkElement.setAttribute("office:target-frame-name", "_top");
        linkElement.setAttribute("xlink:show", "replace");
        this.linkT = (Element)parent.appendChild(linkElement);
        IPreferenceStore store = ModulePlugin.getDefault().getPreferenceStore();
        boolean withPageNumber = store.getBoolean("ODTPreferences.PAGEREFERENCE");
        if (withPageNumber) {
            Text textBegin = document.createTextNode(" (" + Messages.getString((String)"PageRef", (Locale)projectLocale) + " ");
            parent.appendChild(textBegin);
            Element pageNumberRef = document.createElement("text:bookmark-ref");
            pageNumberRef.setAttribute("text:reference-format", "page");
            pageNumberRef.setAttribute("text:ref-name", anchorName);
            pageNumberRef = (Element)parent.appendChild(pageNumberRef);
            Text dummyPageNr = document.createTextNode("999");
            pageNumberRef.appendChild(dummyPageNr);
            Text textEnd = document.createTextNode(")");
            parent.appendChild(textEnd);
        }
    }

    public void addText(String text) {
        Text t = this.document.createTextNode(text);
        this.linkT.appendChild(t);
    }
}

