/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.files.atomic;

import com.arcway.cockpit.cockpitlib.client.files.atomic.EOFileSetIndexEntry;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileSetTransaction;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileSetTransactionAbortedException;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileTransactionManagerInitialisationFailed;
import com.arcway.cockpit.cockpitlib.client.files.atomic.IFileSetTransaction;
import com.arcway.cockpit.cockpitlib.client.files.atomic.IFileSetTransactionBody;
import com.arcway.cockpit.cockpitlib.client.files.atomic.ModificationFile;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FileSetTransactionManager {
    private static final ILogger LOGGER = Logger.getLogger(FileSetTransactionManager.class);
    public static final String indexFilePrefix = "idx";
    private static final String xmlFileSuffix = ".acc";
    private static final String indexFileVersionChars = "i123";
    private static final int initialIndexFileVersion = 0;
    private static final int[] successorIndexFileVersion = new int["i123".length()];
    private static final XMLDecoder decoder;
    private static final IEncodableObjectFactory fileIndexEOFactory;
    private final File modFileDirectory;
    private Map<String, ModificationFile> currentlyValidFileSet;
    private int currentlyValidIndexFileVersion;
    private FileSetTransaction pendingTransaction;

    static {
        int i = 0;
        while (i < indexFileVersionChars.length() - 1) {
            FileSetTransactionManager.successorIndexFileVersion[i] = i + 1;
            ++i;
        }
        FileSetTransactionManager.successorIndexFileVersion[indexFileVersionChars.length() - 1] = 1;
        decoder = new XMLDecoder();
        fileIndexEOFactory = new IEncodableObjectFactory(){

            public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
                if (name.equals("List")) {
                    return new EOList(context);
                }
                if (name.equals("FileSetIndexEntry")) {
                    return new EOFileSetIndexEntry(context);
                }
                return null;
            }
        };
    }

    public FileSetTransactionManager(File modFileDirectory) {
        this.modFileDirectory = modFileDirectory;
    }

    public File getModFileDirectory() {
        return this.modFileDirectory;
    }

    public void executeAsTransaction(IFileSetTransactionBody transactionBody) throws FileSetTransactionAbortedException {
        IFileSetTransaction fileTransaction = null;
        FileSetTransactionAbortedException transactionAbortedException = null;
        try {
            fileTransaction = this.startTransaction();
            transactionBody.run(fileTransaction);
            this.commitTransaction(fileTransaction);
        }
        catch (Exception e) {
            transactionAbortedException = new FileSetTransactionAbortedException(e.getLocalizedMessage(), e);
        }
        if (fileTransaction != null && !fileTransaction.isTerminated()) {
            this.rollbackTransaction(fileTransaction);
        }
        if (transactionAbortedException != null) {
            throw transactionAbortedException;
        }
    }

    public IFileSetTransaction startTransaction() throws FileSetTransactionAbortedException {
        assert (this.pendingTransaction == null);
        if (this.pendingTransaction != null) {
            throw new FileSetTransactionAbortedException("Illegal Transaction Usage - Nested Transactions are not supported.", new Exception());
        }
        this.pendingTransaction = new FileSetTransaction(this, new HashMap<String, ModificationFile>(this.currentlyValidFileSet));
        return this.pendingTransaction;
    }

    public void rollbackTransaction(IFileSetTransaction transaction) {
        assert (transaction != null);
        assert (transaction == this.pendingTransaction);
        if (transaction == this.pendingTransaction) {
            this.deleteObsoleteFiles(this.pendingTransaction.getModificationTmpFiles());
            this.pendingTransaction.markAsTerminated();
            this.pendingTransaction = null;
        } else {
            LOGGER.warn("Attempt to rollback terminated or non-existent Transaction.", (Throwable)new Exception());
        }
    }

    public void commitTransaction(IFileSetTransaction transaction) throws FileSetTransactionAbortedException {
        ArrayList<ModificationFile> filesToDelete;
        assert (transaction != null);
        assert (transaction == this.pendingTransaction);
        boolean transactionEntailsChanges = false;
        for (Map.Entry<String, ModificationFile> transactionResultFileSetEntry : this.pendingTransaction.getCurrentlyValidFileSet().entrySet()) {
            ModificationFile modificationFile = this.currentlyValidFileSet.get(transactionResultFileSetEntry.getKey());
            if (transactionResultFileSetEntry.getValue().equals(modificationFile)) continue;
            transactionEntailsChanges = true;
            break;
        }
        transactionEntailsChanges = transactionEntailsChanges || this.pendingTransaction.getCurrentlyValidFileSet().size() != this.currentlyValidFileSet.size();
        Throwable newIndexFileCreationException = null;
        if (transactionEntailsChanges) {
            ModificationFile newIndexFile;
            int newIndexFileVersion;
            block34: {
                EOList newIndexFileContents = new EOList();
                for (Map.Entry<String, ModificationFile> fileSetEntry : this.pendingTransaction.getCurrentlyValidFileSet().entrySet()) {
                    newIndexFileContents.add((EncodableObjectBase)new EOFileSetIndexEntry(fileSetEntry.getKey(), fileSetEntry.getValue().getRelativeFilePath(this.modFileDirectory)));
                }
                newIndexFileVersion = successorIndexFileVersion[this.currentlyValidIndexFileVersion];
                newIndexFile = this.calculateIndexFileName(newIndexFileVersion);
                OutputStream newIndexFileStream = null;
                try {
                    try {
                        newIndexFileStream = new BufferedOutputStream(new FileOutputStream(newIndexFile));
                        newIndexFileContents.writeToXMLStream(newIndexFileStream, true);
                    }
                    catch (Throwable th) {
                        newIndexFileCreationException = th;
                        if (newIndexFileStream != null) {
                            try {
                                newIndexFileStream.close();
                            }
                            catch (IOException e) {
                                if (newIndexFileCreationException == null) {
                                    newIndexFileCreationException = e;
                                }
                                LOGGER.error("Problem while closing (probably) unuseable new index file: " + newIndexFile, (Throwable)e);
                            }
                        }
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    if (newIndexFileStream != null) {
                        try {
                            newIndexFileStream.close();
                        }
                        catch (IOException e) {
                            if (newIndexFileCreationException == null) {
                                newIndexFileCreationException = e;
                            }
                            LOGGER.error("Problem while closing (probably) unuseable new index file: " + newIndexFile, (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (newIndexFileStream != null) {
                    try {
                        newIndexFileStream.close();
                    }
                    catch (IOException e) {
                        if (newIndexFileCreationException == null) {
                            newIndexFileCreationException = e;
                        }
                        LOGGER.error("Problem while closing (probably) unuseable new index file: " + newIndexFile, (Throwable)e);
                    }
                }
            }
            boolean newIndexFileDeletionWasAttemptedAndSuccessful = false;
            if (newIndexFileCreationException != null) {
                try {
                    FileHelper.deleteFileOrDirectory((File)newIndexFile);
                    newIndexFileDeletionWasAttemptedAndSuccessful = true;
                }
                catch (Exception e) {
                    LOGGER.debug("Problem while trying to delete (probably) unuseable new index file: " + newIndexFile, (Throwable)e);
                }
            }
            if (newIndexFileCreationException == null) {
                ModificationFile previousIndexFile = this.calculateIndexFileName(this.currentlyValidIndexFileVersion);
                Map<String, ModificationFile> previouslyValidFileSet = this.currentlyValidFileSet;
                this.currentlyValidIndexFileVersion = newIndexFileVersion;
                this.currentlyValidFileSet = new HashMap<String, ModificationFile>(this.pendingTransaction.getCurrentlyValidFileSet());
                HashSet<ModificationFile> unreferencedModificationTempFiles = new HashSet<ModificationFile>(this.pendingTransaction.getModificationTmpFiles());
                unreferencedModificationTempFiles.removeAll(this.currentlyValidFileSet.values());
                for (ModificationFile unreferencedModificationTempFile : unreferencedModificationTempFiles) {
                    assert (false);
                    LOGGER.error("Unreferenced Modification Temp File detected during commit of transaction:" + unreferencedModificationTempFile);
                }
                HashSet<ModificationFile> delistedIndexFiles = new HashSet<ModificationFile>(previouslyValidFileSet.values());
                delistedIndexFiles.removeAll(this.currentlyValidFileSet.values());
                filesToDelete = new ArrayList(unreferencedModificationTempFiles.size() + 1 + delistedIndexFiles.size());
                filesToDelete.addAll(unreferencedModificationTempFiles);
                filesToDelete.add(previousIndexFile);
                filesToDelete.addAll(delistedIndexFiles);
            } else {
                filesToDelete = new ArrayList(this.pendingTransaction.getModificationTmpFiles().size() + 1);
                filesToDelete.addAll(this.pendingTransaction.getModificationTmpFiles());
                if (!newIndexFileDeletionWasAttemptedAndSuccessful) {
                    filesToDelete.add(newIndexFile);
                }
            }
        } else {
            for (ModificationFile unreferencedModificationTempFile : this.pendingTransaction.getModificationTmpFiles()) {
                assert (false);
                LOGGER.error("Unreferenced Modification Temp File detected during commit of transaction:" + unreferencedModificationTempFile);
            }
            filesToDelete = new ArrayList<ModificationFile>(this.pendingTransaction.getModificationTmpFiles().size());
        }
        this.deleteObsoleteFiles(filesToDelete);
        this.pendingTransaction.markAsTerminated();
        this.pendingTransaction = null;
        if (newIndexFileCreationException != null) {
            throw new FileSetTransactionAbortedException("FileSetTranscation was aborted because of a failure while updating the file index.", newIndexFileCreationException);
        }
    }

    private void deleteObsoleteFiles(Collection<ModificationFile> filesToDelete) {
        for (ModificationFile fileToDelete : filesToDelete) {
            try {
                FileHelper.deleteFileOrDirectory((File)fileToDelete);
            }
            catch (Exception e) {
                LOGGER.error("Unable to delete obsolete Modification File while completing transaction:" + fileToDelete);
            }
        }
    }

    public void initialise() throws FileTransactionManagerInitialisationFailed {
        File[] filesInModFileDirectory;
        try {
            FileHelper.ensureDirectoryExistance((File)this.modFileDirectory);
        }
        catch (Exception e) {
            throw new FileTransactionManagerInitialisationFailed("Unable to access/create directory " + this.modFileDirectory, e);
        }
        ArrayList<File> allIndexFiles = new ArrayList<File>();
        try {
            filesInModFileDirectory = this.modFileDirectory.listFiles();
        }
        catch (Exception e) {
            throw new FileTransactionManagerInitialisationFailed("Unable to initialise - unable to list modFileDirectory content. " + this.modFileDirectory, e);
        }
        if (filesInModFileDirectory == null) {
            filesInModFileDirectory = new File[]{};
        }
        File[] fileArray = filesInModFileDirectory;
        int n = filesInModFileDirectory.length;
        int n2 = 0;
        while (n2 < n) {
            File candidateIndexFile = fileArray[n2];
            if (this.isIndexFileName(candidateIndexFile.getName())) {
                allIndexFiles.add(candidateIndexFile);
            }
            ++n2;
        }
        boolean initComplete = false;
        if (allIndexFiles.size() == 0) {
            if (filesInModFileDirectory.length > 0) {
                throw new FileTransactionManagerInitialisationFailed("Corrupt Filesystem State - unable to determine valid Index File");
            }
            this.initialiseByStartingFromScratch();
            initComplete = true;
        } else if (allIndexFiles.size() == 1) {
            File uniqueIndexFile = (File)allIndexFiles.get(0);
            try {
                this.initialiseFromIndexFileContent(uniqueIndexFile);
                initComplete = true;
            }
            catch (Exception e) {
                LOGGER.error("Corrupt Filesystem State - unable to read unique Index File" + uniqueIndexFile);
                if (this.extractIndexFileVersion(uniqueIndexFile) == 0) {
                    try {
                        FileHelper.deleteExistingFileOrDirectory((File)uniqueIndexFile);
                    }
                    catch (JvmExternalResourceInteractionException e1) {
                        throw new FileTransactionManagerInitialisationFailed("Unable to recover. Corrupt Filesystem State - unable to read unique Index File" + uniqueIndexFile, e);
                    }
                    this.initialiseByStartingFromScratch();
                    initComplete = true;
                }
                throw new FileTransactionManagerInitialisationFailed("Unable to recover. Corrupt Filesystem State - unable to read unique Index File" + uniqueIndexFile, e);
            }
        } else if (allIndexFiles.size() == 2) {
            File newIndexFile;
            File oldIndexFile;
            if (this.isIndexFileVersionPairInProperSequence((File)allIndexFiles.get(0), (File)allIndexFiles.get(1))) {
                oldIndexFile = (File)allIndexFiles.get(0);
                newIndexFile = (File)allIndexFiles.get(1);
            } else if (this.isIndexFileVersionPairInProperSequence((File)allIndexFiles.get(1), (File)allIndexFiles.get(0))) {
                oldIndexFile = (File)allIndexFiles.get(1);
                newIndexFile = (File)allIndexFiles.get(0);
            } else {
                throw new FileTransactionManagerInitialisationFailed("Unable to recover. Corrupt Filesystem State - two non consecutive Index Files found: " + allIndexFiles.get(0) + ", " + allIndexFiles.get(1) + ".");
            }
            try {
                if (oldIndexFile.lastModified() > newIndexFile.lastModified()) {
                    throw new FileTransactionManagerInitialisationFailed("Unable to recover. Corrupt Filesystem State - two consecutive Index Files with illegal modification order found: " + allIndexFiles.get(0) + ", " + allIndexFiles.get(1) + ".");
                }
            }
            catch (Exception e) {
                LOGGER.debug("Unable to perform sanity check on Filesystem State - skipping check.", (Throwable)e);
            }
            try {
                this.initialiseFromIndexFileContent(newIndexFile);
                initComplete = true;
            }
            catch (Exception newIndexFileEx) {
                LOGGER.error("Potentially corrupt Filesystem State - could not intialise using the newer Index File " + newIndexFile + " of two available consecutive Index Files. Trying to recover using the older Version: " + oldIndexFile, (Throwable)newIndexFileEx);
                try {
                    this.initialiseFromIndexFileContent(oldIndexFile);
                    initComplete = true;
                }
                catch (Exception oldIndexFileEx) {
                    throw new FileTransactionManagerInitialisationFailed("Unable to recover. Corrupt Filesystem State - two consecutive Index Files. Both files are unuseable. The older File " + oldIndexFile + " suffered from the following Problem: " + oldIndexFileEx.getLocalizedMessage(), oldIndexFileEx);
                }
            }
        } else {
            throw new FileTransactionManagerInitialisationFailed("Unable to recover. Corrupt Filesystem State - unable to determine correct Index File: " + allIndexFiles.size() + " possibilities.");
        }
        if (!initComplete) {
            assert (false);
            throw new FileTransactionManagerInitialisationFailed("Unable to initialise/recover.");
        }
    }

    private void initialiseFromIndexFileContent(File indexFile) throws FileTransactionManagerInitialisationFailed {
        Collection<Object> filesInModFileDirectoryTree;
        EOList indexFileContent;
        try {
            indexFileContent = (EOList)FileSetTransactionManager.readFile(indexFile, fileIndexEOFactory);
        }
        catch (Exception e) {
            throw new FileTransactionManagerInitialisationFailed("Unable to recover from index file: " + indexFile + ". The index file's Content is corrupt (syntax errors).", e);
        }
        this.currentlyValidIndexFileVersion = this.extractIndexFileVersion(indexFile);
        this.currentlyValidFileSet = new HashMap<String, ModificationFile>(indexFileContent.size() * 2);
        for (EOFileSetIndexEntry entry : indexFileContent) {
            boolean fileExists;
            if (entry.getFileKeyID() == null || entry.getFileversionName() == null) {
                throw new FileTransactionManagerInitialisationFailed("Unable to initialise due to corrupt Index File Content.");
            }
            ModificationFile modificationFile = new ModificationFile(this.modFileDirectory, entry.getFileversionName());
            try {
                fileExists = modificationFile.exists();
            }
            catch (Exception e) {
                throw new FileTransactionManagerInitialisationFailed("Unable to initialise because of problems while checking existence of File: " + modificationFile, e);
            }
            if (!fileExists) {
                throw new FileTransactionManagerInitialisationFailed("Unable to initialise due to missing File: " + modificationFile);
            }
            this.currentlyValidFileSet.put(entry.getFileKeyID(), modificationFile);
        }
        HashSet<ModificationFile> filesCurrentlyinUse = new HashSet<ModificationFile>();
        filesCurrentlyinUse.add(this.calculateIndexFileName(this.currentlyValidIndexFileVersion));
        filesCurrentlyinUse.addAll(this.currentlyValidFileSet.values());
        try {
            filesInModFileDirectoryTree = this.modFileDirectory.isDirectory() ? FileSetTransactionManager.listFilesRecursivly(this.modFileDirectory) : Collections.emptyList();
        }
        catch (Exception exception) {
            throw new FileTransactionManagerInitialisationFailed("Unable to initialise - unable to list modFileDirectory content. " + this.modFileDirectory, exception);
        }
        for (File file : filesInModFileDirectoryTree) {
            if (filesCurrentlyinUse.contains(file)) continue;
            try {
                LOGGER.debug("Leftover Modification File found - will try to remove it. " + file);
                FileHelper.deleteExistingFileOrDirectory((File)file);
            }
            catch (Exception e) {
                throw new FileTransactionManagerInitialisationFailed("Unable to initialise because deletion of obsolete File failed: " + file, e);
            }
        }
    }

    private static Collection<File> listFilesRecursivly(File rootDirectory) {
        File[] files;
        ArrayList<File> filesInDirectoryTree = new ArrayList<File>();
        File[] fileArray = files = rootDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                filesInDirectoryTree.addAll(FileSetTransactionManager.listFilesRecursivly(file));
            } else {
                filesInDirectoryTree.add(file);
            }
            ++n2;
        }
        return filesInDirectoryTree;
    }

    private void initialiseByStartingFromScratch() throws FileTransactionManagerInitialisationFailed {
        try {
            FileHelper.deleteContentOfDirectory((File)this.modFileDirectory);
        }
        catch (Exception e) {
            throw new FileTransactionManagerInitialisationFailed("Unable to clear Modification File Directory:" + this.modFileDirectory, e);
        }
        this.currentlyValidIndexFileVersion = 0;
        this.currentlyValidFileSet = new HashMap<String, ModificationFile>();
        ModificationFile initialIndexFile = this.calculateIndexFileName(0);
        try (FilterOutputStream targetStream = null;){
            targetStream = new BufferedOutputStream(new FileOutputStream(initialIndexFile));
            new EOList().writeToXMLStream((OutputStream)targetStream, true);
        }
        catch (Throwable e) {
            throw new FileTransactionManagerInitialisationFailed("Unable to initialise Index File" + initialIndexFile, e);
        }
    }

    private boolean isIndexFileVersionPairInProperSequence(File currentFile, File successorFile) {
        assert (this.isIndexFileName(currentFile.getName()));
        assert (this.isIndexFileName(successorFile.getName()));
        return successorIndexFileVersion[this.extractIndexFileVersion(currentFile)] == this.extractIndexFileVersion(successorFile);
    }

    private ModificationFile calculateIndexFileName(int versionNumber) {
        assert (versionNumber >= 0 && versionNumber < indexFileVersionChars.length());
        return new ModificationFile(this.modFileDirectory, indexFilePrefix + indexFileVersionChars.charAt(versionNumber) + xmlFileSuffix);
    }

    private int extractIndexFileVersion(File indexFile) {
        assert (this.isIndexFileName(indexFile.getName()));
        return indexFileVersionChars.indexOf(indexFile.getName().charAt(indexFilePrefix.length()));
    }

    private boolean isIndexFileName(String fileName) {
        return fileName.startsWith(indexFilePrefix) && fileName.endsWith(xmlFileSuffix) && fileName.length() == indexFilePrefix.length() + 1 + xmlFileSuffix.length() && indexFileVersionChars.indexOf(fileName.charAt(indexFilePrefix.length())) != -1;
    }

    public static <EO extends EOEncodableObject> EO readFile(File inputFile, IEncodableObjectFactory factory) throws EXDecoderException, IOException {
        XMLDecoder xMLDecoder = decoder;
        synchronized (xMLDecoder) {
            EncodableObjectBase list = decoder.decodeXMLFile(inputFile, factory, true);
            if (list != null) {
                return (EO)((EOEncodableObject)list);
            }
            throw new EXDecoderException("Unexpected file content (empty?) in file: " + inputFile);
        }
    }
}

