/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.lock;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractCrossLinkRepositoryRelationLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryAttributeSetLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryIDLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryObjectLockSample;
import com.arcway.repository.interFace.data.lock.RepositoryObjectLockType;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;

public class RepositoryLocks {
    public static boolean compatible(AbstractRepositoryLockSample lock1, AbstractRepositoryLockSample lock2) {
        boolean result = true;
        if (lock1 instanceof AbstractRepositoryAttributeSetLockSample && lock2 instanceof AbstractRepositoryAttributeSetLockSample) {
            AbstractRepositoryAttributeSetLockSample asLock1 = (AbstractRepositoryAttributeSetLockSample)lock1;
            AbstractRepositoryAttributeSetLockSample asLock2 = (AbstractRepositoryAttributeSetLockSample)lock2;
            if (IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)asLock1.getObjectTypeID(), (Object)asLock2.getObjectTypeID()) && RepositorySamples.isEqual((IRepositoryPropertySetSample)asLock1.getObjectID(), (IRepositoryPropertySetSample)asLock2.getObjectID()) && IRepositoryAttributeSetTypeID.IS_EQUAL_ATTRIBUTE_SET_TYPE_ID_HASHER.isEqual((Object)asLock1.getAttributeSetTypeID(), (Object)asLock2.getAttributeSetTypeID())) {
                result = false;
            }
        } else if (lock1 instanceof AbstractRepositoryObjectLockSample && lock2 instanceof AbstractRepositoryObjectLockSample) {
            AbstractRepositoryObjectLockSample objLock1 = (AbstractRepositoryObjectLockSample)lock1;
            AbstractRepositoryObjectLockSample objLock2 = (AbstractRepositoryObjectLockSample)lock2;
            if (IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)objLock1.getObjectTypeID(), (Object)objLock2.getObjectTypeID()) && RepositorySamples.isEqual((IRepositoryPropertySetSample)objLock1.getObjectID(), (IRepositoryPropertySetSample)objLock2.getObjectID()) && !RepositoryObjectLockType.isCompatible((RepositoryObjectLockType)objLock1.getLockType(), (RepositoryObjectLockType)objLock2.getLockType())) {
                result = false;
            }
        } else if (lock1 instanceof AbstractRepositoryIDLockSample && lock2 instanceof AbstractRepositoryIDLockSample) {
            AbstractRepositoryIDLockSample idLock1 = (AbstractRepositoryIDLockSample)lock1;
            AbstractRepositoryIDLockSample idLock2 = (AbstractRepositoryIDLockSample)lock2;
            if (RepositorySamples.isEqual((IRepositoryPropertySample)idLock1.getID(), (IRepositoryPropertySample)idLock2.getID()) && IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)idLock1.getObjectTypeID(), (Object)idLock2.getObjectTypeID()) && IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.isEqual((Object)idLock1.getPropertyTypeID(), (Object)idLock2.getPropertyTypeID()) && IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)idLock1.getContextObjectTypeID(), (Object)idLock2.getContextObjectTypeID()) && RepositorySamples.isEqual((IRepositoryPropertySetSample)idLock1.getContextObjectID(), (IRepositoryPropertySetSample)idLock2.getContextObjectID())) {
                result = false;
            }
        } else if (lock1 instanceof AbstractCrossLinkRepositoryRelationLockSample && lock2 instanceof AbstractCrossLinkRepositoryRelationLockSample) {
            AbstractCrossLinkRepositoryRelationLockSample relLock1 = (AbstractCrossLinkRepositoryRelationLockSample)lock1;
            AbstractCrossLinkRepositoryRelationLockSample relLock2 = (AbstractCrossLinkRepositoryRelationLockSample)lock2;
            if (ICrossLinkRepositoryRelationReference.REFERENCING_EQUAL_RELATIONS_HASHER.isEqual((Object)relLock1.getRelation(), (Object)relLock2.getRelation())) {
                result = false;
            }
        }
        return result;
    }

    public static boolean conflicting(AbstractRepositoryLockSample lock1, AbstractRepositoryLockSample lock2) {
        return !RepositoryLocks.compatible(lock1, lock2);
    }

    public static boolean compatible(AbstractRepositoryLockSample[] locks1, AbstractRepositoryLockSample[] locks2) {
        return !RepositoryLocks.conflicting(locks1, locks2);
    }

    public static boolean conflicting(AbstractRepositoryLockSample[] locks1, AbstractRepositoryLockSample[] locks2) {
        Assert.checkArgumentBeeingNotNull((Object)locks1);
        Assert.checkArgumentBeeingNotNull((Object)locks2);
        AbstractRepositoryLockSample[] abstractRepositoryLockSampleArray = locks1;
        int n = locks1.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRepositoryLockSample lockSample1 = abstractRepositoryLockSampleArray[n2];
            AbstractRepositoryLockSample[] abstractRepositoryLockSampleArray2 = locks2;
            int n3 = locks2.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractRepositoryLockSample lockSample2 = abstractRepositoryLockSampleArray2[n4];
                if (RepositoryLocks.conflicting(lockSample1, lockSample2)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }
}

