/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.RepositoryObjects;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.attributeset.RepositoryAttributeSetTypeConflictType;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.importexport.exceptions.EXConflictingCrossLinkRelationsChanged;
import com.arcway.repository.interFace.importexport.exceptions.EXDifferentPropertyValues;
import com.arcway.repository.interFace.importexport.exceptions.EXMergeTargetNotSet;
import com.arcway.repository.interFace.importexport.exceptions.EXMissingObject;
import com.arcway.repository.interFace.importexport.exceptions.EXParentNotImported;
import com.arcway.repository.interFace.importexport.exceptions.EXParentNotSet;
import com.arcway.repository.interFace.importexport.imporT.ImportTransactionCreationContext;
import com.arcway.repository.interFace.importexport.imporT.importjob.ImportJobHelper;
import com.arcway.repository.interFace.importexport.imporT.importjob.RelationSampleWithObjectTypes;
import com.arcway.repository.interFace.importexport.imporT.importjob.RelationSampleWithRelationCreationRequests;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationTypeRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportJobRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportedObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportedObjectTypeRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IOccurrenceRelationRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IPropertyRO;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RSAComplexGenericModification;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;

public class ImportTransactionFactory {
    private final IImportJobRO importJob;

    public ImportTransactionFactory(IImportJobRO importJob) {
        this.importJob = importJob;
    }

    public Tuple<RSAComplexGenericModification, IMessageSet> createImportTransaction(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        MessageSet messages = new MessageSet();
        ImportTransactionCreationContext transactionCreationContext = new ImportTransactionCreationContext();
        for (IImportedObjectTypeRO iImportedObjectTypeRO : this.importJob.getImportedObjectTypes()) {
            for (IImportedObjectRO iImportedObjectRO : iImportedObjectTypeRO.getRootObjects()) {
                boolean isImportJobParentImported = false;
                this.addObjectToImportTransaction(iImportedObjectRO, isImportJobParentImported, transactionCreationContext, repositorySnapshot, messages);
            }
        }
        for (ICrossLinkRelationTypeRO iCrossLinkRelationTypeRO : this.importJob.getCrossLinkRelationTypes()) {
            this.addRelationsOfTypeToImportTransaction(iCrossLinkRelationTypeRO, transactionCreationContext, repositorySnapshot, messages);
        }
        transactionCreationContext.validate(repositorySnapshot, messages);
        RSAComplexGenericModification rSAComplexGenericModification = transactionCreationContext.createTransaction();
        return new Tuple((Object)rSAComplexGenericModification, (Object)messages);
    }

    private void addObjectToImportTransaction(IImportedObjectRO object, boolean isImportJobParentImported, ImportTransactionCreationContext transactionCreationContext, IRepositorySnapshotRO repositorySnapshot, MessageSet messages) throws EXNotReproducibleSnapshot {
        boolean isImported = false;
        if (object.getImportFlag()) {
            if (object.getImportMode() == 1) {
                IImportedObjectRO parentInImportJob;
                IRepositoryObjectReference parent = object.getImportTarget();
                if (parent == null && isImportJobParentImported) {
                    parentInImportJob = object.getParent();
                    assert (parentInImportJob != null);
                    if (parentInImportJob.getImportMode() == 2) {
                        parent = parentInImportJob.getMatchingObject();
                        assert (parent != null);
                    } else if (parentInImportJob.getImportMode() == 1) {
                        parent = new RepositoryObjectReference(parentInImportJob.getObjectType().getObjectType().getRepositoryObjectTypeID(), parentInImportJob.getObjectID());
                    } else assert (false);
                }
                if (parent != null) {
                    ObjectCreationInformation propertyAndOccurrenceSamples = ImportTransactionFactory.compileObjectCreationInformation(object, repositorySnapshot, messages);
                    RepositoryObjectSample sample = new RepositoryObjectSample(object.getObjectType().getObjectType(), object.getToBeRepositoryObjectTypeCategory(), (IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)propertyAndOccurrenceSamples.getPropertySamples());
                    transactionCreationContext.addObjectToCreate(sample, parent);
                    transactionCreationContext.addOccurrenceRelationsToCreate((ICollection_<IOccurrenceRepositoryRelationSample>)propertyAndOccurrenceSamples.getOccurrenceRelationsToCreate());
                    transactionCreationContext.addOccurrenceRelationsToDelete((ICollection_<IOccurrenceRepositoryRelationReference>)propertyAndOccurrenceSamples.getOccurrenceRelationsToDelete());
                    isImported = true;
                } else {
                    RepositoryObjectReference importedObject;
                    parentInImportJob = object.getParent();
                    if (parentInImportJob == null) {
                        importedObject = new RepositoryObjectReference(object.getObjectType().getObjectType().getRepositoryObjectTypeID(), object.getObjectID());
                        messages.add(new EXParentNotSet(importedObject));
                    } else {
                        importedObject = new RepositoryObjectReference(object.getObjectType().getObjectType().getRepositoryObjectTypeID(), object.getObjectID());
                        messages.add(new EXParentNotImported(importedObject));
                    }
                }
            } else if (object.getImportMode() == 2) {
                IRepositoryObjectReference matchingObject = object.getMatchingObject();
                if (matchingObject != null) {
                    ObjectModificationInformation objectModificationInformation = ImportTransactionFactory.compileObjectModificationInformation(object, repositorySnapshot, messages);
                    Tuple objectTypeCategoryToBeChanged = null;
                    if (objectModificationInformation.isObjectTypeCatgeoryToBeModified()) {
                        objectTypeCategoryToBeChanged = new Tuple((Object)object.getMatchingObject(), (Object)objectModificationInformation.getNewObjectTypeCatgeoryID());
                    }
                    HashMap_ propertiesToMerge = new HashMap_(IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER);
                    for (IEntry_ property : objectModificationInformation.getPropertySamples()) {
                        RepositoryPropertyReference propertyReference = new RepositoryPropertyReference(object.getMatchingObject(), (IRepositoryPropertyTypeID)property.getKey());
                        propertiesToMerge.put((Object)propertyReference, (Object)((IRepositoryPropertySample)property.getValue()));
                    }
                    transactionCreationContext.addToMergeList(matchingObject, object, (Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>)objectTypeCategoryToBeChanged, (IMapRW_<IRepositoryPropertyReference, IRepositoryPropertySample>)propertiesToMerge, (ICollection_<IOccurrenceRepositoryRelationSample>)objectModificationInformation.getOccurrenceRelationsToCreate(), (ICollection_<IOccurrenceRepositoryRelationReference>)objectModificationInformation.getOccurrenceRelationsToDelete());
                    object.getImportTarget();
                    isImported = true;
                } else {
                    RepositoryObjectReference objectToMerge = new RepositoryObjectReference(object.getObjectType().getObjectType().getRepositoryObjectTypeID(), object.getObjectID());
                    messages.add(new EXMergeTargetNotSet(objectToMerge));
                }
            }
        }
        for (IImportedObjectRO child : object.getChildren()) {
            this.addObjectToImportTransaction(child, isImported, transactionCreationContext, repositorySnapshot, messages);
        }
    }

    private static ObjectCreationInformation compileObjectCreationInformation(IImportedObjectRO object, IRepositorySnapshotRO repositorySnapshot, MessageSet messages) throws EXNotReproducibleSnapshot {
        HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        ArrayList_ occurrenceRelationsToCreate = new ArrayList_();
        ArrayList_ occurrenceRelationsToDelete = new ArrayList_();
        IRepositoryPropertySample propertyToAdd = null;
        for (IPropertyRO iPropertyRO : object.getProperties()) {
            IRepositoryPropertyTypeID propertyTypeID = iPropertyRO.getRepositoryPropertyType().getRepositoryPropertyTypeID();
            if (object.getObjectID().getPropertyTypeIDs().contains((Object)propertyTypeID)) {
                propertyToAdd = object.getObjectID().getPropertySample(propertyTypeID);
            } else {
                IRepositoryData toBeValue = iPropertyRO.getToBeValue();
                if (toBeValue == null) {
                    toBeValue = ImportJobHelper.determineEffectivePropertyValueIfToBeValueIsNullDependingOnImportMode(iPropertyRO, repositorySnapshot);
                }
                propertyToAdd = new RepositoryPropertySample(toBeValue);
            }
            if (propertyToAdd != null) {
                propertySamples.put((Object)propertyTypeID, (Object)propertyToAdd);
            }
            if (iPropertyRO.getRepositoryPropertyType().getOccuringRelationContributionType() == null) continue;
            ImportTransactionFactory.compileOccurrenceSamples(iPropertyRO, false, null, (ICollectionRW_<IOccurrenceRepositoryRelationSample>)occurrenceRelationsToCreate, (ICollectionRW_<IOccurrenceRepositoryRelationReference>)occurrenceRelationsToDelete, repositorySnapshot, messages);
        }
        return new ObjectCreationInformation((IMapRW_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)propertySamples, (ICollectionRW_<IOccurrenceRepositoryRelationSample>)occurrenceRelationsToCreate, (ICollectionRW_<IOccurrenceRepositoryRelationReference>)occurrenceRelationsToDelete);
    }

    private static ObjectModificationInformation compileObjectModificationInformation(IImportedObjectRO object, IRepositorySnapshotRO repositorySnapshot, MessageSet messages) throws EXNotReproducibleSnapshot {
        boolean isObjectTypeCatgeoryToBeModified = false;
        IRepositoryObjectTypeCategoryID newObjectTypeCatgeoryID = null;
        HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        ArrayList_ occurrenceRelationsToCreate = new ArrayList_();
        ArrayList_ occurrenceRelationsToDelete = new ArrayList_();
        IRepositoryObjectReference matchingObjectAsReference = object.getMatchingObject();
        if (matchingObjectAsReference != null) {
            try {
                boolean isDifferingCategorySet;
                IRepositoryObject matchingObject = RepositoryReferences.getObjectFromReference(matchingObjectAsReference, repositorySnapshot);
                IRepositoryObjectSample matchingObjectAsSample = matchingObject.sample();
                IRepositoryObjectTypeCategoryID toBeCategoryID = object.getToBeRepositoryObjectTypeCategory();
                IRepositoryObjectTypeCategory currentCategory = matchingObject.getObjectTypeCategory();
                IRepositoryObjectTypeCategoryID currentCategoryID = currentCategory != null ? currentCategory.getObjectTypeCategoryID() : null;
                boolean bl = isDifferingCategorySet = !IRepositoryObjectTypeCategoryID.IS_EQUAL_OBJECT_TYPE_CATEGORY_ID_HASHER.isEqual((Object)toBeCategoryID, (Object)currentCategoryID);
                if (isDifferingCategorySet) {
                    isObjectTypeCatgeoryToBeModified = true;
                    newObjectTypeCatgeoryID = toBeCategoryID;
                }
                for (IPropertyRO iPropertyRO : object.getProperties()) {
                    boolean propertyIsModified;
                    IRepositoryPropertyTypeID propertyTypeID = iPropertyRO.getRepositoryPropertyType().getRepositoryPropertyTypeID();
                    IRepositoryData toBeValue = iPropertyRO.getToBeValue();
                    if (toBeValue == null) {
                        toBeValue = ImportJobHelper.determineEffectivePropertyValueIfToBeValueIsNullDependingOnImportMode(iPropertyRO, repositorySnapshot);
                    }
                    IRepositoryPropertySample currentPropertySample = matchingObjectAsSample.getPropertySetSample().getPropertySample(iPropertyRO.getRepositoryPropertyType().getRepositoryPropertyTypeID());
                    IRepositoryData currentPropertyValue = currentPropertySample.getValue();
                    boolean bl2 = propertyIsModified = !toBeValue.getDataType().getEqualComparator().isEqual(toBeValue, currentPropertyValue);
                    if (!object.getObjectID().getPropertyTypeIDs().contains((Object)propertyTypeID) && propertyIsModified) {
                        RepositoryPropertyReference propertyAsReference = new RepositoryPropertyReference(matchingObjectAsReference, iPropertyRO.getRepositoryPropertyType().getRepositoryPropertyTypeID());
                        messages.add(new EXDifferentPropertyValues(propertyAsReference, currentPropertyValue));
                        propertySamples.put((Object)propertyTypeID, (Object)new RepositoryPropertySample(toBeValue));
                    }
                    if (iPropertyRO.getRepositoryPropertyType().getOccuringRelationContributionType() == null) continue;
                    ImportTransactionFactory.compileOccurrenceSamples(iPropertyRO, propertyIsModified, matchingObject, (ICollectionRW_<IOccurrenceRepositoryRelationSample>)occurrenceRelationsToCreate, (ICollectionRW_<IOccurrenceRepositoryRelationReference>)occurrenceRelationsToDelete, repositorySnapshot, messages);
                }
            }
            catch (EXObjectReferenceCannotBeResolved e) {
                messages.add(new EXMissingObject(matchingObjectAsReference));
            }
        } else {
            RepositoryObjectReference objectToMerge = new RepositoryObjectReference(object.getObjectType().getObjectType().getRepositoryObjectTypeID(), object.getObjectID());
            messages.add(new EXMergeTargetNotSet(objectToMerge));
        }
        return new ObjectModificationInformation(isObjectTypeCatgeoryToBeModified, newObjectTypeCatgeoryID, (IMapRW_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)propertySamples, (ICollectionRW_<IOccurrenceRepositoryRelationSample>)occurrenceRelationsToCreate, (ICollectionRW_<IOccurrenceRepositoryRelationReference>)occurrenceRelationsToDelete);
    }

    private static void compileOccurrenceSamples(IPropertyRO property, boolean isModified, IRepositoryObject object, ICollectionRW_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate, ICollectionRW_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete, IRepositorySnapshotRO repositorySnapshot, MessageSet messages) throws EXNotReproducibleSnapshot {
        boolean isImportedValueAssumed = ImportJobHelper.isPropertyAssumingImportedValue(property, repositorySnapshot);
        if (object != null && (isModified || isImportedValueAssumed)) {
            ICollection_<? extends IOccurrenceRepositoryRelationReference> iCollection_ = ImportJobHelper.findExistingOccurrences(property, object);
            occurrenceRelationsToDelete.addAll(iCollection_);
        }
        if (isImportedValueAssumed) {
            for (IOccurrenceRelationRO iOccurrenceRelationRO : property.getOccurrenceRelations()) {
                if (!iOccurrenceRelationRO.getImportFlag()) continue;
                Tuple<IOccurrenceRepositoryRelationSample, IMessageSet> occurrenceRelationSample = ImportJobHelper.getOccurrenceRelationSample(iOccurrenceRelationRO);
                if (occurrenceRelationSample.getT1() != null) {
                    if (ImportTransactionFactory.removeOccurrenceFromCollection((IOccurrenceRepositoryRelationSample)occurrenceRelationSample.getT1(), occurrenceRelationsToDelete, repositorySnapshot)) continue;
                    occurrenceRelationsToCreate.add((Object)((IOccurrenceRepositoryRelationSample)occurrenceRelationSample.getT1()));
                    continue;
                }
                messages.addAll((IMessageSet)occurrenceRelationSample.getT2());
            }
        }
    }

    private static boolean removeOccurrenceFromCollection(IOccurrenceRepositoryRelationSample occurrence, ICollectionRW_<IOccurrenceRepositoryRelationReference> occurrenceCollection, IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        IIteratorRW_ listIterator = occurrenceCollection.iterator();
        while (listIterator.hasNext()) {
            IOccurrenceRepositoryRelation occurrenceRelationFromCollection;
            IOccurrenceRepositoryRelationReference listElement = (IOccurrenceRepositoryRelationReference)listIterator.next();
            if (!IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)listElement.getObjectIDofOccurrenceContainingObject(), (Object)occurrence.getObjectIDofOccurrenceContainingObject()) || !listElement.getOccurrenceID().equals(occurrence.getOccurrenceID()) || !IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)RepositoryObjects.getObjectID((occurrenceRelationFromCollection = RepositoryReferences.getFromReference(listElement, repositorySnapshot)).getOccuringObject()), (Object)occurrence.getObjectIDofOccuringObject())) continue;
            listIterator.remove();
            return true;
        }
        return false;
    }

    private final void addRelationsOfTypeToImportTransaction(ICrossLinkRelationTypeRO relationType, ImportTransactionCreationContext transactionCreationContext, IRepositorySnapshotRO repositorySnapshot, MessageSet messages) throws EXNotReproducibleSnapshot {
        ThreeTuple<ISet_<RelationSampleWithRelationCreationRequests>, ISet_<RelationSampleWithObjectTypes>, IMessageSet> explicitRequests = ImportJobHelper.getRelationSamplesForCreationAndDeletionRequests(relationType, this.importJob, repositorySnapshot);
        messages.addAll((IMessageSet)explicitRequests.getComponent3());
        HashSet_ creationRequests = new HashSet_((ICollection_)explicitRequests.getComponent1(), ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        HashSet_ deletionRequests = new HashSet_((ICollection_)explicitRequests.getComponent2(), ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        HashSet_ consideredCreationRequests = new HashSet_(creationRequests.size(), ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        HashSet_ consideredDeletionRequests = new HashSet_(deletionRequests.size(), ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        HashSet_ toBeImportedRelations = new HashSet_(relationType.getRelations().size(), ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        for (ICrossLinkRelationRO iCrossLinkRelationRO : relationType.getRelations()) {
            if (!iCrossLinkRelationRO.getImportFlag()) continue;
            Tuple<RelationSampleWithObjectTypes, IMessageSet> relationSampleAndMessages = ImportJobHelper.getRelationSampleForImportedRelation(iCrossLinkRelationRO);
            messages.addAll((IMessageSet)relationSampleAndMessages.getT2());
            ICrossLinkRepositoryRelationSample relationSample = (ICrossLinkRepositoryRelationSample)relationSampleAndMessages.getT1();
            if (relationSample == null) continue;
            toBeImportedRelations.add((Object)relationSample);
        }
        for (ICrossLinkRepositoryRelationSample iCrossLinkRepositoryRelationSample : toBeImportedRelations) {
            if (iCrossLinkRepositoryRelationSample == null) continue;
            if (!ImportTransactionFactory.relationExists(iCrossLinkRepositoryRelationSample, repositorySnapshot)) {
                transactionCreationContext.addRelationToCreate(iCrossLinkRepositoryRelationSample);
                messages.addAll(ImportTransactionFactory.generateMessagesForConflictingAttributeSets(iCrossLinkRepositoryRelationSample, relationType.getRelationType(), true, repositorySnapshot));
            }
            if (creationRequests.contains((Object)iCrossLinkRepositoryRelationSample)) {
                consideredCreationRequests.add((Object)iCrossLinkRepositoryRelationSample);
            }
            if (!deletionRequests.contains((Object)iCrossLinkRepositoryRelationSample)) continue;
            consideredDeletionRequests.add((Object)iCrossLinkRepositoryRelationSample);
        }
        creationRequests.removeAll((ICollection_)consideredCreationRequests);
        deletionRequests.removeAll((ICollection_)consideredDeletionRequests);
        deletionRequests.removeAll((ICollection_)creationRequests);
        for (ICrossLinkRepositoryRelationSample iCrossLinkRepositoryRelationSample : creationRequests) {
            if (ImportTransactionFactory.relationExists(iCrossLinkRepositoryRelationSample, repositorySnapshot)) continue;
            transactionCreationContext.addRelationToCreate(iCrossLinkRepositoryRelationSample);
            messages.addAll(ImportTransactionFactory.generateMessagesForConflictingAttributeSets(iCrossLinkRepositoryRelationSample, relationType.getRelationType(), true, repositorySnapshot));
        }
        for (ICrossLinkRepositoryRelationSample iCrossLinkRepositoryRelationSample : deletionRequests) {
            transactionCreationContext.addRelationToDelete(new CrossLinkRepositoryRelationReference(iCrossLinkRepositoryRelationSample.getRelationTypeID(), iCrossLinkRepositoryRelationSample.getRoleID2ObjectIDMap()));
            messages.addAll(ImportTransactionFactory.generateMessagesForConflictingAttributeSets(iCrossLinkRepositoryRelationSample, relationType.getRelationType(), false, repositorySnapshot));
        }
    }

    private static final boolean relationExists(ICrossLinkRepositoryRelationSample relationSample, IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        boolean[] relationExists = new boolean[1];
        try {
            ICrossLinkRepositoryRelation relation = RepositoryReferences.getRelationFromReference(new CrossLinkRepositoryRelationReference(relationSample.getRelationTypeID(), relationSample.getRoleID2ObjectIDMap()), repositorySnapshot);
            relationExists[0] = relation != null;
        }
        catch (EXMissingCrossLinkTarget eXMissingCrossLinkTarget) {
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved eXCrossLinkRelationReferenceCannotBeResolved) {
            // empty catch block
        }
        return relationExists[0];
    }

    private static final IMessageSet generateMessagesForConflictingAttributeSets(ICrossLinkRepositoryRelationSample modifiedRelation, ICrossLinkRepositoryRelationType relationType, boolean isExistenceCheckNecessary, IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        MessageSet messages = new MessageSet();
        for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationType.getAllRelationContributionTypes()) {
            if (relationContributionType.getRelatedAttributeSetType().getConflictType() != RepositoryAttributeSetTypeConflictType.IS_CONFLICTING) continue;
            IRepositoryPropertySetSample objectID = (IRepositoryPropertySetSample)modifiedRelation.getRoleID2ObjectIDMap().getByKey((Object)relationContributionType.getRepositoryRelationContributionRoleID());
            boolean[] isExisting = new boolean[]{true};
            if (isExistenceCheckNecessary && repositorySnapshot.findRepositoryObject(relationContributionType.getRelatedObjectType(), objectID) == null) {
                isExisting[0] = false;
            }
            if (!isExisting[0]) continue;
            IRepositoryRelationTypeID relationTypeID = relationType.getRepositoryRelationTypeID();
            IRepositoryRelationContributionRoleID roleID = relationContributionType.getRepositoryRelationContributionRoleID();
            messages.add(new EXConflictingCrossLinkRelationsChanged(relationTypeID, roleID, modifiedRelation.getObjectID(roleID)));
        }
        return messages;
    }

    private static class ObjectCreationInformation {
        private final IMapRW_<IRepositoryPropertyTypeID, IRepositoryPropertySample> propertySamples;
        private final ICollectionRW_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate;
        private final ICollectionRW_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete;

        public ObjectCreationInformation(IMapRW_<IRepositoryPropertyTypeID, IRepositoryPropertySample> propertySamples, ICollectionRW_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate, ICollectionRW_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete) {
            this.propertySamples = propertySamples;
            this.occurrenceRelationsToCreate = occurrenceRelationsToCreate;
            this.occurrenceRelationsToDelete = occurrenceRelationsToDelete;
        }

        public IMapRW_<IRepositoryPropertyTypeID, IRepositoryPropertySample> getPropertySamples() {
            return this.propertySamples;
        }

        public ICollectionRW_<IOccurrenceRepositoryRelationSample> getOccurrenceRelationsToCreate() {
            return this.occurrenceRelationsToCreate;
        }

        public ICollectionRW_<IOccurrenceRepositoryRelationReference> getOccurrenceRelationsToDelete() {
            return this.occurrenceRelationsToDelete;
        }
    }

    private static class ObjectModificationInformation
    extends ObjectCreationInformation {
        private final boolean isObjectTypeCatgeoryToBeModified;
        private final IRepositoryObjectTypeCategoryID newObjectTypeCatgeoryID;

        public ObjectModificationInformation(boolean isObjectTypeCatgeoryToBeModified, IRepositoryObjectTypeCategoryID newObjectTypeCatgeoryID, IMapRW_<IRepositoryPropertyTypeID, IRepositoryPropertySample> propertySamples, ICollectionRW_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate, ICollectionRW_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete) {
            super(propertySamples, occurrenceRelationsToCreate, occurrenceRelationsToDelete);
            this.isObjectTypeCatgeoryToBeModified = isObjectTypeCatgeoryToBeModified;
            this.newObjectTypeCatgeoryID = newObjectTypeCatgeoryID;
        }

        public boolean isObjectTypeCatgeoryToBeModified() {
            return this.isObjectTypeCatgeoryToBeModified;
        }

        public IRepositoryObjectTypeCategoryID getNewObjectTypeCatgeoryID() {
            return this.newObjectTypeCatgeoryID;
        }
    }
}

