/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.declaration.type.relationcontribution;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;

public final class RepositoryRelationContributionTypeCardinality {
    public static final RepositoryRelationContributionTypeCardinality C0_0 = new RepositoryRelationContributionTypeCardinality(0, 0);
    public static final RepositoryRelationContributionTypeCardinality C0_1 = new RepositoryRelationContributionTypeCardinality(0, 1);
    public static final RepositoryRelationContributionTypeCardinality C0_n = new RepositoryRelationContributionTypeCardinality(0, -1);
    public static final RepositoryRelationContributionTypeCardinality C1_1 = new RepositoryRelationContributionTypeCardinality(1, 1);
    public static final RepositoryRelationContributionTypeCardinality C1_n = new RepositoryRelationContributionTypeCardinality(1, -1);
    private final int min;
    private final int max;

    private static RepositoryRelationContributionTypeCardinality findCardinality(int min, int max) {
        RepositoryRelationContributionTypeCardinality cardinality;
        if (min == 0 && max == 0) {
            cardinality = C0_0;
        } else if (min == 0 && max == 1) {
            cardinality = C0_1;
        } else if (min == 0 && max < 0) {
            cardinality = C0_n;
        } else if (min == 1 && max == 1) {
            cardinality = C1_1;
        } else if (min == 1 && max < 0) {
            cardinality = C1_n;
        } else {
            throw new IllegalArgumentException();
        }
        return cardinality;
    }

    public static RepositoryRelationContributionTypeCardinality merge(RepositoryRelationContributionTypeCardinality a, RepositoryRelationContributionTypeCardinality b) throws EXCantMergeCardinalities {
        int mergedMin = Math.max(a.min, b.min);
        int mergedMax = a.max < 0 ? b.max : (b.max < 0 ? a.max : Math.min(a.max, b.max));
        if (mergedMax >= 0 && mergedMax < mergedMin) {
            throw new EXCantMergeCardinalities();
        }
        return RepositoryRelationContributionTypeCardinality.findCardinality(mergedMin, mergedMax);
    }

    private RepositoryRelationContributionTypeCardinality(int min, int max) {
        Assert.checkArgument((min >= 0 ? 1 : 0) != 0);
        this.min = min;
        this.max = max;
    }

    public boolean isMoreRestrictiveThan(RepositoryRelationContributionTypeCardinality c) {
        boolean isMoreRestrictive = false;
        isMoreRestrictive |= this.min > c.min;
        isMoreRestrictive |= this.max >= 0 && c.max < 0;
        return isMoreRestrictive |= this.max >= 0 && c.max >= 0 && this.max < c.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public boolean isMaximumInfinite() {
        return this.max < 0;
    }

    public String toString() {
        String minString = Integer.toString(this.min);
        String maxString = this.max < 0 ? "n" : Integer.toString(this.max);
        return String.valueOf(To.string((Object)this)) + " (" + minString + ".." + maxString + ")";
    }

    public static final class EXCantMergeCardinalities
    extends Exception {
    }

    public static abstract class Switch {
        public Switch(RepositoryRelationContributionTypeCardinality cardinality) {
            if (cardinality == C0_0) {
                this.case0_0();
            } else if (cardinality == C0_1) {
                this.case0_1();
            } else if (cardinality == C0_n) {
                this.case0_n();
            } else if (cardinality == C1_1) {
                this.case1_1();
            } else if (cardinality == C1_n) {
                this.case1_n();
            } else {
                Assert.illegalArgument();
            }
        }

        public abstract void case0_0();

        public abstract void case0_1();

        public abstract void case0_n();

        public abstract void case1_1();

        public abstract void case1_n();
    }
}

