/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.dataaccess;

import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.manager.EXRepositoryInterfaceNotFound;
import com.arcway.repository.interFace.plugin.extensions.RepositoryInterfaceManagerExtensionPoint;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;

public class RepositoryInterfaces {
    public static Object getRepositoryInterfaceReference(IRepositoryInterfaceRO repositoryInterface) {
        return RepositoryInterfaceManagerExtensionPoint.getInstance().getRepositoryInterfaceManager().getRepositoryInterfaceReference(repositoryInterface);
    }

    public static IRepositoryInterfaceRO getRepositoryInterface(Object repositoryInterfaceReference) throws EXRepositoryInterfaceNotFound {
        return RepositoryInterfaceManagerExtensionPoint.getInstance().getRepositoryInterfaceManager().getRepositoryInterface(repositoryInterfaceReference);
    }

    public static int getHashCodeForRepositoryInterfaceReference(Object repositoryInterfaceReference) {
        return RepositoryInterfaceManagerExtensionPoint.getInstance().getRepositoryInterfaceManager().getHashCodeForRepositoryInterfaceReference(repositoryInterfaceReference);
    }

    public static boolean areRepositoryInterfaceReferencesEqual(Object repositoryInterfaceReference1, Object repositoryInterfaceReference2) {
        return RepositoryInterfaceManagerExtensionPoint.getInstance().getRepositoryInterfaceManager().areRepositoryInterfaceReferencesEqual(repositoryInterfaceReference1, repositoryInterfaceReference2);
    }

    public static void doWithCurrentSnapshot(IRepositoryInterfaceRO repositoryInterface, IWithCurrentSnapshotProcessor processor) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryInterface.getTypeManager();
        IRepositoryPropertySetSample lastSnapshotID = null;
        boolean retry = true;
        while (retry) {
            retry = false;
            IRepositoryObjectSample currentSnapshotInformation = repositoryInterface.sampleCurrentSnapshotInformation();
            IRepositoryPropertySetSample currentSnapshotID = RepositorySamples.getSnapshotID(currentSnapshotInformation, repositoryTypeManager);
            if (lastSnapshotID != null && RepositorySamples.isEqual(currentSnapshotID, lastSnapshotID)) {
                throw new IllegalStateException();
            }
            try {
                IRepositorySnapshotRO currentSnapshot = repositoryInterface.openSnapshot(currentSnapshotID);
                try {
                    processor.doWithCurrentSnapshot(currentSnapshot);
                }
                finally {
                    currentSnapshot.closeSnapshot();
                }
            }
            catch (EXNotReproducibleSnapshot e) {
                retry = true;
                lastSnapshotID = currentSnapshotID;
            }
        }
    }

    public static IRepositorySnapshotRO openCurrentSnapshot(IRepositoryInterfaceRO repositoryInterface) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryInterface.getTypeManager();
        IRepositoryPropertySetSample lastSnapshotID = null;
        boolean retry = true;
        while (retry) {
            retry = false;
            IRepositoryObjectSample currentSnapshotInformation = repositoryInterface.sampleCurrentSnapshotInformation();
            IRepositoryPropertySetSample currentSnapshotID = RepositorySamples.getSnapshotID(currentSnapshotInformation, repositoryTypeManager);
            if (lastSnapshotID != null && RepositorySamples.isEqual(currentSnapshotID, lastSnapshotID)) {
                throw new IllegalStateException();
            }
            try {
                return repositoryInterface.openSnapshot(currentSnapshotID);
            }
            catch (EXNotReproducibleSnapshot e) {
                retry = true;
                lastSnapshotID = currentSnapshotID;
            }
        }
        return null;
    }
}

